/**************************************************************************
* libXicq - Originally written by tnc (xtrophy@it.dk)                     *
*'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''*
* ui2lib.h                                                                *
* Functions the UI will call to send packages                             *
**************************************************************************/


#ifndef _UI2LIB_H_
#define _UI2LIB_H_


#include "net.h"
#include "packets.h"
#include "structs.h"

#define SEND_TRUE_SERVER 1
#define SEND_TCP 2

void send_login();
void send_login_1();
void send_ack( int sequence );
void send_msgAck( int sequence );
void send_keepAlive();
void send_contactList();
void send_message( int type, unsigned int receiver, char *message );
void send_url( int type, unsigned int receiver, char *url, char *desc );
void send_statusChange( unsigned int status );
void send_uinSearch( unsigned int uin );
void send_logout();
void send_askAway( UIN uin );

int send_request_new_user( const char *passwd, USER_CONFIGURATION *user_cfg );
void send_change_info( const char *email, const char *nick, const char *first, const char *last );
unsigned short int send_userSearch( const char* email, const char* nick, const char* first, const char* last );
unsigned short int send_extInfoReply( unsigned int uin );
unsigned short int send_infoReply( unsigned int uin );
void send_auth(unsigned int uin);

char *returnMyStatus();
int status_str2num( char *str );

void send_TCP_CHAT_ACCEPT( UIN seq, UIN receiver );
int send_Chat( UIN uin, char *data, int len );
int send_chatRequest( UIN uin, char *mesg );
int chat_close( UIN uin );
int send_chatAccept( UIN uin );
int send_chatCancel( UIN uin, char *mesg );

void send_web();
void send_web_finisch();


#endif
