/**
   ************************************************************************
   * libXicq - Originally written by tnc (xtrophy@it.dk)                     *
   *'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''*
   * parse.cpp                                                               *
   * Parse incomming packets                                                 *
   **************************************************************************/


#include "parse.h"


extern USER_CONFIGURATION user_config;
extern CALLBACK_FUNCTIONS callback;
extern NET_INFORMATION net_information;
extern CONTACT contactList[ MAXCONTACT ];
extern int contactNum;
extern int contact2Uin[ 10 ];
/*
   ** Parse received packets and activate the callback function for it
   ** Returns -1 if something goes wrong
*/
int logincounter = 0;
void loggedin()
{

}


int parse( ICQ_PACKET *packet )
{
    switch ( packet->command )
    {
        case S_NEW_USER_UIN:
            {
                if ( KXDEBUG )
                    misc_log( "got new UIN !" );
                send_ack( packet->sequence );
                parse_S_new_user( packet );
                break;
            }
        case S_ACK: // Server acked a received package
            {
                if ( KXDEBUG )
                    printf( "Got ack. (%02x)\n", packet->sequence );

                break;
            }
        case S_LOGIN_REPLY: // Server acked out login packet
            {
                if ( KXDEBUG )
                    misc_log( "Got login reply." );

                send_ack( packet->sequence );
                user_config.status = user_config.defaultStatus;
                send_statusChange( user_config.status );
                parse_S_LOGIN( packet );
                send_login_1();
                send_contactList();
                logincounter = 0;
                ( *callback.loggedIn ) ();

                for ( int i = 0; i <= contactNum; i++ )
                {
                    if ( ( UIN ) atoi( contactList[ i ].nick ) == contactList[ i ].uin )
                    {
                        for ( int t = 0; t < 10; t++ )
                        {
                            if ( contact2Uin[ t ] == 0 )
                            {
                                contact2Uin[ t ] = ( int ) send_infoReply( contactList[ i ].uin );
                                t = 11;
                            }
                        }
                    }
                }
                break;
            }
        case S_USER_ONLINE: // Someone from the contact list is online
            {
                if ( KXDEBUG )
                    misc_log( "Got user online." );
                send_ack( packet->sequence );
                parse_S_USER_ONLINE( packet );
                break;
            }
        case S_USER_OFFLINE: // Someone logged out
            {
                if ( KXDEBUG )
                    misc_log( "Got user offline." );
                send_ack( packet->sequence );
                parse_S_USER_OFFLINE( packet );
                break;
            }
        case S_STATUS_UPDATE: // A user have changed status
            {
                if ( KXDEBUG )
                    misc_log( "Got user status change." );
                send_ack( packet->sequence );
                parse_S_STATUS_UPDATE( packet );
                break;
            }
        case S_GET_MESSAGE: // MSG sent while online
            {
                send_ack( packet->sequence );
                parse_S_GET_MESSAGE( packet, 1 );
                break;
            }
        case S_RECEIVE_MESSAGE: // MSG send while offline
            {
                send_msgAck( packet->sequence );
                send_ack( packet->sequence );
                parse_S_GET_MESSAGE( packet, 0 );
                break;
            }
        case S_USER_FOUND:  // User matched our query
            {
                send_ack( packet->sequence );
                parse_S_USER_FOUND( packet );
                break;
            }
        case S_END_OF_SEARCH: // No more users matching, or too many found
            {
                if ( KXDEBUG )
                    printf( "end of search\n" );
                send_ack( packet->sequence );
                break;
            }
        case S_GO_AWAY: // We've been idle,
        case S_DISCONNECTED: // We got disconnected?
            {
                //contact_init(user_config.contactList);
                ( *callback.disconnected ) ();
            }
        case S_REPLY_X1: // Unknown packet, sent during login
            {
                if ( KXDEBUG )
                    misc_log( "Got unknown login reply." );
                send_ack( packet->sequence );
                break;
            }
        case S_REPLY_X2: // Unknown packet, sent during login
            {
                if ( KXDEBUG )
                    misc_log( "Got unknown login reply." );
                send_ack( packet->sequence );
                break;
            }
        case S_INFO_REPLY:
            {
                parse_S_INFO_REPLY( packet );
                send_ack( packet->sequence );
                break;
            }
        case S_EXT_INFO_REPLY:
            {
                parse_S_EXT_INFO_REPLY( packet );
                send_ack( packet->sequence );
                break;
            }
        case S_TRY_AGAIN:
            {
                send_ack( packet->sequence );
                send_login();
                break;
            }
        case S_UPDATE_REPLY:
            {
                // update was ok !!
                send_ack( packet->sequence );
                break;
            }
        case S_INVALID_UIN:
            send_ack( packet->sequence );
            printf( "WRONG UIN\n" );
            //(*callback.unknownReply)(UUIN);
            break;
        case S_WRONG_PASSWORD:
            send_ack( packet->sequence );
            ( *callback.unknownReply ) ( PASSWD );
            break;
    case S_WEB_ACK:
        send_web_finisch();
        break;
        default:
            {
                //if (KXDEBUG)
                {
                    char tmp[ BUFSIZE ];
                    sprintf( tmp, "Unknown packet, CMD: %04X - SEQ: %d", packet->command, packet->sequence );
                    misc_log( tmp );
                }

                send_ack( packet->sequence );
            }
    }

    //misc_printPacket(packet);
    return - 1;
}

void parse_S_new_user( ICQ_PACKET *packet )
{
    unsigned int * uin;

    uin = ( unsigned int * ) ( packet->data + 8 );
    user_config.uin = *uin;
    ( *callback.newUin ) ( *uin );
    if ( KXDEBUG )
    {
        printf( "new uin: %d\n", *uin );
    }
}

/*
   ** 
   ** User from contact list is online, find out who, and notify the UI
*/
void parse_S_USER_ONLINE( ICQ_PACKET *packet )
{
    CONTACT contact;

    unsigned int *uin, *ip, *real_ip;
    unsigned int *status;
    unsigned short int *port;

    uin = ( unsigned int * ) ( packet->data + 6 );
    status = ( unsigned int * ) ( packet->data + 23 );
    ip = ( unsigned int * ) ( packet->data + 10 );
    real_ip = ( unsigned int * ) ( packet->data + 18 );
    port = ( unsigned short int * ) ( packet->data + 14 );


    contact = contact_returnContact( *uin );

    contact.uin = *uin;
    contact.status = *status;
    contact.ip = icqToIp( *ip );
    contact.port = *port;
    //   contact.real_ip=icqToIp(*real_ip);

    contact_updateContact( contact );

    send_ack( packet->sequence );
    // printf("tcp?\n");
    //   tcp_openConnection(*uin);
    ( *callback.updateContact ) ( *uin );
}


/*
   ** 
   ** User from contact list is offline, find out who, and notify the UI
*/
void parse_S_USER_OFFLINE( ICQ_PACKET *packet )
{
    CONTACT contact;
    unsigned int *uin;
    uin = ( unsigned int * ) ( packet->data + 6 );

    contact = contact_returnContact( *uin );

    contact.uin = *uin;
    contact.status = STATUS_OFFLINE;
    contact.sock = -1;

    contact_updateContact( contact );

    send_ack( packet->sequence );

    ( *callback.updateContact ) ( *uin );
}


/*
   ** 
   ** User from contact list has changed status, find out who, and notify the UI
*/
void parse_S_STATUS_UPDATE( ICQ_PACKET *packet )
{
    CONTACT contact;
    unsigned int *uin;
    unsigned int *status;
    uin = ( unsigned int * ) ( packet->data + 6 );
    status = ( unsigned int * ) ( packet->data + 10 );

    contact = contact_returnContact( *uin );

    contact.uin = *uin;
    contact.status = *status;

    contact_updateContact( contact );

    send_ack( packet->sequence );

    ( *callback.updateContact ) ( *uin );
}


/*
   ** 
   ** Got a message packet, find out if it contains a message or an URL
*/
void parse_S_GET_MESSAGE( ICQ_PACKET *packet, int online )
{
    unsigned short int * type;

    if ( online )
        type = ( unsigned short int * ) ( packet->data + 10 );
    else
        type = ( unsigned short int * ) ( packet->data + 16 );

    switch ( *type )
    {
        case 0x0001: // Message
            {
                if ( KXDEBUG )
                    misc_log( "Got message." );

                parse_message( packet, online );
                break;
            }
        case 0x0004: // URL
            {
                if ( KXDEBUG )
                    misc_log( "Got URL." );

                parse_url( packet, online );
                break;
            }
        case 0x000C: // You've been added.
            {
                if ( KXDEBUG )
                    misc_log( "Got You've been added." );

                parse_added( packet, online );
                break;
            }
    case 0x0006:  // auth message...
        {
            if (KXDEBUG)
                misc_log("Auth message.");
            parse_auth(packet,online);
            break;
        }
    }
}


/*
   ** 
   ** Got a message, translate it, and notify the UI
*/
void parse_message( ICQ_PACKET *packet, int online )
{
    unsigned int * uin = ( unsigned int * ) ( packet->data + 6 );

    if ( online )
    {
        unsigned short int * msgLength = ( unsigned short int * ) ( packet->data + 12 );
        unsigned char *msg = ( unsigned char * ) ( packet->data + 14 );

        time_t t = time( NULL );
        tm *t2 = localtime( &t );

        MESSAGE message;
        message.online = 1;
        message.time.year = t2->tm_year + 1900;
        message.time.month = t2->tm_mon + 1;
        message.time.day = t2->tm_mday;
        message.time.hour = t2->tm_hour;
        message.time.min = t2->tm_min;
        message.sender = *uin;
        message.length = *msgLength;
        message.message = ( char * ) msg;

        ( *callback.message ) ( &message );
    } else
    {
        unsigned short int *year = ( unsigned short int * ) ( packet->data + 10 );
        unsigned char *month = ( unsigned char * ) ( packet->data + 12 );
        unsigned char *day = ( unsigned char * ) ( packet->data + 13 );
        unsigned char *hour = ( unsigned char * ) ( packet->data + 14 );
        unsigned char *min = ( unsigned char * ) ( packet->data + 15 );
        unsigned short int *msgLength = ( unsigned short int * ) ( packet->data + 18 );
        unsigned char *msg = ( unsigned char * ) ( packet->data + 20 );

        MESSAGE message;
        message.online = 0;
        message.time.year = *year;
        message.time.month = *month;
        message.time.day = *day;
        message.time.hour = *hour;
        message.time.min = *min;
        message.sender = *uin;
        message.length = *msgLength;
        message.message = ( char * ) msg;

        ( *callback.message ) ( &message );
    }
}


/*
   ** 
   ** Got an URL, translate it, and notify the UI
*/
void parse_url( ICQ_PACKET *packet, int online )
{
    unsigned int * uin = ( unsigned int * ) ( packet->data + 6 );

    if ( online )
    {
        unsigned char * msg = ( unsigned char * ) ( packet->data + 14 );

        char *string;
        string = ( char * ) msg;
        //string = strdup((char *)msg);
        unsigned int t1,p=0,g=0;
        char *desc=(char *)malloc(strlen((char *)msg));
        char *_url=(char *)malloc(strlen((char *)msg));
        for (t1=0; t1<strlen((char *)msg); t1++)
        {
            if (msg[t1]==0xFE)
            {
                p=0;
                g++;
            }
            else
            {
                switch(g)
                {
                case 0:
                    desc[p++]=msg[t1];
                    break;
                case 1:
                    _url[p++]=msg[t1];
                    break;
                }
            }
        }
                    
                
/*        char tmp[ 2 ];
        tmp[ 0 ] = 0xFE;
        tmp[ 1 ] = '\0';
        char *desc = strsep( &string, tmp );
        char *_url = strsep( &string, "" );*/

        time_t t = time( NULL );
        tm *t2 = localtime( &t );

        URL url;
        url.online = 1;
        url.time.year = t2->tm_year + 1900;
        url.time.month = t2->tm_mon + 1;
        url.time.day = t2->tm_mday;
        url.time.hour = t2->tm_hour;
        url.time.min = t2->tm_min;
        url.sender = *uin;
        url.url = ( char * ) _url;
        url.desc = ( char * ) desc;

        ( *callback.url ) ( &url );
    }
    else
    {
        unsigned short int *year = ( unsigned short int * ) ( packet->data + 10 );
        unsigned char *month = ( unsigned char * ) ( packet->data + 12 );
        unsigned char *day = ( unsigned char * ) ( packet->data + 13 );
        unsigned char *hour = ( unsigned char * ) ( packet->data + 14 );
        unsigned char *min = ( unsigned char * ) ( packet->data + 15 );
        unsigned char *msg = ( unsigned char * ) ( packet->data + 20 );

/*        char *string;
        string = ( char * ) msg;
        //string = strdup((char *)msg);
        char tmp[ 2 ];
        tmp[ 0 ] = 0xFE;
        tmp[ 1 ] = '\0';
        char *desc = strsep( &string, tmp );
        char *_url = strsep( &string, "" );*/

        char *string;
        string = ( char * ) msg;
        //string = strdup((char *)msg);
        unsigned int t1,p=0,g=0;
        char *desc=(char *)malloc(strlen((char *)msg));
        char *_url=(char *)malloc(strlen((char *)msg));
        for (t1=0; t1<strlen((char *)msg); t1++)
        {
            if (msg[t1]==0xFE)
            {
                p=0;
                g++;
            }
            else
            {
                switch(g)
                {
                case 0:
                    desc[p++]=msg[t1];
                    break;
                case 1:
                    _url[p++]=msg[t1];
                    break;
                }
            }
        }


        URL url;
        url.time.year = *year;
        url.time.month = *month;
        url.time.day = *day;
        url.time.hour = *hour;
        url.time.min = *min;
        url.sender = *uin;
        url.url = ( char * ) _url;
        url.desc = ( char * ) desc;

        ( *callback.url ) ( &url );
    }
}


/*
   ** 
   ** You were added to a contact list, find out whos, and notify the UI
*/
void parse_auth( ICQ_PACKET *packet, int online )
{
    unsigned int * uin = ( unsigned int * ) ( packet->data + 6 );

    if ( online )
    {
        unsigned char * msg = ( unsigned char * ) ( packet->data + 14 );

        char *string;
        string = ( char * ) msg;
        //string = strdup((char *)msg);
        char tmp[ 2 ];
        tmp[ 0 ] = 0xFE;
        tmp[ 1 ] = '\0';

        char *nick = strsep( &string, tmp );
        char *firstName = strsep( &string, tmp );
        char *lastName = strsep( &string, tmp );
        char *email = strsep( &string, tmp );
        char *auth = strsep( &string, tmp );
        char *text = strsep( &string, "" );
        
        time_t t = time( NULL );
        tm *t2 = localtime( &t );

        ADDED added;
        added.online = 1;
        added.time.year = t2->tm_year;
        added.time.month = t2->tm_mon + 1;
        added.time.day = t2->tm_mday;
        added.time.hour = t2->tm_hour;
        added.time.min = t2->tm_min;
        added.sender = *uin;
        added.nick = ( char * ) nick;
        added.firstName = ( char * ) firstName;
        added.lastName = ( char * ) lastName;
        added.email = ( char * ) email;
        added.auth_req=1;
        added.auth_text=(char *) text;
        
        printf("text: %s\n",added.auth_text);
        
        if ( auth[ 0 ] == '0' )
            added.auth = 0; // You need authorization to add this user
        else
            added.auth = 1; // You don't need authorization to add this user

        ( *callback.added ) ( &added );
    }
    else
    {
        unsigned short int *year = ( unsigned short int * ) ( packet->data + 10 );
        unsigned char *month = ( unsigned char * ) ( packet->data + 12 );
        unsigned char *day = ( unsigned char * ) ( packet->data + 13 );
        unsigned char *hour = ( unsigned char * ) ( packet->data + 14 );
        unsigned char *min = ( unsigned char * ) ( packet->data + 15 );
        unsigned char *msg = ( unsigned char * ) ( packet->data + 20 );

        char *string;
        string = ( char * ) msg;
        //string = strdup((char *)msg);
        char tmp[ 2 ];
        tmp[ 0 ] = 0xFE;
        tmp[ 1 ] = '\0';
        char *nick = strsep( &string, tmp );
        char *firstName = strsep( &string, tmp );
        char *lastName = strsep( &string, tmp );
        char *email = strsep( &string, tmp );
        char *auth = strsep( &string, tmp );
        char *text= strsep( &string, "" );

        ADDED added;
        added.online = 0;
        added.time.year = *year;
        added.time.month = *month;
        added.time.day = *day;
        added.time.hour = *hour;
        added.time.min = *min;
        added.sender = *uin;
        added.nick = ( char * ) nick;
        added.firstName = ( char * ) firstName;
        added.lastName = ( char * ) lastName;
        added.email = ( char * ) email;
        added.auth_req=1;
        added.auth_text=(char *) text;
        printf("text: %s\n",added.auth_text);
        if ( auth[ 0 ] == '0' )
            added.auth = 0; // You need authorization to add the user
        else
            added.auth = 1; // You don't need authorization to add this user

        ( *callback.added ) ( &added );
    }
}

void parse_added( ICQ_PACKET *packet, int online )
{
    unsigned int * uin = ( unsigned int * ) ( packet->data + 6 );

    if ( online )
    {
        unsigned char * msg = ( unsigned char * ) ( packet->data + 14 );

        char *string;
        string = ( char * ) msg;
        //string = strdup((char *)msg);
        char tmp[ 2 ];
        tmp[ 0 ] = 0xFE;
        tmp[ 1 ] = '\0';

        char *nick = strsep( &string, tmp );
        char *firstName = strsep( &string, tmp );
        char *lastName = strsep( &string, tmp );
        char *email = strsep( &string, tmp );
        char *auth = strsep( &string, "" );

        time_t t = time( NULL );
        tm *t2 = localtime( &t );

        ADDED added;
        added.online = 1;
        added.time.year = t2->tm_year;
        added.time.month = t2->tm_mon + 1;
        added.time.day = t2->tm_mday;
        added.time.hour = t2->tm_hour;
        added.time.min = t2->tm_min;
        added.sender = *uin;
        added.nick = ( char * ) nick;
        added.firstName = ( char * ) firstName;
        added.lastName = ( char * ) lastName;
        added.email = ( char * ) email;
        added.auth_req=0;
        if ( auth[ 0 ] == '0' )
            added.auth = 0; // You need authorization to add this user
        else
            added.auth = 1; // You don't need authorization to add this user

        ( *callback.added ) ( &added );
    }
    else
    {
        unsigned short int *year = ( unsigned short int * ) ( packet->data + 10 );
        unsigned char *month = ( unsigned char * ) ( packet->data + 12 );
        unsigned char *day = ( unsigned char * ) ( packet->data + 13 );
        unsigned char *hour = ( unsigned char * ) ( packet->data + 14 );
        unsigned char *min = ( unsigned char * ) ( packet->data + 15 );
        unsigned char *msg = ( unsigned char * ) ( packet->data + 20 );

        char *string;
        string = ( char * ) msg;
        //string = strdup((char *)msg);
        char tmp[ 2 ];
        tmp[ 0 ] = 0xFE;
        tmp[ 1 ] = '\0';
        char *nick = strsep( &string, tmp );
        char *firstName = strsep( &string, tmp );
        char *lastName = strsep( &string, tmp );
        char *email = strsep( &string, tmp );
        char *auth = strsep( &string, "" );

        ADDED added;
        added.online = 0;
        added.time.year = *year;
        added.time.month = *month;
        added.time.day = *day;
        added.time.hour = *hour;
        added.time.min = *min;
        added.sender = *uin;
        added.nick = ( char * ) nick;
        added.firstName = ( char * ) firstName;
        added.lastName = ( char * ) lastName;
        added.email = ( char * ) email;
        added.auth_req=0;

        if ( auth[ 0 ] == '0' )
            added.auth = 0; // You need authorization to add the user
        else
            added.auth = 1; // You don't need authorization to add this user

        ( *callback.added ) ( &added );
    }
}


/*
   **
   ** A user was found matching our latest search query
*/
void parse_S_USER_FOUND( ICQ_PACKET *packet )
{
    unsigned int * uin;
    unsigned short int *nickLength;
    unsigned char *nick;
    unsigned short int *firstLength;
    unsigned char *first;
    unsigned short int *lastLength;
    unsigned char *last;
    unsigned short int *emailLength;
    unsigned char *email;
    unsigned char *auth;
    unsigned short int	*seq;
    int pos = 6;

    seq = ( unsigned short int * ) ( packet->data + pos );

    pos = 8;

    uin = ( unsigned int * ) ( packet->data + pos ); pos += 4;
    nickLength = ( unsigned short int * ) ( packet->data + pos ); pos += 2;
    nick = ( unsigned char * ) ( packet->data + pos ); pos += *nickLength;
    firstLength = ( unsigned short int * ) ( packet->data + pos ); pos += 2;
    first = ( unsigned char * ) ( packet->data + pos ); pos += *firstLength;
    lastLength = ( unsigned short int * ) ( packet->data + pos ); pos += 2;
    last = ( unsigned char * ) ( packet->data + pos ); pos += *lastLength;
    emailLength = ( unsigned short int * ) ( packet->data + pos ); pos += 2;
    email = ( unsigned char * ) ( packet->data + pos ); pos += *emailLength+1;
    auth = ( unsigned char * ) ( packet->data + pos );

    SEARCH_RESULT result;
    result.uin = *uin;
    result.nick = ( char * ) nick;
    result.firstName = ( char * ) first;
    result.lastName = ( char * ) last;
    result.email = ( char * ) email;
    result.seq = *seq;
    if ( KXDEBUG ) printf( "seg..: %d\n", *seq );
    if ( *auth == 0 )
        result.auth = 0; // You need authorization to add the user
    else
        result.auth = 1; // You don't need authorization to add this user

    ( *callback.searchResult ) ( &result );
}

void parse_S_INFO_REPLY( ICQ_PACKET *packet )
{
    unsigned int * uin;
    unsigned short int *nickLength;
    unsigned char *nick;
    unsigned short int *firstLength;
    unsigned char *first;
    unsigned short int *lastLength;
    unsigned char *last;
    unsigned short int *emailLength;
    unsigned char *email;
    unsigned char *auth;
    unsigned short int	*seq;
    int pos = 6;

    seq = ( unsigned short int * ) ( packet->data + pos );

    pos = 8;

    uin = ( unsigned int * ) ( packet->data + pos ); pos += 4;
    nickLength = ( unsigned short int * ) ( packet->data + pos ); pos += 2;
    nick = ( unsigned char * ) ( packet->data + pos ); pos += *nickLength;
    firstLength = ( unsigned short int * ) ( packet->data + pos ); pos += 2;
    first = ( unsigned char * ) ( packet->data + pos ); pos += *firstLength;
    lastLength = ( unsigned short int * ) ( packet->data + pos ); pos += 2;
    last = ( unsigned char * ) ( packet->data + pos ); pos += *lastLength;
    emailLength = ( unsigned short int * ) ( packet->data + pos ); pos += 2;
    email = ( unsigned char * ) ( packet->data + pos ); pos += *emailLength+1;
    auth = ( unsigned char * ) ( packet->data + pos );

    SEARCH_RESULT result;
    result.uin = *uin;
    result.nick = ( char * ) nick;
    result.firstName = ( char * ) first;
    result.lastName = ( char * ) last;
    result.email = ( char * ) email;
    result.seq = *seq;
    if ( KXDEBUG ) printf( "seg..: %d\n", *seq );
    if ( *auth == 0 )
        result.auth = 0; // You need authorization to add the user
    else
        result.auth = 1; // You don't need authorization to add this user

    for ( int t = 0; t < 10; t++ )
    {
        if ( contact2Uin[ t ] == *seq )
        {
            contact2Uin[ t ] = 0;
            for ( int i = 0; i <= contactNum; i++ )
            {
                if ( *uin == contactList[ i ].uin )
                {
                    if ( strlen( ( char * ) nick ) > 0 )
                    {
                        strcpy( contactList[ i ].nick, ( char * ) nick );
                        ( *callback.nickChange ) ( *uin, ( char * ) nick, contactList[ i ].status );
                        return;
                    }
                    else
                    {
                        strcpy( ( char * ) nick, "<No Nick>" );
                        strcpy( contactList[ i ].nick, ( char * ) nick );
                        ( *callback.nickChange ) ( *uin, ( char * ) nick, contactList[ i ].status );
                        return;
                    }
                }
            }
        }
    }

    ( *callback.infoResult ) ( &result );
}
void parse_S_EXT_INFO_REPLY( ICQ_PACKET *packet )
{
    unsigned int * uin;
    unsigned short int *cityLength;
    unsigned char *city;
    unsigned short int *stateLength;
    unsigned char *state;
    unsigned short int *home_pageLength;
    unsigned char *home_page;
    unsigned short int *aboutLength;
    unsigned char *about;
    unsigned short int *phoneLength;
    unsigned char *phone;
    unsigned short int *country_code;
    unsigned short int *age;
    unsigned char	*sex;
    unsigned char	*cstatus;

    unsigned short int	*seq;
    int pos = 6;

    seq = ( unsigned short int * ) ( packet->data + pos );

    pos = 8;

    uin = ( unsigned int * ) ( packet->data + pos ); pos += 4;
    cityLength = ( unsigned short int * ) ( packet->data + pos ); pos += 2;
    city = ( unsigned char * ) ( packet->data + pos ); pos += *cityLength;
    country_code = ( unsigned short int * ) ( packet->data + pos ); pos += 2;
    cstatus = ( unsigned char * ) ( packet->data + pos ); pos += 1;
    stateLength = ( unsigned short int * ) ( packet->data + pos ); pos += 2;
    state = ( unsigned char * ) ( packet->data + pos ); pos += *stateLength;
    age = ( unsigned short int * ) ( packet->data + pos ); pos += 2;
    sex = ( unsigned char * ) ( packet->data + pos ); pos += 1;
    phoneLength = ( unsigned short int * ) ( packet->data + pos ); pos += 2;
    phone = ( unsigned char * ) ( packet->data + pos ); pos += *phoneLength;
    home_pageLength = ( unsigned short int * ) ( packet->data + pos ); pos += 2;
    home_page = ( unsigned char * ) ( packet->data + pos ); pos += *home_pageLength;
    aboutLength = ( unsigned short int * ) ( packet->data + pos ); pos += 2;
    about = ( unsigned char * ) ( packet->data + pos ); pos += *aboutLength;

    EXT_SEARCH_RESULT result;
    result.uin = *uin;
    result.city	= ( char* ) city;
    result.state	= ( char * ) state;
    result.home_page	= ( char * ) home_page;
    result.about	= ( char * ) about;
    result.phone	= ( char * ) phone;
    result.age = *age;
    result.sex	= *sex;

    result.seq = *seq;
    if ( KXDEBUG ) printf( "seg..: %d\n", *seq );

    ( *callback.extInfoResult ) ( &result );
}

void parse_S_LOGIN( ICQ_PACKET *packet )
{
    unsigned int * ourIp;
    unsigned int oIp;
    ourIp = ( unsigned int * ) ( packet->data + 10 );
    oIp = icqToIp( *ourIp );
    net_information.clientAddr = oIp;
}

int parseTCP( unsigned char *packet, int sock, int mlen )
{
    unsigned int * seq;
    if ( KXDEBUG ) printf( "===========parse TCP packet: (len: %d)===============\n", mlen );

    if (!packet) return 0;
    
    char *buf;
    buf = ( char * ) malloc( BUFSIZE );
    //   char desc[BUFSIZE];
    //   char _url[BUFSIZE];

    if ( KXDEBUG )
    {
        for ( int r = 0; r < mlen; r++ )
        {
            printf( "[%02x] ", packet[ r ] );
        }
    }
    unsigned char *handshake;
    UIN *uin;
    handshake = ( unsigned char * ) ( packet );
    int y;
    if ( *handshake == 0xff )
    {
        //printf("HANDSHAKE");

        uin = ( UIN * ) ( packet + 9 );
        while ( 1 )
        {
            for ( y = 0; y <= contactNum; y++ )
            {
                if ( contactList[ y ].uin == *uin )
                {
                    contactList[ y ].sock = sock;
                    //	    FD_SET(0, &contactList[y].fd);
                    contactList[ y ].tvt.tv_sec = 0;
                    contactList[ y ].tvt.tv_usec = 5;
                    fcntl( sock, O_NONBLOCK );
                    fcntl( sock, O_RDWR );
                    return - 2;
                }
            }
            char tmp[ BUFSIZE ];
            UIN tt = *uin;
            sprintf( tmp, "%d", tt );
            contact_add( tmp, tt );
        }
    }
    else
    {
        int chat = 0;
        UIN *uin, *uin2;
        unsigned short int *command, *msglen, *msgtype, *version;
        unsigned int *ipa, *ipb, *port, *status, read_away = 0;
        int pos = 0, len = 0;

        uin = ( UIN * ) ( packet ); pos += 4;
        version = ( unsigned short int * ) ( packet + pos ); pos += 2;
        command = ( unsigned short int * ) ( packet + pos ); pos += 4;
        uin2 = ( UIN * ) ( packet + pos ); pos += 4;
        msgtype = ( unsigned short int * ) ( packet + pos ); pos += 2;
        msglen = ( unsigned short int * ) ( packet + pos ); pos += 2;
        if ( KXDEBUG )
        {
            printf( "uin: %d, command: %x, msgtype: %x, version %d\n", *uin, *command, *msgtype, *version );
            printf( "memcpy len: %d\n", *msglen );
        }
        if ( *msglen > 0 )
        {
            if (*msglen>1024)
            {
                if (buf)
                    free(buf);
                return 0;
            }
            memcpy( buf, packet + pos, *msglen ); pos += *msglen;
        }
        else
        {
            strcpy( buf, "" );
        }
        len = pos;

        ipa = ( unsigned int * ) ( packet + pos ); pos += 4;
        ipb = ( unsigned int * ) ( packet + pos ); pos += 4;
        port = ( unsigned int * ) ( packet + pos ); pos += 4;
        unsigned char *tt;
        tt = ( unsigned char * ) ( packet + pos ); pos += 1;
        status = ( unsigned int * ) ( packet + pos ); pos += 4;
        seq = ( unsigned int * ) ( packet + ( mlen - 4 ) );

        time_t t = time( NULL );
        tm *t2 = localtime( &t );
        for ( y = 0; y <= contactNum; y++ )
        {
            if ( contactList[ y ].uin == *uin )
            {
                unsigned int os = contactList[ y ].status;
                switch ( *status )
                {
                    case TCP_ONLINE:
                        contactList[ y ].status = STATUS_ONLINE;
                        break;
                    case TCP_AWAY:
                        contactList[ y ].status = STATUS_AWAY;
                        break;
                    case TCP_NA:
                        contactList[ y ].status = STATUS_NA;
                        break;
                    case TCP_DND:
                        contactList[ y ].status = STATUS_DND;
                        break;
                    case TCP_OCC:
                        contactList[ y ].status = STATUS_OCCUPIED;
                        break;
                    default:
                        contactList[ y ].status = STATUS_ONLINE;
                        break;
                }
                if ( contactList[ y ].status != os )
                    ( *callback.updateContact ) ( contactList[ y ].uin );
            }
        }
        switch ( *command )
        {
            case TCP_START:
                switch ( *msgtype )
                {
                    case TCP_MSG:

                        MESSAGE message;
                        message.online = 1;
                        message.time.year = t2->tm_year + 1900;
                        message.time.month = t2->tm_mon + 1;
                        message.time.day = t2->tm_mday;
                        message.time.hour = t2->tm_hour;
                        message.time.min = t2->tm_min;
                        message.sender = *uin;
                        message.length = *msglen;
                        message.message = ( char * ) buf;

                        ( *callback.message ) ( &message );

                        break;
                    case TCP_URL:
                        URL url;
                        url.online = 1;
                        url.time.year = t2->tm_year + 1900;
                        url.time.month = t2->tm_mon + 1;
                        url.time.day = t2->tm_mday;
                        url.time.hour = t2->tm_hour;
                        url.time.min = t2->tm_min;
                        url.sender = *uin;

                        char *string;
                        string = ( char * ) buf;
                        //string = strdup((char *)msg);
                        char tmp[ 2 ];
                        tmp[ 0 ] = 0xFE;
                        tmp[ 1 ] = '\0';
                        url.desc = strsep( &string, tmp );
                        url.url = strsep( &string, "" );

                        ( *callback.url ) ( &url );

                        break;
                    case TCP_CHAT:
                        char *reqmsg;
                        reqmsg = ( char * ) malloc( strlen( buf ) + 1 );
                        strcpy( reqmsg, buf );
                        parse_TCP_CHAT( *seq, *uin, reqmsg );
                        chat = 1;
                        break;
                    case TCP_FILE:
                        break;
                    case TCP_READAWAYMSG:
                        read_away = 1;
                        break;
                }
                for ( y = 0; y <= contactNum; y++ )
                {
                    if ( contactList[ y ].uin == *uin )
                    {
                        unsigned char * msgtmp;
                        msgtmp = ( unsigned char* ) malloc( BUFSIZE );
                        if ( read_away == 1 )
                        {
                            msgtmp[ 0 ] = 1;
                            msgtmp[ 1 ] = 2;
                            msgtmp[ 2 ] = 0;
                        }
                        else
                        {
                            strcpy( ( char * ) msgtmp, "" );
                        }
                        if ( !chat ) net_tcpSend( msgtmp, *msgtype, y, TCP_ACK, *seq );
                        free( msgtmp );
                    }
                }
                break;
            case TCP_CANCEL:
                switch ( *msgtype )
                {
                case TCP_CHAT:
                    if (KXDEBUG) printf("cancel chat\n");
                        for ( int i = 0; i <= contactNum; i++ )
                        {
                            if ( *uin == contactList[ i ].uin )
                            {
                                if ( contactList[ i ].listensock > 0 )
                                {
                                    close( contactList[ i ].listensock );
                                    contactList[ i ].listensock = -1;
                                    ( *callback.showAway ) ( "Chat canceld\n\nNo Reason Given", *uin );
                                }
                            }
                        }
                }
                break;
            case TCP_ACK:
                switch ( *msgtype )
                {
                    case TCP_CHAT:
                        UIN *cport,*p2;
                        cport = ( unsigned int * ) ( packet + ( mlen - 8 ) );
                        p2=( unsigned int * ) ( packet + ( mlen - 12 ) );
                        if (*cport==0) *cport=(*p2>>8) | ((*p2&255)<<8); // ICQ 99a ?
                        
                        for ( int i = 0; i <= contactNum; i++ )
                        {
                            if ( *uin == contactList[ i ].uin )
                            {
                                if ( *cport > 0 && *status!=TCP_REFUSE)
                                {
                                    if ( KXDEBUG ) printf( "chat request on port %d\n", *cport );
                                    contactList[ i ].chatport = *cport;
                                    contactList[ i ].server = 2;
                                    contactList[ i ].active = 0;
                                    net_doChatClient( i );
                                }
                                else
                                {
                                    if ( contactList[ i ].listensock > 0 )
                                    {
                                        close( contactList[ i ].listensock );
                                        contactList[ i ].listensock = -1;
                                    }
                                    if ( strlen( buf ) > 0 )
                                    {
                                        ( *callback.showAway ) ( buf, *uin );
                                    }
                                    else
                                    {
                                        char *tmpbuf;
                                        tmpbuf=(char *)malloc(55);
                                        sprintf(tmpbuf, "Chat canceld\n\nNo reason given.");
                                        ( *callback.showAway ) ( tmpbuf, *uin );
                                        free(tmpbuf);
                                    }
                                }
                            }
                        }
                        break;
                    default:
                        if ( KXDEBUG ) printf( "got tcp ack\n" );
                        if ( strlen( buf ) > 0 )
                        {
                            ( *callback.showAway ) ( buf, *uin );
                        }
                        break;
                }
            default:
                break;

        }
    }
    if (buf)
        free( buf );
    return *seq;
}

void parse_TCP_CHAT( UIN seq, UIN uin, char *msg )
{
    for ( int i = 0; i <= contactNum; i++ )
    {
        if ( uin == contactList[ i ].uin )
        {
            contactList[ i ].chatseq = seq;
            ( *callback.chatRequest ) ( uin, msg );
        }
    }

}


void parse_ChatFunctions( int y )
{
    unsigned int * cmd;
    unsigned int *l;

    if ( KXDEBUG )
    {
        printf( "\n------ received TCP chat ------\n" );
        for ( int r = 0; r < contactList[ y ].chatlen; r++ )
        {
            printf( "[%02x] ", contactList[ y ].chatrpacket[ r ] );
        }
    }

    cmd = ( unsigned int * ) ( contactList[ y ].chatrpacket );
    l = ( unsigned int * ) ( contactList[ y ].chatrpacket + 4 );
    switch ( *cmd )
    {
        case 0x64:   // first handshake for chat info
            {
                unsigned short int *len;
                len = ( unsigned short int * ) ( contactList[ y ].chatrpacket + 12 );
                unsigned char *tm;
                
//                tm = ( char * ) ( contactList[ y ].chatrpacket + 8+*len+2+4 );
                
                tm = ( unsigned char * ) ( contactList[ y ].chatrpacket + 14+*len+2 );
                contactList[ y ].fr=*tm;
                tm = ( unsigned char * ) ( contactList[ y ].chatrpacket + 14+*len+3 );
                contactList[ y ].fg=*tm;
                tm = ( unsigned char * ) ( contactList[ y ].chatrpacket + 14+*len+4 );
                contactList[ y ].fb=*tm;
                tm = ( unsigned char * ) ( contactList[ y ].chatrpacket + 14+*len+5 );
                tm = ( unsigned char * ) ( contactList[ y ].chatrpacket + 14+*len+6 );
                contactList[ y ].br=*tm;
                tm = ( unsigned char * ) ( contactList[ y ].chatrpacket + 14+*len+7 );
                contactList[ y ].bg=*tm;
                tm = ( unsigned char * ) ( contactList[ y ].chatrpacket + 14+*len+8 );
                contactList[ y ].bb=*tm;

                net_sendChatColors( y );
            }
            break;
    case 0x03:   // nothing but go chat !!
    case 0x04:
    case 0x05:
    case 0x06:
            contactList[ y ].active = 1;
            ( *callback.doChat ) ( contactList[ y ].uin );
            char *send;
            if (KXDEBUG) printf("%d, %d, %d -> %d, %d, %d\n",contactList[ y ].fr,contactList[ y ].fg,contactList[ y ].fb,
                                contactList[ y ].br,contactList[ y ].bg,contactList[ y ].bb);

            send=(char *)malloc(5);
            sprintf(send,"%c%c%c%c%c",00,contactList[ y ].fr,contactList[ y ].fg,contactList[ y ].fb,0);
            ( *callback.putChar ) ( contactList[ y ].uin, send, 5 );
            sprintf(send,"%c%c%c%c%c",01,contactList[ y ].br,contactList[ y ].bg,contactList[ y ].bb,0);
            ( *callback.putChar ) ( contactList[ y ].uin, send, 5 );
            free(send);
            break;
    case 0x03FF:
    case 0x04FF:   // handshake, we don;t do something !!
    case 0x05FF:
    case 0x06FF:
            break;
    }

}

