/*
    Requires the Qt widget libraries, available at no cost at
    http://www.troll.no

    Copyright (C) 1998 Stephen Hutton
                       shutton@acm.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/* urllist.h */

#ifndef URLLIST_H
#define URLLIST_H
#include <qwidget.h>

#include "urlitem.h"

class UrlNode 
{
 public:
    UrlNode( class UrlItem* pUrlItem, class UrlNode* pNext );
    ~UrlNode();
	
    UrlNode* Copy();  // copy constructor

    UrlItem* pUrl;       // data
    UrlNode* pNextNode;	// link
};

class UrlList
{
	
 public:
    UrlList();
    ~UrlList();
		
    void Remove(  class UrlItem* pItem );
    void Add( UrlItem* pItem );
    int Count();
    UrlItem* GetAt( int i );
    UrlItem* Find( const char* Alias );
	
 private:
    UrlNode* pListHead;

};	
	
#endif // URLLIST_H	
	
