/*
    Requires the Qt widget libraries, available at no cost at
    http://www.troll.no

    Copyright (C) 1998 Stephen Hutton
                       shutton@acm.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/* main.cpp */

#include <kapp.h>
#include <signal.h>

#include "mainwidget.h"

int main( int argc, char **argv )
{
    long pid;

    if( !FirstInstance(&pid) )
    {
	if( argc > 1 && argv[1][1] == 'k')
	{
	    if( 0 == kill( pid, SIGKILL))
		printf("kwebwatch: killed process %ld successfully\n", pid);
	    else
		printf("kwebwatch: failed to kill process %ld\n", pid);
	}
	return 0;
    }
    else
    {
	if( argc > 1 && argv[1][1] == 'k')
	{
	    printf("kwebwatch: nothing to kill\n");
	    return 0;
	}

	KApplication app( argc, argv, "kwebwatch" );
	MainWidget w;
	app.setMainWidget( &w );
	
	return app.exec();
    }
}

