#include "expirestatusdlg.h"

#include <time.h>
#include <sys/stat.h>
#include <unistd.h>
#include <stdlib.h>

#include <qlabel.h>
#include <qapp.h>
#include <qdir.h>
#include <qtimer.h>
#include <qstring.h>
#include <kconfig.h>
#include <kapp.h>

#include "article.h"
#include "gigabase/gigabase.h"


#define SECOND 1
#define MINUTE SECOND*60
#define HOUR   MINUTE*60
#define DAY    HOUR*24

extern dbDatabase db;
extern dbCursor <Article> cursor;

extern KConfig *conf;

extern QString krnpath,cachepath,artinfopath,groupinfopath,dbasepath,outpath;

ExpireStatusDlg::ExpireStatusDlg()
    :QDialog (0,0,true)
{
    QLabel *l=new QLabel (i18n("Please wait a minute, I am expiring!"),
                          this);
    l->adjustSize();
    adjustSize();
    QTimer::singleShot(2000,this,SLOT(doExpire()));
    show();
}

void ExpireStatusDlg::doExpire()
{
    time_t threshold=time(NULL)-DAY*conf->readNumEntry("ExpireReadBodies",5);
    time_t threshold2;
    
    conf->setGroup("Cache");
    
    QDir d(cachepath.data());
    d.setFilter(QDir::Files);
    QStrList *files=new QStrList (*d.entryList("*"));
    
    struct stat st;
    char filename[4096];

    debug ("Deleting articles from cache.");
    
    for (char *fname=files->first();fname!=0;fname=files->next())
    {
        sprintf(filename, "%s%s", cachepath.data(), fname);
        
        
        if(stat(filename, &st))
        {
            debug("couldn't stat %s", filename);
        }
        else
        {
            if(st.st_atime<threshold)
            {
                Article *art = new Article();
                
                art->ID = fname;

                try
                {
                    art->load();
                    
                    if(art->canExpire())
                        unlink(filename);
                }
                catch (int exc)
                {
                    //If it gets here, there was probably an exception
                    //in load() meaning the article is not in the headers
                    //db, so it should get deleted anyhow, since there is
                    //no reference to it anywhere in the GUI
                    unlink(filename);
                }
                delete art;
            }
        }
    }
    delete files;
    
    // Expire new articles
    debug ("Deleting articles from database.");
    
    conf->setGroup("Cache");
    threshold=time(NULL)-DAY*conf->readNumEntry("ExpireUnreadHeaders",5);
    threshold2=time(NULL)-DAY*conf->readNumEntry("ExpireReadHeaders",5);
    
    dbQuery q;
    bool t=true;
    bool f=false;
    dbDateTime t1(threshold);
    dbDateTime epoch(0);
    q=between("Date",epoch,t1),"and isread =", f, "and expire=",t;
    if (::cursor.select(q)>0)
    {
        debug ("Deleting %d unread articles headers",::cursor.getNumberOfRecords());
        ::cursor.removeAllSelected();
    }

    dbDateTime t2(threshold2);
    q=between("Date",epoch,t2),"and isread =", t, "and expire=",t;
    if (::cursor.select(q)>0)
    {
        debug ("Deleting %d read articles headers",::cursor.getNumberOfRecords());
        ::cursor.removeAllSelected();
    }
    debug ("comitting deletes");
    db.commit();
    db.commit();
    db.commit();
    debug ("comitted deletes");
    
    delete this;
    
}

ExpireStatusDlg::~ExpireStatusDlg()
{
}
