#ifndef ARTLIST_H
#define ARTLIST_H

#include <qlistview.h>
#include <qdict.h>

#include "articleitem.h"

class ArtList: public QListView
{
    Q_OBJECT
public:
    ArtList(QWidget *parent);
    ArticleItem *nextItem(ArticleItem *item);
    ArticleItem *prevItem(ArticleItem *item);
    static ArtList *getArtListByID(int id);
    int ID;
    void clear();
    QDict <ArticleItem> items;
    void jumpToID(const char *ID);
signals:
    void leftClick(char *);
    void midClick(char *);
    void rightClick(char *);
    void doubleClick(char *);
    void returnPressed(char *);

public slots:
    void slotSelectionChanged(QListViewItem *);
    void slotDoubleClicked(QListViewItem *);
    void slotReturnPressed(QListViewItem *);
    void slotRightButtonClicked(QListViewItem *);
    void updateByID(const char *ID);
};


#endif
