#include "artdlgbehav.h"

#include <qpushbutton.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qcombobox.h>

#include <kapp.h>
#include <kseparator.h>

extern KConfig *conf;

//IMPORTANT This MUST be the same as in artdlg.cpp

#define DO_NOTHING -1
#define LOAD_ART 0
#define REP_MAIL 1
#define FOLLOWUP 2
#define PREV 3
#define NEXT 4
#define ARTLIST 5
#define PAGE_DOWN_ARTICLE 6
#define PAGE_UP_ARTICLE 7
#define DECODE_ARTICLE 8
#define SAVE_ARTICLE 10
#define SCROLL_UP_ARTICLE 11
#define SCROLL_DOWN_ARTICLE 12
#define DECODE 13
#define NO_READ 14
#define PRINT_ARTICLE 15
#define CONFIG_FONTS 16
#define NO_LOCKED 19
#define POSTANDMAIL 20
#define FORWARD 21
#define POST 22
#define FIND_ARTICLE 23
#define EXPUNGE 24
#define DOWNLOAD_ARTICLE 25
#define NO_CACHED 26
#define EDIT_RULES 27
#define UPDATE_SCORES 28
#define CONFIG_SORTING 29
#define LOOKUP_ALTAVISTA 32
#define QUIT 33
#define SCOREFRAME 34
#define FILL_TREE 35
#define CLOSE_WINDOW 36
#define MULTI_SAVE 37
#define COMBO_CONTENTS 38
#define NEXT_THREAD 39
#define PREV_THREAD 40
#define TAG_TOGGLE 41
#define TAG_SET 42
#define TAG_UNSET 43
#define EXPIRE_TOGGLE 44
#define EXPIRE_SET 45
#define EXPIRE_UNSET 46
#define CONFIG_BEHAV 47
#define READ_TOGGLE 48
#define READ_SET 49
#define READ_UNSET 50



//IMPORTANT these two arrays have to be in sync with each other
//and with the numbers defined in artdlg.cpp

int actions[]={
    LOAD_ART,
    TAG_TOGGLE,
    DO_NOTHING,
    READ_TOGGLE,
    READ_SET,
    READ_UNSET
};

int actionIndex(int action)
{
    for (int i=0;i<5;i++)
    {
        if (actions[i]==action)
            return i;
    }
    return 2;
}


void insertItems(QComboBox *cb)
{
    const char *actionNames[]=
    {
        i18n("Open Article"),
        i18n("Toggle Tag"),
        i18n("Do Nothing"),
        i18n("Toggle Read"),
        i18n("Mark Read"),
        i18n("Mark Unread"),
    };
    cb->insertItem (actionNames[0]);
    cb->insertItem (actionNames[1]);
    cb->insertItem (actionNames[2]);
}

ArtDlgBehavDlg::ArtDlgBehavDlg (): QDialog (0,0,TRUE)
{
    conf->setGroup("ArtDlgBehaviour");

    QGridLayout *g1;
    setCaption (i18n("KRN - Behaviour"));

    QVBoxLayout *l=new QVBoxLayout (this);

    QLabel *lab=new QLabel(this);
    lab->setText (i18n("\nLeft Click\n"));
    lab->setFixedSize(lab->sizeHint());
    l->addWidget(lab,1);

    g1=new QGridLayout(2,2);
    l->addLayout(g1);
    lab=new QLabel(this);
    lab->setText (i18n("Online:"));
    lab->setFixedSize(lab->sizeHint());
    g1->addWidget(lab,0,0);
    lab=new QLabel(this);
    lab->setText (i18n("Offline:"));
    lab->setFixedSize(lab->sizeHint());
    g1->addWidget(lab,1,0);
    leftOn=new QComboBox(this);
    insertItems(leftOn);
    leftOn->setCurrentItem(actionIndex(conf->readNumEntry("LeftClickAction",DO_NOTHING)));
    g1->addWidget(leftOn,0,1);
    leftOff=new QComboBox(this);
    insertItems(leftOff);
    leftOff->setCurrentItem(actionIndex(conf->readNumEntry("LeftClickActionOffline",DO_NOTHING)));
    g1->addWidget(leftOff,1,1);


    lab=new QLabel(this);
    lab->setText (i18n("\nDouble Click\n"));
    lab->setFixedSize(lab->sizeHint());
    l->addWidget(lab,1);

    g1=new QGridLayout(2,2);
    l->addLayout(g1);
    lab=new QLabel(this);
    lab->setText (i18n("Online:"));
    lab->setFixedSize(lab->sizeHint());
    g1->addWidget(lab,0,0);
    lab=new QLabel(this);
    lab->setText (i18n("Offline:"));
    lab->setFixedSize(lab->sizeHint());
    g1->addWidget(lab,1,0);
    dblOn=new QComboBox(this);
    insertItems(dblOn);
    dblOn->setCurrentItem(actionIndex(conf->readNumEntry("DoubleClickAction",LOAD_ART)));
    g1->addWidget(dblOn,0,1);
    dblOff=new QComboBox(this);
    insertItems(dblOff);
    dblOff->setCurrentItem(actionIndex(conf->readNumEntry("DoubleClickActionOffline",LOAD_ART)));
    g1->addWidget(dblOff,1,1);


    lab=new QLabel(this);
    lab->setText (i18n("\nRight Click\n"));
    lab->setFixedSize(lab->sizeHint());
    l->addWidget(lab,1);

    g1=new QGridLayout(2,2);
    l->addLayout(g1);
    lab=new QLabel(this);
    lab->setText (i18n("Online:"));
    lab->setFixedSize(lab->sizeHint());
    g1->addWidget(lab,0,0);
    lab=new QLabel(this);
    lab->setText (i18n("Offline:"));
    lab->setFixedSize(lab->sizeHint());
    g1->addWidget(lab,1,0);
    rightOn=new QComboBox(this);
    insertItems(rightOn);
    g1->addWidget(rightOn,0,1);
    rightOn->setCurrentItem(actionIndex(conf->readNumEntry("RightClickAction",TAG_TOGGLE)));
    rightOff=new QComboBox(this);
    insertItems(rightOff);
    rightOff->setCurrentItem(actionIndex(conf->readNumEntry("RightClickActionOffline",TAG_TOGGLE)));
    g1->addWidget(rightOff,1,1);


    KSeparator *sep=new KSeparator(this);
    sep->setMinimumHeight(10);
    l->addWidget(sep,10);

    QHBoxLayout *l2=new QHBoxLayout();
    l->addLayout(l2,0);
    QPushButton *b1= new QPushButton (i18n("&OK"),this);
    b1->setFixedSize(b1->sizeHint());
    l2->addStretch(10);
    l2->addWidget(b1,0);

    l2->addStretch(100);
    QPushButton *b2= new QPushButton (i18n("&Cancel"),this);
    b2->setFixedSize(b2->sizeHint());
    l2->addWidget(b2,0);
    l2->addStretch(10);


    l->activate();
    connect (b1,SIGNAL(clicked()),this,SLOT(accept()));
    connect (b2,SIGNAL(clicked()),this,SLOT(reject()));

    resize (0,0);

}



void ArtDlgBehavDlg::accept()
{
    conf->setGroup("ArtDlgBehaviour");
    conf->writeEntry("DoubleClickAction",actions[dblOn->currentItem()]);
    conf->writeEntry("RightClickAction",actions[rightOn->currentItem()]);
    conf->writeEntry("LeftClickAction",actions[leftOn->currentItem()]);

    conf->writeEntry("DoubleClickActionOffline",actions[dblOff->currentItem()]);
    conf->writeEntry("RightClickActionOffline",actions[rightOff->currentItem()]);
    conf->writeEntry("LeftClickActionOffline",actions[leftOff->currentItem()]);
    conf->sync();
    done(1);
}


