#include "TooManydlg.h"

#include <qdialog.h>
#include <qkeycode.h>
#include <qpushbt.h>
#include <qradiobutton.h>
#include <qchkbox.h>

#include <kapp.h>
#include <keditcl.h>

#include "tlform.h"
#include "typelayout.h"
extern KConfig *conf;


void TooManyDlg::setTooMany(int somany)
{
    QString s;
    s.sprintf (klocale->translate("This group has %d articles."),somany);
    label->setText(s);
}

TooManyDlg::TooManyDlg ()
:QDialog( 0,0, TRUE )
{
    conf->setGroup("NNTP");

    newthres=false;
    frombottom=true;
    TLForm *f=new TLForm("too many",
                         klocale->translate("KRN-Confirmation"),
                         this);
    KTypeLayout *l=f->layout;

    l->newLine();
    label=(QLabel *)(l->addLabel("l","")->widget);
    l->newLine();
    l->addLabel("l",klocale->translate("Read how many articles?"));
    l->newLine();
    number=(KIntLineEdit *)(l->addIntLineEdit("howmany",conf->readEntry("TooMany","100"),-1)->widget);
    l->newLine();
    l->newLine();

    l->addGroup("from",klocale->translate("Get them from"),true);
    fbrb=(QRadioButton *)(l->addRadioButton("oldest","fromgroup",klocale->translate("Oldest articles"),false)->widget);
    l->newLine();
    l->addRadioButton("newest","fromgroup",klocale->translate("Newest articles"),true);
    l->endGroup();// from
    l->newLine();

    ntcb=(QCheckBox *)(l->addCheckBox("newsetting",klocale->translate("Make this the new threshold"),false)->widget);
    l->newLine();

    l->newLine();
    l->addGroup("buttons","",false);
    QPushButton *b1=(QPushButton *)(l->addButton("b1",klocale->translate("OK"))->widget);
    l->endGroup(); //buttons

    l->activate();

    b1->setDefault(true);
    connect (b1,SIGNAL(clicked()),SLOT(accept()));
    disconnect (this,0,this,SLOT(reject()));
}

int TooManyDlg::exec()
{
    qApp->setOverrideCursor (arrowCursor);
    int res=QDialog::exec();
    qApp->restoreOverrideCursor ();
    howmany=number->getValue();
    frombottom=fbrb->isChecked();
    newthres=ntcb->isChecked();
    if (newthres)
    {
        conf->setGroup("NNTP");
        conf->writeEntry("TooMany",number->text());
    }
    return res;
}


void TooManyDlg::keyPressEvent( QKeyEvent *e )
{

    if ( e->key() == Key_Escape )
    {
        e->ignore();
    }
    else
    {
        QDialog::  keyPressEvent( e );
    }
}

TooManyDlg::~TooManyDlg()
{
}
