/***************************************************************************
                          kdockdialer.h  -  description
                             -------------------
    begin                : Tue Aug 24 1999
    copyright            : (C) 1999 by Darren Poulson
    email                : daz@flapper.demon.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KDOCKDIALER_H
#define KDOCKDIALER_H



/**Create a kpanel dock widget.
	* @short Creates a widget to dock into kpanel. Code largely taken from kicq code (I'm new to this!) and changed for my purpose.
  * @author Darren Poulson
  */
#include <kwm.h>
#include <kled.h>
#include <kapp.h>

#include <qpixmap.h>
#include <qpopmenu.h>
#include <qpoint.h>
#include <qtooltip.h>

#include "kmasqdialer.h"
#include "mclient.h"

class KDockDialer : public QWidget
{
  Q_OBJECT
public:
	/** Constructor */
  KDockDialer();

	/** Destructor */
  ~KDockDialer();

  const int isDocked();
  void setIcon(QPixmap);
  void setToolTip(QString);

public slots:
  void dock();
  void undock();
  void paintIcon();
  void hideWindow();
  void showWindow();
	void slotChangeDialButton(bool);

signals:
  void quitClicked();
	void dialClicked();
	void hangupClicked();

protected:
  int docked;
  int dockID;
	int dialID;
  int doRemove;
  QPopupMenu *dockPopup;
  QPixmap dockIcon;
  int picnum;
  void paintEvent(QPaintEvent*);

protected slots:
  void mousePressEvent(QMouseEvent*);
  void mouseDoubleClickEvent(QMouseEvent*);
  void emitQuit();
	void emitDial();
	void emitHangup();
};

#endif /* KDOCKDIALER_H_ */



















