#ifndef KLOGIN_H
#define KLOGIN_H

#include <qwidget.h>
#include <qcombo.h>
#include <qradiobt.h>
#include <qframe.h>
#include <qdict.h>
#include <qpushbt.h>
#include <qlabel.h>
#include <qbttngrp.h>
#include <kapp.h>

typedef struct {QString login; QString command;} hostParam;

class KLogin: public QWidget {
  Q_OBJECT
protected:
  KConfig*         config;
  QDict<hostParam> hostDict;
  QComboBox    *hostCombo;
  QComboBox    *loginCombo;
  QRadioButton *commandButton[4];
  int curCommand;
protected:
  QFrame       *frame;
  QPushButton  *ok, *cancel, *help;
  QLabel       *hostLabel, *loginLabel;
  QButtonGroup *group;
  virtual void resizeEvent(QResizeEvent*);
public:
  KLogin(KApplication&);
  ~KLogin(){}
  virtual void show();
  void readConfig();
public slots:
  void hostChanged(const char*);
  void loginChanged(const char*);
  void commandChanged(const char*);
  void commandChanged(int);
  void go();
  void showHelp();
signals:
  void quit();
};

#endif
