##############################################################################
#                                                                            #
# kftpupdater - Mirror a local directory to an ftp server or vice versa      #
# Copyright (C) 2000 Martin P. Holland  <m.holland@noether.freeserve.co.uk>  #
#                                                                            #
# This program is free software; you can redistribute it and/or modify       #
# it under the terms of the GNU General Public License as published by       #
# the Free Software Foundation; either version 2 of the License, or          #
# (at your option) any later version.                                        #
#                                                                            #
# This program is distributed in the hope that it will be useful,            #
# but WITHOUT ANY WARRANTY; without even the implied warranty of             #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              #
# GNU General Public License for more details.                               #
#                                                                            #
# You should have received a copy of the GNU General Public License          #
# along with this program; if not, write to the Free Software                #
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  #
#                                                                            #
##############################################################################

from qt import *
from kdecore import i18n
from kfile import *
import ConfigParser, string, os, tempfile
from tabs import MainTab, RegExp, Misc
class projectDialog2(QTabDialog):
#class that allows you to edit/type in project info.
    def __init__(self,parent,name,proj_name,new):
            QTabDialog.__init__(self,parent,name,1)

            self.name=proj_name
            self.parent=parent
            self.parent.dialogSuccess(0)

            if not new:
                p=ConfigParser.ConfigParser()
                p.read(self.parent.config)
            else:
                p=None
            caption="Project: "+self.name
            self.setCaption(caption)
            self.setCancelButton()
            self.main=MainTab(self,'',self.name,new,p)
            self.regexp=RegExp(self,'',self.name,new,p)
            self.misc=Misc(self,'',self.name,new,p)
            self.addTab(self.main,"Main")
            self.addTab(self.regexp,"Reg Exp")
            self.addTab(self.misc,"Misc")
            self.connect(self,SIGNAL("applyButtonPressed()"),self.writeconfig)
            self.connect(self,SIGNAL("cancelButtonPressed()"),self.cancel)
            self.show()

    def cancel(self):
        self.parent.dialogSuccess(0)

    def writeconfig(self):
        p=ConfigParser.ConfigParser()
        p.read(self.parent.config)
        projects=p.sections()
        if self.name not in p.sections(): projects.append(self.name)
        # safety first we don't directly write the config file
        # we first write a tmp file and then rename it
        head,tail=os.path.split(self.parent.config)
        tail=tail+".tmp"
        tmp=os.path.join(head,tail)
        try:
            f=open(tmp,'w')
        except IOError:
            self.parent.pr("Can't open temp config file for writing")
            return 0
        os.chmod(tmp,0600)#is there a race condition?
#        f=open(self.parent.config,'w')
#        os.chmod(self.parent.config,0600)#is there a race condition?
        for proj in projects:
            f.write('['+proj+']\n')
            if proj==self.name:
                f.write('host='+str(self.main.host.text())+'\n')
                f.write('login='+str(self.main.login.text())+'\n')
                f.write('passwd='+str(self.main.passwd.text())+'\n')
                f.write('ldir='+str(self.main.ldir.text())+'\n')
                if not string.rstrip(str(self.main.rdir.text()))=='':
                    f.write('rdir='+str(self.main.rdir.text())+'\n')
                f.write('put='+str(self.main.put.isChecked())+'\n')
                f.write('kill='+str(self.main.kill.isChecked())+'\n')
                f.write('ignorekill='+str(self.regexp.kill.isChecked())+'\n')
                if not string.rstrip(str(self.regexp.ignore.text()))=='':
                    f.write('ignore='+str(self.regexp.ignore.text())+'\n')
                if not string.rstrip(str(self.regexp.only.text()))=='':
                    f.write('only='+str(self.regexp.only.text())+'\n')
                if not string.rstrip(str(self.regexp.ignoredirs.text()))=='':
                    f.write('ignoredirs='+str(self.regexp.ignoredirs.text())+'\n')
                if not string.rstrip(str(self.regexp.onlydirs.text()))=='':
                    f.write('onlydirs='+str(self.regexp.onlydirs.text())+'\n')
                if not string.rstrip(str(self.misc.log.text()))=='':
                    f.write('log='+str(self.misc.log.text())+'\n')
                if not string.rstrip(str(self.misc.db.text()))=='':
                    f.write('db='+str(self.misc.db.text())+'\n')
                if not string.rstrip(str(self.misc.passwd1.text()))=='':
                    f.write('passwd1='+str(self.misc.passwd1.text())+'\n')
                if not string.rstrip(str(self.misc.login1.text()))=='':
                    f.write('login1='+str(self.misc.login1.text())+'\n')
            else:
                for opt in p.options(proj):
                    if opt=="name" or opt=="__name__": continue
                    f.write(opt+'='+p.get(proj,opt)+'\n')
        f.close()
        try:
            os.rename(tmp,self.parent.config)
        except os.error,detail:
            self.parent.pr("Can't rename temp config file "+tmp+" to "+self.parent.config)
            self.parent.pr(detail[0])
            self.parent.pr(detail[1])
            self.parent.dialogSuccess(0)
        self.parent.dialogSuccess(1)
        