##############################################################################
#                                                                            #
# kftpupdater - Mirror a local directory to an ftp server or vice versa      #
# Copyright (C) 2000 Martin P. Holland  <m.holland@noether.freeserve.co.uk>  #
#                                                                            #
# This program is free software; you can redistribute it and/or modify       #
# it under the terms of the GNU General Public License as published by       #
# the Free Software Foundation; either version 2 of the License, or          #
# (at your option) any later version.                                        #
#                                                                            #
# This program is distributed in the hope that it will be useful,            #
# but WITHOUT ANY WARRANTY; without even the implied warranty of             #
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              #
# GNU General Public License for more details.                               #
#                                                                            #
# You should have received a copy of the GNU General Public License          #
# along with this program; if not, write to the Free Software                #
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA  #
#                                                                            #
##############################################################################

import time
(ID_NEW,ID_TRANSFER,ID_STOP)=range(3)
from kdeui import *
from qt import *
from kdecore import *
from view import View
from status import *
VERSION='0.4'

class MainWindow(KTMainWindow):
    def __init__ (self,config,initdb,force,dry,project):
        "Main window class constructor"

        # construct KTMainWindow object
        KTMainWindow.__init__(self)
        #read in information stored in configuration file
        self.conf=KApplication.getKApplication().getConfig();
        self.conf.setGroup("Main")
        
        #last width or take 500 as default
        last_x=self.conf.readNumEntry("x",500)
        #last height or take 500 as default
        last_y=self.conf.readNumEntry("y",500)
        name=str(self.conf.readEntry("name",''))
        if name=='':
            name=None
        if config!=None:
            self.config=config
        else:
            self.config=str(self.conf.readEntry("config",''))
        if self.config=='':
            self.config=None

        self.makeStatus()

        self.view=View(self,'view',self.config,name)
        self.setView(self.view)

        #create menu and tool bars
        self.makeMenu()
        self.makeToolBar()
        self.enableStop(0)

        self.view.confirmDel=self.conf.readNumEntry("confirm_del",1)

        self.opt_menu.setItemChecked(self.delConfirmCheck,self.view.confirmDel)

        self.resize(last_x,last_y)

        #process command line options. This is not a complete
        #success as we don't see the window until the processing has finished :-(
        if project!=None:
            try:
                i=self.view.projects.index(project)
            except ValueError:
                pass
            else:
                self.view.setName(i)
                if initdb:
                    self.view.initdb()
                elif force:
                    self.view.force()
                elif dry:
                    self.view.dryrun()
                else:
                    self.view.transfer()
#End of the constructor

    def makeMenu(self):
        "Create menu bar"
        self.menu=KMenuBar(self,"menubar")

        self.file = QPopupMenu()
        self.help_menu = QPopupMenu()
        self.projects=QPopupMenu()
        self.edit=QPopupMenu()
        self.proj_menu=QPopupMenu()
        self.del_proj=QPopupMenu()
        self.opt_menu=QPopupMenu()
        
        self.file.insertItem(i18n("&Open project..."),self.projects,Key_O)
        self.file.insertItem(i18n("&Edit project..."),self.edit,Key_E)
        self.file.insertItem(i18n("&Delete project..."),self.del_proj,Key_D)
        self.file.insertItem(i18n("&New Project"),self.view.new,CTRL+Key_N)
        self.file.insertItem(i18n("New &Config file"),self.view.newconfig,CTRL+Key_C)
        self.file.insertItem(i18n("&Quit"),self.quit,CTRL+Key_Q)
#        self.file.insertItem("&Test",self.view.test,CTRL+Key_Z)

        self.proj_menu.insertItem(i18n("&Transfer"),self.view.transfer,CTRL+Key_T)
        self.proj_menu.insertItem(i18n("&Dry Run"),self.view.dryrun,CTRL+Key_D)
        self.proj_menu.insertItem(i18n("&Init database"),self.view.initdb,CTRL+Key_I)
        self.proj_menu.insertItem(i18n("&Force update"),self.view.force,CTRL+Key_F)
        self.proj_menu.insertItem(i18n("&Edit this project"),self.view.edit_current,CTRL+Key_E)
        self.proj_menu.insertItem(i18n("&Stop"),self.view.stop,CTRL+Key_S)

        self.delConfirmCheck=self.opt_menu.insertItem(i18n("Confirm deletions"),self.confirmDel)

        aboutstring=str(kapp.appName())+" "+VERSION+"\n\n"
        msgstring="""Copyright (C) 2000 Martin P Holland <m.holland@noether.freeserve.co.uk>
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

This is free software, and you are welcome to redistribute it
under terms of the GNU General Public License.
        """

        self.help_menu = kapp.getHelpMenu(1, aboutstring+msgstring )

        self.menu.insertItem(i18n("&File"), self.file)
        self.menu.insertItem(i18n("&Project"),self.proj_menu)
        self.menu.insertItem(i18n("&Options"),self.opt_menu)

        self.menu.insertSeparator()
        self.menu.insertItem(i18n("&Help"), self.help_menu)

        self.rereadmenus()
        self.connect(self.projects, SIGNAL("activated(int)"), self.view.setName)
        self.connect(self.edit, SIGNAL("activated(int)"), self.view.edit)
        self.connect(self.del_proj, SIGNAL("activated(int)"), self.view.del_proj)
        self.menu.show()
        self.setMenu(self.menu)

    def rereadmenus(self):
        self.projects.clear()
        self.edit.clear()
        self.del_proj.clear()
        for i in range(len(self.view.projects)):
            self.projects.insertItem(self.view.projects[i],i)
            self.edit.insertItem(self.view.projects[i],i)
            self.del_proj.insertItem(self.view.projects[i],i)

    def makeToolBar(self):
        "create tool bar"
        self.toolbar=KToolBar(self)
        toolbardir=str(KApplication.kde_toolbardir())+'/' 
        self.toolbar.insertButton( Icon("filenew.xpm"),ID_NEW, 1, i18n("Create project"))
        self.toolbar.insertButton( Icon("redo.xpm"),ID_TRANSFER, 1,i18n("Transfer files"))
        #for some reason I have to point to toolbar dir here???
        self.toolbar.insertButton( Icon(toolbardir+"stop.xpm"),ID_STOP, 1,i18n("Stop transfer"))
        self.addToolBar(self.toolbar)
        self.connect(self.toolbar,SIGNAL("clicked(int)"),self.toolSlot)

    def toolSlot (self, i):
        "tool bar slots"
        if i==ID_NEW: self.view.new()
        elif i==ID_TRANSFER: self.view.transfer()
        elif i==ID_STOP: self.view.stop()

    def enableStop(self,e):
        self.toolbar.setItemEnabled(ID_STOP,e)

    def makeStatus(self):
        "create a status bar"
        self.status=KStatusBar(self)
        self.status.setInsertOrder(KStatusBar.InsertOrder.LeftToRight)
        self.status.insertItem("No Project           ",ID_PROJECT)
        self.status.enable(KStatusBar.BarStatus.Show)
        self.setStatusBar(self.status)

    def statusChange(self,text,i):
        "Change field I of the status bar to text TEXT."
        self.status.changeItem(text,i)

    def statusMessage(self,text,t):
        "Put up a message TEXT on the status bar for T millisecs."
        self.status.message(text,t)

    def closeEvent(self,e):
        "tidy up before closing"
        if self.view.isLocked():
            self.view.stop()
            KMsgBox.message(self,i18n("kftpupdater: Information"),i18n("Closing the current transfer; try again in a moment..."))
            e.ignore()
            return
        self.conf.setGroup("Main")
        self.conf.writeEntry("confirm_del",self.view.confirmDel)
        self.conf.writeEntry("x",self.width())
        self.conf.writeEntry("y",self.height())
        self.conf.writeEntry("config",self.view.config)
        if self.view.name!=None:
            self.conf.writeEntry("name",self.view.name)
        e.accept()

    def quit(self):
        self.close()

    def confirmDel(self):
        self.view.confirmDel=not self.view.confirmDel
        self.opt_menu.setItemChecked(self.delConfirmCheck,self.view.confirmDel)
        