/* 
    kwintv 

    Copyright (C) 1998 Moritz Wenk (wenk@mathematik.uni-kl.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#ifndef winTVscan_included
#define winTVscan_included

#include <qlist.h> 
#include <qlistview.h> 
#include <qtooltip.h>
#include <qprogressdialog.h> 

#include "rcfile.h"
#include "wintvscandata.h"
#include "countries.h"
#include "channel.h"
#include "v4lxif.h"

class winTVscan : public winTVscanData
{
    Q_OBJECT

public:
  winTVscan( QWidget * parent = NULL, const char * name = NULL,
	     rcfile * _rc = NULL, v4lxif * _v4lxifP = NULL );
  virtual ~winTVscan();

  QList<channel> * getData() { return &channel_list; }
  int getCountryID() { return aktivecntry.cid(); }

signals:
  void readyScanChannelsSIGNAL(int); 
  void frequencyChangedSIGNAL(int);
  void normChangedSIGNAL(int);
  void inputChangedSIGNAL(int);

public slots:
  void setDataSLOT(QList<channel> *clist);

protected slots:
  void okbuttonSLOT();
  void cancelbuttonSLOT();
  void scanbuttonSLOT();
  void newInputSLOT(int);
  void newNormSLOT(int);
  void newCountrySLOT(int);

  void runScanSLOT();
  void checkScanSLOT();

private:
  rcfile *rc;
  country aktivecntry;
  v4lxif * v4lxifP;

  QListView *clistview;
  QProgressDialog *progressview;

  int fchan,index;
  char *cname;
  int input,norm,frequency;
  bool finished;

  QList<channel> channel_list;
};
#endif // winTVscan_included










