/* 
    kwintv, Video4Linux based TV application

    Copyright (C) 1998,1999 Moritz Wenk (wenk@mathematik.uni-kl.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

// Hey, better do not change the order of the includes !!!
// REMEMBER: KDE & Qt-stuff BEFORE X11-stuff !!!

#include <wintv.h>

#include <unistd.h>

#include <qtooltip.h>
#include <qfiledlg.h>
#include <qkeycode.h>
#include <qmsgbox.h>

#include <wintvmain.h>

#include <kiconloader.h>
#include <klocale.h>
#include <kwm.h>

#include <countries.h>

//#undef HAVE_LIBXXF86VM
#ifdef HAVE_LIBXXF86VM
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/extensions/xf86vmode.h>
#include <X11/extensions/xf86vmstr.h>
XF86VidModeModeInfo **vm_modelines;
int vm_count;
#endif

#ifdef X11DEBUG
#include "xeventtype.h"
#endif

#define BID_UP      0
#define BID_DOWN    1
#define BID_CAP     2 
#define BID_SS      3
#define BID_FAR     4
#define BID_FSS     5
#define BID_VUP     6
#define BID_MUTE    7
#define BID_VDOWN   8
#define BID_SC      9
#define BID_EXIT   10
#define BID_LCD    11
#define BID_VSL    12

#define SB_PROG_TEXT  1
#define SB_PROG       2
#define SB_SNAP_TEXT  3
#define SB_SNAP       4 
#define SB_VOL_TXT    5
#define SB_VOL        6
#define SB_SIZE_TXT   7
#define SB_SIZE       8

#define ID_HIDETOOL   0
#define ID_HIDESTATUS 1
#define ID_HIDEALL    2
#define ID_HIDEMOUSE  3
#define ID_DOCKWINDOW 4

#define COMMIT     // commit actions like channel saving etc.

#define KEY10UP Key_AsciiCircum

winTVMainWidget::winTVMainWidget( parsecl * pcl, rcfile *_rc, mixer *_mix,
				  QWidget* parent, const char* name )
  :  KTopLevelWidget( name ), rc(_rc), mix(_mix)
{
  int i;

  lcd=0;
  winTVScreen= NULL;

#ifdef mainDEBUG
  debug("main: begin of init");
#endif

  KWM::setIcon(winId(), kapp->getIcon());
  KWM::setMiniIcon(winId(), kapp->getMiniIcon());

  dock_widget = new DockWidget(this,"dockw");
  if ( rc->ol_allowdocking ) {
    dock_widget->dock();
  }
  connect(dock_widget,SIGNAL(quit_clicked()),this,SLOT(closeRequestSLOT()));
  connect(dock_widget,SIGNAL(toggleDockMasterStateSIGNAL(bool)),this, SLOT(dockSLOT(bool)));

  setCaption((const char*)(QString("kWinTV ")+QString(VERSION)));
  // set icon
  
  KIconLoader *loader = kapp->getIconLoader();
#ifdef mainDEBUG
  debug("main: %s",(const char*)kapp->kde_icondir());
#endif

  pm = loader->loadIcon("kwintv_48x48.xpm");
  setIcon(pm);
  setIconText("kWinTV");

  QStrList *rlist= NULL;
#ifdef HAVE_LIBXXF86VM
  Display *dpy= qt_xdisplay();
  int  foo,bar,ma,mi;
  char dummy[255];
  rlist= new QStrList();

  if (XF86VidModeQueryExtension(dpy,&foo,&bar)) {
    XF86VidModeQueryVersion(dpy,&ma,&mi);
    if (ma == 0 && mi < 8) {
      warning("main: VidMode server extention v0.8 or newer required, disabled");
      have_vm= false;
    } else if ((ma != XF86VIDMODE_MAJOR_VERSION) || (mi != XF86VIDMODE_MINOR_VERSION)) {
      warning("main: VidMode server extention version mismatch, disabled");
      warning("main: server version %d.%d != included version %d.%d",ma,mi,
	      XF86VIDMODE_MAJOR_VERSION,XF86VIDMODE_MINOR_VERSION); 
      have_vm= false;
    } else {
      have_vm = true;
      XF86VidModeGetAllModeLines(dpy,XDefaultScreen(dpy),&vm_count,&vm_modelines);
#ifdef mainDEBUG
      debug("main: X-Server supports VidMode extention (version %d.%d)",ma,mi); 
      debug("main:  available video mode(s):");
      for (i = 0; i < vm_count; i++)
	debug("main: %dx%d",vm_modelines[i]->hdisplay,vm_modelines[i]->vdisplay);
#endif
      for (i = 0; i < vm_count; i++) {
	sprintf(dummy,"%d x %d",vm_modelines[i]->hdisplay,vm_modelines[i]->vdisplay);
	rlist->append(dummy);
      }
    }
  }
#else
  //warning("main: ----- VideoModeExtention disabled -----"); 
#endif

#ifndef HAVE_KDE11

  // user keys, KDE version 1.0

  initKKeyConfig(kapp->getConfig()); 
  userKeys= KKeyConfig::getKKeyConfig(); 
  userKeys->registerWidget("wintvmain",this);
  userKeys->addKey("program up",Key_Up);
  userKeys->connectFunction("wintvmain","program up",this,SLOT(channelDownSLOT()));
  userKeys->addKey("program down",Key_Down);
  userKeys->connectFunction("wintvmain","program down",this,SLOT(channelUpSLOT()));
  userKeys->addKey("volume up",Key_Right);
  userKeys->connectFunction("wintvmain","volume up",this,SLOT(volumeUpSLOT()));
  userKeys->addKey("volume down",Key_Left);
  userKeys->connectFunction("wintvmain","volume down",this,SLOT(volumeDownSLOT()));
  userKeys->addKey("add new program",CTRL+Key_A);
  userKeys->connectFunction("wintvmain","add new program",this,SLOT(addChannelSLOT()));
  userKeys->addKey("edit active program",CTRL+Key_E);
  userKeys->connectFunction("wintvmain","edit active program",this,SLOT(editChannelSLOT()));
  userKeys->addKey("delete active program",CTRL+Key_D);
  userKeys->connectFunction("wintvmain","delete active program",this,SLOT(deleteChannelSLOT()));
  userKeys->addKey("video clip",Key_V);
  userKeys->connectFunction("wintvmain","video clip",this,SLOT(videoClipSLOT()));
  userKeys->addKey("capture toggle",Key_C);
  userKeys->connectFunction("wintvmain","capture toggle",this,SLOT(captureToggleSLOT()));
  userKeys->addKey("snap shot",Key_S);
  userKeys->connectFunction("wintvmain","snap shot",this,SLOT(screenShotSLOT()));
  userKeys->addKey("mute toggle",CTRL+Key_M);
  userKeys->connectFunction("wintvmain","mute toggle",this,SLOT(volMuteChangedSLOT()));
  userKeys->addKey("fix aspect ratio",Key_A);
  userKeys->connectFunction("wintvmain","fix aspect ratio",this,SLOT(adjustAspectRatioSLOT()));
  userKeys->addKey("full screen toggle",Key_F);
  userKeys->connectFunction("wintvmain","full screen toggle",this,SLOT(fullScreenSLOT()));
  userKeys->addKey("toggle mouse cursor",Key_M);
  userKeys->connectFunction("wintvmain","toggle mouse cursor",this,SLOT(mousecursorToggleSLOT()));
  userKeys->addKey("general setup",ALT+Key_G);
  userKeys->connectFunction("wintvmain","general setup",this,SLOT(setupSLOT()));
  userKeys->addKey("audio auto",ALT+Key_A);
  userKeys->connectFunction("wintvmain","audio auto",this,SLOT(audioAutoSLOT()));
  userKeys->addKey("audio mono",ALT+Key_M);
  userKeys->connectFunction("wintvmain","audio mono",this,SLOT(audioMonoSLOT()));
  userKeys->addKey("audio stereo",ALT+Key_S);
  userKeys->connectFunction("wintvmain","audio stereo",this,SLOT(audioStereoSLOT()));
  userKeys->addKey("audio language 1",ALT+Key_1);
  userKeys->connectFunction("wintvmain","audio language 1",this,SLOT(audioL1SLOT()));
  userKeys->addKey("audio language 2",ALT+Key_2);
  userKeys->connectFunction("wintvmain","audio language 2",this,SLOT(audioL2SLOT()));
  userKeys->addKey("key bindings",ALT+Key_K);
  userKeys->connectFunction("wintvmain","key bindings",this,SLOT(userKeysConfigSLOT()));
  userKeys->addKey("toggle program box",Key_B);
  userKeys->connectFunction("wintvmain","toggle program box",this,SLOT(toggleChannelBoxSLOT()));
  userKeys->addKey("exit kwintv",Key_Q);
  userKeys->connectFunction("wintvmain","exit kwintv",this,SLOT(closeRequestSLOT()));
  userKeys->addKey("toggle Menus",CTRL-Key_T);
  userKeys->connectFunction("wintvmain","toggle Menus",this,SLOT(toggleTVonlySLOT()));
  userKeys->addKey("show info",Key_I);
  userKeys->connectFunction("wintvmain","show info",this,SLOT(showInfoSLOT()));
  //userKeys->addKey("dock/undock windwo",Key_D);
  //userKeys->connectFunction("wintvmain","dock/undock windwo",this,SLOT(dockSLOT()));
  //userKeys->addKey("",Key_);
  //userKeys->connectFunction("wintvmain","",this,SLOT());

#else 

  // suppose we are using KDE 1.1
  
  userKeys = new KAccel( this );
  
  userKeys->insertItem(i18n("program up"),"program up",Key_Up);
  userKeys->connectItem("program up",this,SLOT(channelDownSLOT()));

  userKeys->insertItem(i18n("program down"),"program down",Key_Down);
  userKeys->connectItem("program down",this,SLOT(channelUpSLOT()));

  userKeys->insertItem(i18n("volume up"),"volume up",Key_Right);
  userKeys->connectItem("volume up",this,SLOT(volumeUpSLOT()));

  userKeys->insertItem(i18n("volume down"),"volume down",Key_Left);
  userKeys->connectItem("volume down",this,SLOT(volumeDownSLOT()));

  userKeys->insertItem(i18n("add new program"),"add new program",CTRL+Key_A);
  userKeys->connectItem("add new program",this,SLOT(addChannelSLOT()));

  userKeys->insertItem(i18n("edit active program"),"edit active program",CTRL+Key_E);
  userKeys->connectItem("edit active program",this,SLOT(editChannelSLOT()));

  userKeys->insertItem(i18n("delete active program"),"delete active program",CTRL+Key_D);
  userKeys->connectItem("delete active program",this,SLOT(deleteChannelSLOT()));

  userKeys->insertItem(i18n("video clip"),"video clip",Key_V);
  userKeys->connectItem("video clip",this,SLOT(videoClipSLOT()));

  userKeys->insertItem(i18n("capture toggle"),"capture toggle",Key_C);
  userKeys->connectItem("capture toggle",this,SLOT(captureToggleSLOT()));

  userKeys->insertItem(i18n("snap shot"),"snap shot",Key_S);
  userKeys->connectItem("snap shot",this,SLOT(screenShotSLOT()));

  userKeys->insertItem(i18n("mute toggle"),"mute toggle",CTRL+Key_M);
  userKeys->connectItem("mute toggle",this,SLOT(volMuteChangedSLOT()));

  userKeys->insertItem(i18n("fix aspect ratio"),"fix aspect ratio",Key_A);
  userKeys->connectItem("fix aspect ratio",this,SLOT(adjustAspectRatioSLOT()));

  userKeys->insertItem(i18n("full screen toggle"),"full screen toggle",Key_F);
  userKeys->connectItem("full screen toggle",this,SLOT(fullScreenSLOT()));

  userKeys->insertItem(i18n("toggle mouse cursor"),"toggle mouse cursor",Key_M);
  userKeys->connectItem("toggle mouse cursor",this,SLOT(mousecursorToggleSLOT()));

  userKeys->insertItem(i18n("general setup"),"general setup",ALT+Key_G);
  userKeys->connectItem("general setup",this,SLOT(setupSLOT()));

  userKeys->insertItem(i18n("audi auto"),"audio auto",ALT+Key_A);
  userKeys->connectItem("audio auto",this,SLOT(audioAutoSLOT()));

  userKeys->insertItem(i18n("audio mono"),"audio mono",ALT+Key_M);
  userKeys->connectItem("audio mono",this,SLOT(audioMonoSLOT()));

  userKeys->insertItem(i18n("audio stereo"),"audio stereo",ALT+Key_S);
  userKeys->connectItem("audio stereo",this,SLOT(audioStereoSLOT()));

  userKeys->insertItem(i18n("audio language 1"),"audio language 1",ALT+Key_1);
  userKeys->connectItem("audio language 1",this,SLOT(audioL1SLOT()));

  userKeys->insertItem(i18n("audio language 2"),"audio language 2",ALT+Key_2);
  userKeys->connectItem("audio language 2",this,SLOT(audioL2SLOT()));

  userKeys->insertItem(i18n("key bindings"),"key bindings",ALT+Key_K);
  userKeys->connectItem("key bindings",this,SLOT(userKeysConfigSLOT()));

  userKeys->insertItem(i18n("toggle program box"),"toggle program box",Key_B);
  userKeys->connectItem("toggle program box",this,SLOT(toggleChannelBoxSLOT()));

#if 0
  userKeys->insertStdItem(KAccel::Quit, i18n("exit kwintv"));
  userKeys->connectItem(KAccel::Quit,this,SLOT(closeRequestSLOT()));
#else
  userKeys->insertItem(i18n("exit kwintv"),"exit",Key_Q);
  userKeys->connectItem("exit",this,SLOT(closeRequestSLOT()));
#endif

  userKeys->insertItem(i18n("toggle all Menus"),"toggle all Menus",Key_T);
  userKeys->connectItem("toggle all Menus",this,SLOT(toggleTVonlySLOT()));

  userKeys->insertItem(i18n("show info"),"show info",Key_T);
  userKeys->connectItem("show info",this,SLOT(showInfoSLOT()));

  //userKeys->insertItem(i18n("dock/undock window"),"dock",Key_T);
  //userKeys->connectItem("dock",this,SLOT(dockSLOT()));

  userKeys->readSettings(); // finally, read the settings done by the user

#endif // KDE 1.0 or KDE 1.1

  // irc stuff
#ifdef HAVE_IRC
  ircCodes= new KIRCWidget( kapp->getConfig() );
  ircCodes->registerWidget("wintvmain",this);

  // function buttons
  ircCodes->addCode("program up",0xb1);
  ircCodes->connectFunction("wintvmain","program up",this,SLOT(channelDownSLOT()));
  ircCodes->addCode("program down",0xb0);
  ircCodes->connectFunction("wintvmain","program down",this,SLOT(channelUpSLOT()));
  ircCodes->addCode("volume up",146,KCodeEntry::normal,KCodeEntry::often);
  ircCodes->connectFunction("wintvmain","volume up",this,SLOT(volumeUpSLOT()));
  ircCodes->addCode("volume down",147,KCodeEntry::normal,KCodeEntry::often);
  ircCodes->connectFunction("wintvmain","volume down",this,SLOT(volumeDownSLOT()));
  ircCodes->addCode("snap shot",0xb8);
  ircCodes->connectFunction("wintvmain","snap shot",this,SLOT(screenShotSLOT()));
  ircCodes->addCode("mute toggle",188);
  ircCodes->connectFunction("wintvmain","mute toggle",this,SLOT(volMuteChangedSLOT()));
  ircCodes->addCode("full screen toggle",0xce);
  ircCodes->connectFunction("wintvmain","full screen toggle",this,SLOT(fullScreenSLOT()));
  ircCodes->addCode("toggle mouse cursor",0x9d);
  ircCodes->connectFunction("wintvmain","toggle mouse cursor",this,SLOT(mousecursorToggleSLOT()));
  ircCodes->addCode("capture toggle",0xb2);
  ircCodes->connectFunction("wintvmain","capture toggle",this,SLOT(captureToggleSLOT()));
  ircCodes->addCode("show info",0xb3);
  ircCodes->connectFunction("wintvmain","show info",this,SLOT(showInfoSLOT()));
  

  // number buttons
  ircCodes->addCode("0",0xa0, KCodeEntry::number );
  ircCodes->addCode("1",0x80, KCodeEntry::number );
  ircCodes->addCode("2",0x81, KCodeEntry::number );
  ircCodes->addCode("3",0x82, KCodeEntry::number );
  ircCodes->addCode("4",0x83, KCodeEntry::number );
  ircCodes->addCode("5",0x84, KCodeEntry::number );
  ircCodes->addCode("6",0x85, KCodeEntry::number );
  ircCodes->addCode("7",0x86, KCodeEntry::number );
  ircCodes->addCode("8",0x87, KCodeEntry::number );
  ircCodes->addCode("9",0x88, KCodeEntry::number );

  // special buttons
  ircCodes->addCode("+10",0xa1, KCodeEntry::up10 );
  ircCodes->addCode("+20",0xa2, KCodeEntry::up20 );
  ircCodes->addCode("+30",0xa3, KCodeEntry::up30 );
  ircCodes->addCode(">10",0xa7, KCodeEntry::twoDigits );

  connect( ircCodes, SIGNAL(numKeyReceivedSIGNAL(int)), 
	   this, SLOT(switchToChannelSLOT(int)));
  connect( ircCodes, SIGNAL(specialKeyReceivedSIGNAL( KCodeEntry::codeType )), 
	   this, SLOT( displaySpecialKeySLOT( KCodeEntry::codeType )));
#endif // HAVE_IRC

  // load icons
  ch_up_xpm     = loader->loadIcon("forward.xpm");
  ch_down_xpm   = loader->loadIcon("back.xpm");
  capture_xpm   = loader->loadIcon("kwintv_capture.xpm");
  uncapture_xpm = loader->loadIcon("kwintv_capture.xpm");
  snap_xpm      = loader->loadIcon("kwintv_snap.xpm");
  aspect_xpm    = loader->loadIcon("transform.xpm");
  fullsize_xpm  = loader->loadIcon("viewzoom.xpm");
  vol_up_xpm    = loader->loadIcon("kwintv_vol_up.xpm");
  mute_xpm      = loader->loadIcon("kwintv_mute_on.xpm");
  vol_down_xpm  = loader->loadIcon("kwintv_vol_down.xpm");
  cs_xpm        = loader->loadIcon("kwintv_cs.xpm");
  exit_xpm      = loader->loadIcon("exit.xpm");

  /////////////////////////////////////////////////////////////////////////////
  statusbar= new KStatusBar(this,"statusbar");
  statusbar->insertItem("File:",SB_PROG_TEXT);
  statusbar->insertItem("WWWWWWWW",SB_PROG);
  statusbar->changeItem((const char*)rc->channelListName,SB_PROG);
  statusbar->insertItem("Snap Shot:",SB_SNAP_TEXT);
  statusbar->insertItem("0000",SB_SNAP);
  statusbar->insertItem("Volume:",SB_VOL_TXT);
  statusbar->insertItem("00%",SB_VOL);
  statusbar->insertItem("Size:",SB_SIZE_TXT);
  statusbar->insertItem("000x000",SB_SIZE);
  
  setStatusBar(statusbar);

  // toolbar
  toolbar = new KToolBar(this,"toolbar"); // 22,26
  toolbar->setBarPos(KToolBar::Top);
  toolbar->insertButton(ch_down_xpm,BID_UP,SIGNAL(released(int)),this,
			SLOT(buttonsSLOT(int)),true,i18n("Switch program down"));

  // channel number lcd
  lcd = new QLCDNumber(toolbar, "LCD" );
  lcd->setMinimumSize( 1, 1 );
  lcd->setMaximumSize( 99, 99 );
  {
    QColorGroup normal( QColor( QRgb(15898712) ), QColor( QRgb(0) ), QColor( QRgb(16777215) ), QColor( QRgb(6316128) ), QColor( QRgb(10789024) ), QColor( QRgb(0) ), QColor( QRgb(16777215) ) );
    QColorGroup disabled( QColor( QRgb(8421504) ), QColor( QRgb(12632256) ), QColor( QRgb(16777215) ), QColor( QRgb(6316128) ), QColor( QRgb(10789024) ), QColor( QRgb(8421504) ), QColor( QRgb(12632256) ) );
    QColorGroup active( QColor( QRgb(0) ), QColor( QRgb(12632256) ), QColor( QRgb(16777215) ), QColor( QRgb(6316128) ), QColor( QRgb(10789024) ), QColor( QRgb(0) ), QColor( QRgb(16777215) ) );
    QPalette palette( normal, disabled, active );
    lcd->setPalette( palette );
  }
  /*
  {
    QColorGroup normal( QColor( QRgb(9355867) ), QColor( QRgb(0) ), QColor( QRgb(16777215) ), QColor( QRgb(6316128) ), QColor( QRgb(10789024) ), QColor( QRgb(0) ), QColor( QRgb(16777215) ) );
    QColorGroup disabled( QColor( QRgb(8421504) ), QColor( QRgb(12632256) ), QColor( QRgb(16777215) ), QColor( QRgb(6316128) ), QColor( QRgb(10789024) ), QColor( QRgb(8421504) ), QColor( QRgb(12632256) ) );
    QColorGroup active( QColor( QRgb(0) ), QColor( QRgb(12632256) ), QColor( QRgb(16777215) ), QColor( QRgb(6316128) ), QColor( QRgb(10789024) ), QColor( QRgb(0) ), QColor( QRgb(16777215) ) );
    QPalette palette( normal, disabled, active );
    lcd->setPalette( palette );
  }
  */
  lcd->setSmallDecimalPoint( false );
  lcd->setNumDigits( 2 );
  lcd->setMode( QLCDNumber::DEC );
  lcd->setSegmentStyle( QLCDNumber::Flat );
  lcd->setFrameStyle( QFrame::NoFrame );

  toolbar->insertWidget(BID_LCD,22,lcd);
  
  toolbar->insertButton(ch_up_xpm,BID_DOWN,SIGNAL(released(int)),this,
			 SLOT(buttonsSLOT(int)),true,i18n("Switch program up"));
  toolbar->insertSeparator();

  toolbar->insertButton(uncapture_xpm,BID_CAP,SIGNAL(toggled(int)),this,
			SLOT(buttonsSLOT(int)),true,i18n("Toggle capture"));
  toolbar->setToggle(BID_CAP);
  toolbar->setButton(BID_CAP,rc->capture);

  toolbar->insertButton(snap_xpm,BID_SS,SIGNAL(released(int)),this,
			SLOT(buttonsSLOT(int)),true,i18n("Snapshot"));
  toolbar->insertSeparator();

  toolbar->insertButton(aspect_xpm,BID_FAR,SIGNAL(released(int)),this,
			SLOT(buttonsSLOT(int)),true,i18n("Fix aspect ratio"));
  toolbar->insertButton(fullsize_xpm,BID_FSS,SIGNAL(released(int)),this,
			SLOT(buttonsSLOT(int)),true,i18n("Toggle full screen size"));
  toolbar->insertSeparator();

  toolbar->insertButton(vol_down_xpm,BID_VDOWN,SIGNAL(pressed(int)),this,
  		SLOT(buttonsSLOT(int)),true,i18n("Volume down"));
  
  toolbar->insertButton(mute_xpm,BID_MUTE,SIGNAL(toggled(int)),this,
			SLOT(buttonsSLOT(int)),true,i18n("Mute/Unmute sound"));
  toolbar->setToggle(BID_MUTE);
  toolbar->setButton(BID_MUTE,!rc->sound_on);

  toolbar->insertButton(vol_up_xpm,BID_VUP,SIGNAL(pressed(int)),this,
  			SLOT(buttonsSLOT(int)),true,i18n("Volume up"));
  
  toolbar->insertSeparator();

  toolbar->insertButton(cs_xpm,BID_SC,SIGNAL(released(int)),this,
			SLOT(buttonsSLOT(int)),true,i18n("Show/Hide program box"));
  toolbar->insertButton(exit_xpm,BID_EXIT,SIGNAL(released(int)),this,
			SLOT(buttonsSLOT(int)),true,i18n("Exit"));
  addToolBar(toolbar);

  // popups for menubar  
  QPopupMenu *impmenu[2];
  impmenu[0]= new QPopupMenu;
  impmenu[1]= new QPopupMenu;
  fillMenu(impmenu,
	   "x&awtv",this,SLOT(importXAWTVChannelsSLOT()));
  fillMenu(impmenu,
	   "&xtvscreen",this,SLOT(importXTVSCREENChannelsSLOT()));

  // options menu
  optmenu[0]=new QPopupMenu;
  optmenu[1]=new QPopupMenu;
  optmenu[0]->setCheckable( true );
  optmenu[1]->setCheckable( true );
  
  /*
  fillMenu(optmenu,omid[ID_DOCKWINDOW],
	   i18n("Dock window"),this,SLOT(dockSLOT()));
  fillMenuSeparator(optmenu);
  */
  fillMenu(optmenu,omid[ID_HIDETOOL],
	   i18n("Hide Toolbar"),this,SLOT(toggleToolBarSLOT()));
  fillMenu(optmenu,omid[ID_HIDESTATUS],
	   i18n("Hide Statusbar"),this,SLOT(toggleStatusBarSLOT()));
  fillMenu(optmenu,omid[ID_HIDEALL],
	   i18n("Hide All"),this,SLOT(toggleTVonlySLOT()));
  fillMenu(optmenu,omid[ID_HIDEMOUSE],
	   i18n("Hide Mousecursor"),this,SLOT(mousecursorToggleSLOT()));
  fillMenuSeparator(optmenu);
  fillMenu(optmenu,
	   i18n("General &Options..."),this,SLOT(setupSLOT()));
  fillMenu(optmenu,
	   i18n("&Key Bindings..."),this,SLOT(userKeysConfigSLOT()));
#ifdef HAVE_IRC
  fillMenu(optmenu,
	   i18n("&IRC Code Bindings..."),this,SLOT(ircCodesConfigSLOT()));
#endif
  fillMenuSeparator(optmenu);
  fillMenu(optmenu,
	   i18n("&Save Options"),this,SLOT(saveRCSLOT()));

  // file menu
  QPopupMenu *filemenu[2];
  filemenu[0]=new QPopupMenu;
  filemenu[1]=new QPopupMenu;
  fillMenu(filemenu,
	   i18n("&New"),this,SLOT(newChannelsSLOT()));
  fillMenu(filemenu,
	   i18n("&Open ..."),this,SLOT(loadChannelsSLOT()));
  fillMenu(filemenu,
	   i18n("&Import"),impmenu);

  fillMenuSeparator(filemenu);
  fillMenu(filemenu,
	   i18n("&Save "),this,SLOT(saveChannelsSLOT()));
  fillMenu(filemenu,
	   i18n("Save &As ..."),this,SLOT(saveChannelsAsSLOT()));
  fillMenuSeparator(filemenu);
  fillMenu(filemenu,
	   i18n("E&xit"),kapp,SLOT(quit()));

  // channel menu	
  chmenu[0]=new QPopupMenu;
  chmenu[1]=new QPopupMenu;
  fillMenu(chmenu,
	   i18n("&Show/Hide Program Box"),this,SLOT(toggleChannelBoxSLOT()));
  fillMenuSeparator(chmenu);
  fillMenu(chmenu,
	   i18n("&Scan for Programs..."),this,SLOT(scanChannelsSLOT()));
  fillMenuSeparator(chmenu);
  fillMenu(chmenu,
	   i18n("&Add new Programs"),this,SLOT(addChannelSLOT()));
  fillMenu(chmenu,
	   i18n("&Edit this Program"),this,SLOT(editChannelSLOT()));
  fillMenu(chmenu,
	   i18n("&Delete this Program"),this,SLOT(deleteChannelSLOT()));
#if 0
  chmenu->insertItem(i18n("&Copy this Program"),this,SLOT(copyChannelSLOT()));
  chmenu->insertItem(i18n("&Paste this Program"),this,SLOT(pasteChannelSLOT()));
#endif

  // audio menu
  smenu[0]=new QPopupMenu;
  smenu[1]=new QPopupMenu;
  smenu[0]->setCheckable( true );
  smenu[1]->setCheckable( true );
  fillMenu(smenu,
	   i18n("Show/Hide Mixer"),this,SLOT(toggleMixerBoxSLOT()));
  fillMenuSeparator(smenu);
  fillMenu(smenu,smid[5],
	   i18n("M&ute Sound"),this,SLOT(volMuteChangedSLOT()));
  setItemChecked(smenu,smid[5], !rc->sound_on); 
  fillMenuSeparator(smenu);
  fillMenu(smenu,smid[0],
	   i18n("&Autodetection"),this,SLOT(audioAutoSLOT()));
  fillMenu(smenu,smid[1],
	   i18n("&Mono"),this,SLOT(audioMonoSLOT()));
  fillMenu(smenu,smid[2],
	   i18n("&Stereo"),this,SLOT(audioStereoSLOT()));
  fillMenu(smenu,smid[3],
	   i18n("Language &1"),this,SLOT(audioL1SLOT()));
  fillMenu(smenu,smid[4],
	   i18n("Language &2"),this,SLOT(audioL2SLOT()));

  // set size menu
  sizemenu[0]=new QPopupMenu;
  sizemenu[1]=new QPopupMenu;
  //sizemenu[0]->setCheckable( true );
  //sizemenu[0]->setCheckable( true );
  i=0;
  while (cv_dimensions[i].id != -1 ) {
    fillMenu(sizemenu,cv_dimensions[i].sname);
    i++;
  }
#if 0
  sizemenu->insertSeparator();
  sid[0]=sizemenu->insertItem(i18n("&Border")/*,this,SLOT(captureToggleSLOT())*/);
#endif
  connect( sizemenu[0], SIGNAL(activated(int)), this, SLOT(sizemenuSLOT(int)));
  connect( sizemenu[1], SIGNAL(activated(int)), this, SLOT(sizemenuSLOT(int)));

  // television menu
  tvmenu[0]=new QPopupMenu;
  tvmenu[1]=new QPopupMenu;
  tvmenu[0]->setCheckable( true );
  tvmenu[1]->setCheckable( true );
  fillMenu(tvmenu,tvmid[0],
	   i18n("&Capture on"),this,SLOT(captureToggleSLOT()));
  setItemChecked(tvmenu,tvmid[0],rc->capture);
  fillMenu(tvmenu,tvmid[1],
	   i18n("&Full Screen"),this,SLOT(fullScreenSLOT()));
  setItemChecked(tvmenu,tvmid[1],false);
  fillMenu(tvmenu,tvmid[2],
	   i18n("S&et Size"),sizemenu);
  setItemChecked(tvmenu,tvmid[2],false);
  fillMenu(tvmenu,
	   i18n("Fix &Aspect Ratio"),this,SLOT(adjustAspectRatioSLOT()));
  fillMenuSeparator(tvmenu);
  fillMenu(tvmenu,
	   i18n("&Program"),chmenu);
  fillMenu(tvmenu,
	   i18n("A&udio"),smenu);
  fillMenuSeparator(tvmenu);
  fillMenu(tvmenu,
	   i18n("&Snap Shot"),this,SLOT(screenShotSLOT()));
  fillMenu(tvmenu,
	   i18n("&Video Clip..."),this,SLOT(videoClipSLOT()));

  // help menu
  QString about(i18n(
	     QString("                 kWinTV Version ")+QString(VERSION)+QString("\n\n") 
	    +QString("        kWinTV is a KDE application for TV cards \n"
		     "     supported by a Video4Linux compatible driver.\n\n"
		     "       Copyright 1998, 1999 by Moritz Wenk\n\n"
		     "This Program is distributed under the terms of the\n"
		     "             GNU General Public License\n\n"
		     "   (C) of Logo image by Rob Kaper <cap@capsi.com>\n\n"
		     "Send any comments, gifts, homages, abusings etc. to:\n" 
		     "              wenk@mathematik.uni-kl.de\n\n"
		     "         For new versions, have a look at:\n"
		     "  http://www.mathematik.uni-kl.de/~wenk/xwintv.html")));

  QPopupMenu *helpmenu=KApplication::getKApplication()->getHelpMenu(true,about); 
  //helpmenu->insertSeparator();
  //helpmenu->insertItem(i18n("&Properties..."),this,SLOT(propertiesSLOT()));

  // menu bar  
  menubar = new KMenuBar( this, "kwintv -- MenuBar --" );
  menubar->insertItem(i18n("&File"),filemenu[0]);
  menubar->insertItem(i18n("&TeleVision"),tvmenu[0]);
#ifdef HAVE_VTX
  // we dont have vtx till now...
  //menubar->insertItem(i18n("&VideoText"),this,SLOT(vtxSLOT()));
#endif
  menubar->insertItem(i18n("&Options"),optmenu[0]);
  menubar->insertSeparator();
  menubar->insertItem(i18n("&Help"),helpmenu);
  setMenu(menubar);

  mainmenu= new POPUPMENU("Menu");
  mainmenu->insertItem(i18n("&File"),filemenu[1]);
  mainmenu->insertItem(i18n("&TeleVision"),tvmenu[1]);
  mainmenu->insertItem(i18n("&Options"),optmenu[1]);

  ///////////////////////////////////////////////////////////////////////
  // load channel-file
  //channel_list.setAutoDelete ( true );
  channel_list.setAutoDelete ( false );
  loadChannels((const char*)(rc->dataDir+QString("/")+rc->channelListName));

  /////////////////////////////////////////////////////////////////////////////
  // resize etc.  

  if ( !rc->ol_menubar ) menubar->hide();
  if ( !rc->ol_toolbar ) toolbar->hide();
  if ( !rc->ol_statusbar ) statusbar->hide();

  if ( rc->ol_restore ) {
    setGeometry(rc->ol_geometry);
  } else {
    int yoff= (rc->ol_statusbar?statusbar->height():0)
      + (rc->ol_toolbar?toolbar->height():0)
      + (rc->ol_menubar?menubar->height():0);
    resize(400,300+yoff);
#ifdef mainDEBUG
    debug("main: init size to %dx%d, %d=%d+%d+%d",400,300+yoff,yoff,
	  statusbar->height(),toolbar->height(),menubar->height());
#endif
  }
  setMinimumSize( 160,120  );

  /////////////////////////////////////////////////////////////////////////
  // scan command line
  int shift= pcl->checkOptionInt(OP_SHI,0);
  if (shift < -8192 || shift > 8192) shift = 0;
  int bpp= pcl->checkOptionInt(OP_BPP,0);

  rc->bttvDeviceName= pcl->checkOptionStr(OP_DEV,rc->bttvDeviceName);
  rc->capture= pcl->checkOptionBool(OP_CAP,rc->capture);
  have_vm= pcl->checkOptionSwitch(OP_VME,true);

  /////////////////////////////////////////////////////////////////////////
  // run kv4lsetup
  QString kv4lcall("kv4lsetup -q -l ");
  kv4lcall+=rc->bttvDeviceName;
  if ( bpp ) {
    kv4lcall.append(" -b ");
    QString sbpp;
    sbpp.setNum(bpp);
    kv4lcall+=sbpp;
  }
  if ( shift ) {
    kv4lcall.append(" -s ");
    QString sshift;
    sshift.setNum(shift);
    kv4lcall+=sshift;
  }

#ifdef mainDEBUG
  debug("main: call kv4lsetup: %s",(const char *)kv4lcall);
#endif

  switch ( system((const char *)kv4lcall) ) {
  case -1:
    warning("kwintv: could'nt start kv4lsetup!\n");
    break;
  case 0:
    break;
  default:
    warning("kwintv: kv4lsetup had some trouble, trying to continue anyway.\n");
    break;
  }

  /////////////////////////////////////////////////////////////////////////
  // set up winTVScreen widget
  fixed=true;
  winTVScreen = new winTVScreenWidget(this,"winTVScreen",
				      rc->capture,(const char *)rc->bttvDeviceName);
	
  // set winTVScreen values
  if (rc->screensaver) winTVScreen->toggleScreenSaverSLOT();

  winTVScreen->setTVPopup(mainmenu);  // mainmenu
  winTVScreen->showOSDEnableSLOT( 0 );

  winTVScreen->setViewRefreshMode(pcl->checkOptionInt(OP_REF,3));
  winTVScreen->setPalette(pcl->checkOptionInt(OP_PAL,0));

  setView(winTVScreen);

  // get autio mode
  winTVScreen->changeAudioModeSLOT(VIDEO_SOUND_STEREO);
  int audio=winTVScreen->getAudioMode();
  setItemChecked(smenu, smid[0], audio == 0); 
  setItemChecked(smenu, smid[1], audio == VIDEO_SOUND_MONO); 
  setItemChecked(smenu, smid[2], audio == VIDEO_SOUND_STEREO); 
  setItemChecked(smenu, smid[3], audio == VIDEO_SOUND_LANG1); 
  setItemChecked(smenu, smid[4], audio == VIDEO_SOUND_LANG2); 

  // does tuner see STEREO ???
  if ( !winTVScreen->v4lxifP()->capTunerStereo() ) {
    setItemEnabled (smenu, smid[0],false);
    setItemEnabled (smenu, smid[2],false);
    setItemEnabled (smenu, smid[3],false);
    setItemEnabled (smenu, smid[4],false);
  }

  /////////////////////////////////////////////////////////////////////////////
  // set up ctab dialogs
#ifdef mainDEBUG
  debug("main: init of ctab");
#endif
  tab= new ctab(NULL);
  options= new coptions(tab);
  selector= new cselector(tab,"selector",rc,winTVScreen->v4lxifP());
  freq= new cfreq(tab);

  tab->addTab(selector,"&Program");
  tab->addTab(options,"&Options");
  tab->addTab(freq,"&Frequency");

  tab->setCancelButton();
  tab->setOkButton();
  tab->setDefaultButton();

  /////////////////////////////////////////////////////////////////////////////
  // set up otab dialogs
#ifdef mainDEBUG
  debug("main: init of otab");
#endif
  mtab= new otab(NULL,"otab");

  general= new ogeneral(mtab,"gen");
  snapshot= new osnapshot(mtab,"ss");
  fullscreen= new ofullscreen(mtab,"fs",rlist);
  mixdev= new omixdev(mtab,"mixdev",mix,winTVScreen->getCanVolume());

  mtab->addTab(general,"&General");
  mtab->addTab(snapshot,"S&nap Shot");
  mtab->addTab(fullscreen,"&Screen");
  mtab->addTab(mixdev,"&Mixer");

  mtab->setOkButton();
  mtab->setCancelButton();
  mtab->setDefaultButton();

  /////////////////////////////////////////////////////////////////////////
  // connect everything
  connect(winTVScreen,SIGNAL(keyPressedSIGNAL(int)),this,SLOT(keyPressedSLOT(int)));
  connect(winTVScreen,SIGNAL(autoDetectAudioModeSIGNAL(int)),this,SLOT(audioModeChangedSLOT(int)));
  connect(winTVScreen,SIGNAL(wroteVideoClipFrameSIGNAL(int)),this,SLOT(frameVClipSLOT(int)));
  connect(winTVScreen,SIGNAL(lostVideoClipFrameSIGNAL(int)),this,SLOT(framelostVClipSLOT(int)));
  connect(winTVScreen,SIGNAL(statVideoClipFrameSIGNAL(double)),this,SLOT(statVideoClipFrameSLOT(double)));

  connect(winTVScreen,SIGNAL(toggleTVonlySIGNAL()),this,SLOT(toggleTVonlySLOT()));
  connect(this,SIGNAL(channelChangedSIGNAL()),this,SLOT(channelChangedSLOT()));

  // connect capture changing
  connect(this,SIGNAL(captureToggleSIGNAL(int)),winTVScreen,SLOT(changeCaptureSLOT(int)));

  // connect audio
  connect(this,SIGNAL(audioModeChangedSIGNAL(int)),winTVScreen,SLOT(changeAudioModeSLOT(int)));
  connect(this,SIGNAL(audioMuteToggledSIGNAL()),winTVScreen,SLOT(toggleAudioMuteSLOT()));
  // FIX ME FIX ME
  //if (rc->use_tv_volume) 
  connect(this,SIGNAL(volumeChangedSIGNAL(int,int)),winTVScreen,SLOT(changeAudioVolumeSLOT(int,int)));

  // connect brightness, contrast, colour, hue
  connect(options,SIGNAL(newS1ValueSIGNAL(int)),winTVScreen,SLOT(changeBrightnessSLOT(int)));
  connect(options,SIGNAL(newS2ValueSIGNAL(int)),winTVScreen,SLOT(changeContrastSLOT(int)));
  connect(options,SIGNAL(newS3ValueSIGNAL(int)),winTVScreen,SLOT(changeColorSLOT(int)));
  connect(options,SIGNAL(newS4ValueSIGNAL(int)),winTVScreen,SLOT(changeHueSLOT(int)));

  // connect tune, input, channel 
  //connect(selector,SIGNAL(frequencyChangedSIGNAL(int)),winTVScreen,SLOT(changeFrequencySLOT(int)));
  connect(selector,SIGNAL(inputChangedSIGNAL(int)),winTVScreen,SLOT(changeSourceSLOT(int)));
  connect(selector,SIGNAL(normChangedSIGNAL(int)),winTVScreen,SLOT(changeNormSLOT(int)));

  connect(selector,SIGNAL(newRangeSIGNAL(int,int,int)),freq,SLOT(newRangeSLOT(int,int,int)));
  connect(selector,SIGNAL(frequencyChangedSIGNAL(int)),freq,SLOT(newFreqSLOT(int)));
  connect(freq,SIGNAL(frequencyChangedSIGNAL(int)),winTVScreen,SLOT(changeFrequencySLOT(int)));

  // connect x11Events
  connect(this,SIGNAL(x11EventSIGNAL(XEvent *)),winTVScreen,SLOT(Shellx11EventSLOT(XEvent *)));

  // connect ctab dialog apply, cancel, default
  connect(tab,SIGNAL(applyButtonPressed()),this,SLOT(applyTabSLOT())); 
  connect(tab,SIGNAL(cancelButtonPressed()),this,SLOT(cancelTabSLOT())); 
  connect(tab,SIGNAL(defaultButtonPressed()),this,SLOT(defaultTabSLOT()));

  // connect cmtab dialog apply, cancel, default
  connect(mtab,SIGNAL(applyButtonPressed()),this,SLOT(applyMtabSLOT())); 
  connect(mtab,SIGNAL(cancelButtonPressed()),this,SLOT(cancelMtabSLOT())); 
  connect(mtab,SIGNAL(defaultButtonPressed()),this,SLOT(defaultMtabSLOT()));

  QString number;
  if ( rc->use_master_volume ) {
    number.setNum((mix->getVolume(VOL_RIGHT)+mix->getVolume(VOL_LEFT))/2);
  } else {
    number.setNum((rc->volume_left+rc->volume_right)/2);number.append("%");
  }
  statusbar->changeItem((const char*)number,SB_VOL);

  // some default settings
  isfullscreen=false;
  isfullsize=false;
  capture=rc->capture;
  fixed=false;
  keyup=false;
  lastCutCopy=0;
  copyChannel=false;
  externalMute=false;
  chfile_was_changed=false;

#ifdef mainDEBUG
  debug("main: end of init");
#endif
}

// =================================================================================================

void winTVMainWidget::fillMenu(QPopupMenu *menu[], int reqestId[], 
			       const char * text, 
			       const QObject * receiver, const char * member, int accel=0 )
{
  reqestId[0]=menu[0]->insertItem( text, receiver, member, accel );
  reqestId[1]=menu[1]->insertItem( text, receiver, member, accel );
}

void winTVMainWidget::fillMenu(QPopupMenu *menu[], 
			       const char * text, 
			       const QObject * receiver, const char * member, int accel )
{
  if ( receiver && member ) {
    menu[0]->insertItem( text, receiver, member, accel );
    menu[1]->insertItem( text, receiver, member, accel );
  } else {
    menu[0]->insertItem( text );
    menu[1]->insertItem( text );
  }
}

void winTVMainWidget::fillMenu(QPopupMenu *menu[], int reqestId[], 
			       const char * text, QPopupMenu *popup[] )
{
  reqestId[0]=menu[0]->insertItem( text, popup[0] );
  reqestId[1]=menu[1]->insertItem( text, popup[1] );
}

void winTVMainWidget::fillMenu(QPopupMenu *menu[],
			       const char * text, QPopupMenu *popup[] )
{
  menu[0]->insertItem( text, popup[0] );
  menu[1]->insertItem( text, popup[1] );
}

void winTVMainWidget::fillMenuSeparator( QPopupMenu *menu[] )
{
  menu[0]->insertSeparator();
  menu[1]->insertSeparator();
}

void winTVMainWidget::setItemChecked(QPopupMenu *menu[], int id[], bool set)
{
  menu[0]->setItemChecked( id[0], set );
  menu[1]->setItemChecked( id[1], set );
}

void winTVMainWidget::setItemEnabled(QPopupMenu *menu[], int id[], bool enabled)
{
  menu[0]->setItemEnabled( id[0], enabled );
  menu[1]->setItemEnabled( id[1], enabled );
}

bool winTVMainWidget::isItemChecked(QPopupMenu *menu[], int id[])
{
#ifdef mainDEBUG
  debug("main: isItemChecked id %d, %s",id[0],menu[0]->isItemChecked( id[0] )?"YES":"NO");
#endif
  return (menu[0]->isItemChecked( id[0] ));
}


// =================================================================================================

void winTVMainWidget::closeRequestSLOT()
{
#if 0
  if ( allowDocking ) {
    dock_widget->dock();
    this->hide();
  }
#endif
  if ( (chfile_was_changed & !rc->autosave) ) {
    switch( QMessageBox::information( NULL, "kWinTV",
                                      "Some program settings where changed.\n"
				      "Do you want to save them?",
                                      "&Save", "&Don't save", "&Cancel",
                                      0,      // Enter == button 0
                                      2 ) ) { // Escape == button 1
    case 0:
      saveChannels((const char *)(rc->dataDir+QString("/")+rc->channelListName));
      break;
    case 1: 
      break;
    case 2:
      return;
      break;
    }
  }

  kapp->quit();

}

// =================================================================================================

winTVMainWidget::~winTVMainWidget()
{
#ifdef mainDEBUG
  debug("main: destroying winTVMainWidget");
#endif

  // switch back to original mode line
  if ( isfullscreen ) fullScreenSLOT();

  //QPoint point = this->mapToGlobal(QPoint(0,0));
  QRect rect= frameGeometry();
  rc->ol_geometry.setRect(rect.x(),rect.y(),width(),height());
  rc->ol_toolbar= toolbar->isVisible();
  rc->ol_menubar= menubar->isVisible();
  rc->ol_statusbar= statusbar->isVisible();

  if ( rc->ol_channel != -1 ) rc->ol_channel= channel_list.at();
  if ( rc->autosave ) saveChannels((const char *)(rc->dataDir+QString("/")+rc->channelListName));

  /*
  int i;
  for (i = 0; i < vm_count; i++) {
    free(vm_modelines[i]);
  }
  //  free(vm_modelines);
  */

#ifdef mainDEBUG
  debug("main: ~winTVMainWidget: deleting classes");
#endif

  delete selector;
  delete options;
  delete freq;
  delete tab;
  
  delete mixdev;
  delete snapshot;
  delete general;
  delete mtab;

  delete tvmenu[0];
  delete smenu[0];
  delete chmenu[0];
  delete optmenu[0];

  delete tvmenu[1];
  delete smenu[1];
  delete chmenu[1];
  delete optmenu[1];

  delete toolbar;
  delete menubar;

#ifdef HAVE_IRC
  delete ircCodes;
#endif

  delete winTVScreen;

#ifdef mainDEBUG
    debug("main: winTVMainWidget destroyed");
#endif
}

// =================================================================================================

void winTVMainWidget::scanChannelsSLOT()
{
#ifdef mainDEBUG
  debug("main: winTVMainWidget::scanChannelsSLOT");
#endif
    
  scan = new winTVscan(NULL,"scanner",rc,winTVScreen->v4lxifP());

  connect(scan,SIGNAL(readyScanChannelsSIGNAL(int)),this,SLOT(readyScanChannelsSLOT(int)));
  connect(scan,SIGNAL(frequencyChangedSIGNAL(int)),winTVScreen,SLOT(changeFrequencySLOT(int)));
  connect(scan,SIGNAL(inputChangedSIGNAL(int)),winTVScreen,SLOT(changeSourceSLOT(int)));
  connect(scan,SIGNAL(normChangedSIGNAL(int)),winTVScreen,SLOT(changeNormSLOT(int)));

  scan->setDataSLOT(&channel_list);
  scan->show();
  
}

// =================================================================================================

void winTVMainWidget::readyScanChannelsSLOT( int button )
{
#ifdef mainDEBUG
  debug("main: winTVMainWidget::readyScanChannelsSLOT");
#endif
  rc->country_id= scan->getCountryID();

  disconnect(scan);
  scan->hide();

  // get data
  if ( button ) {

    switch( QMessageBox::information( NULL, "kWinTV",
                                      "Several new programs where found.\n"
				      "Do you want to\n"
				      "\t append them to the existing list or\n"
				      "\t create a new list?",
                                      "&Append", "&New", "&Cancel",
                                      0,      // Enter == button 0
                                      2 ) ) { // Escape == button 2
    case 0: // Append clicked, Alt-S or Enter pressed.
      break;
    case 1: // New clicked or Alt-D pressed
      if ( !channel_list.isEmpty() ) channel_list.clear();
      break;
    case 2: // Cancel clicked, Alt-C or Escape pressed
      return;
      break;
    }

    QList<channel> *clist = scan->getData();
    channel *ch = clist->first();
    while (ch) {
      channel_list.append(ch);
#ifdef scanDEBUG
  debug("scan: appending %d, %s, %s, %d, %d",ch->id, (const char*)ch->channelId, (const char*)ch->name, 
	ch->norm,ch->input);
#endif
      ch= clist->next();
    }
    channel_list.first();
    emit newChannelListSIGNAL( &channel_list );
    emit channelChangedSIGNAL();
  }

  emit channelChangedSIGNAL();
  delete  scan;
}

// =================================================================================================

void winTVMainWidget::audioModeChangedSLOT(int mode)
{
  channel *selchnl= channel_list.current();
  if (mode & AUDIOMODE_AUTODETECT) {
    setCaption((const char*)(QString("kWinTV - ")+QString(selchnl->name)
			     +QString(" - (auto) ")
			     +QString(audiomode[mode ^ AUDIOMODE_AUTODETECT].str)));
  } else {
    setCaption((const char*)(QString("kWinTV - ")+QString(selchnl->name)
			     +QString(" - ")+QString(audiomode[mode].str)));
  }
}

// =================================================================================================

void winTVMainWidget::channelChangedSLOT()
{
  if ( channel_list.at() == -1 ) return;

  channel *ch= channel_list.current();
  setCaption((const char*)(QString("kWinTV - ")+QString(ch->name)
			   +QString(" - ")+QString(audiomode[winTVScreen->getAudioMode()].str)));
  lcd->display( channel_list.at() );
  
  winTVScreen->changeChannelValuesSLOT( ch, channel_list.at() );
}

// =================================================================================================

void winTVMainWidget::keyPressedSLOT(int key)
{
  warning(i18n("main: key pressed in tv screen, key: %d"), key);
}

// =================================================================================================
void winTVMainWidget::fullSizeSLOT(int w, int h)
{
#ifdef mainDEBUG
  debug(i18n("main: fullSize: set size to %dx%d"),w,h);
#endif
  
  /*
  //winTVScreen->changeCaptureSLOT(0);
  if (isfullsize) {
    // old size with frame etc.
    resize(oldPos.width(),oldPos.height());
    //tvmenu->setItemChecked(tvmid[2],false);
    //tvmenu->setItemEnabled(tvmid[1],true);
  } else {
  */
    // set new size
    int Yoffset=0,Xoffset=0;
    if (toolbar->isVisible()) {    
      if ((toolbar->barPos() == KToolBar::Left) || (toolbar->barPos() == KToolBar::Right))
	Xoffset+=toolbar->width();
      if((toolbar->barPos() == KToolBar::Top) || (toolbar->barPos() == KToolBar::Bottom))
	Yoffset+=toolbar->height();
    }
    if (menubar->isVisible()) { 
      Yoffset+=menubar->height();
    }
    if (statusbar->isVisible()) { 
      Yoffset+=statusbar->height();
    }
    //oldPos=geometry();
    resize(w+Xoffset,h+Yoffset);

    if ( (winTVScreen->height() < h - 4 || winTVScreen->height() > h + 4 ) && !isfullsize ) {
#ifdef mainDEBUG
  debug(i18n("main: fullSize: second try (%dx%d)"),w,h);
#endif
      isfullsize=true;
      fullSizeSLOT(w,h);
    } else {
      isfullsize=false;
    }

    //if ( toolbar->sizeHint() 

    //tvmenu->setItemChecked(tvmid[2],true);
    //tvmenu->setItemEnabled(tvmid[1],false);
    /*
  }
  isfullsize=!isfullsize;
    */
}
 
// =================================================================================================

void winTVMainWidget::fullScreenSLOT()
{
  isfullscreen=!isfullscreen;

#ifdef mainDEBUG
  debug(i18n("main: set screen size to %s"),isfullscreen?"full":"normal");
#endif
  
  if (!isfullscreen) {
    // old size with frame, menus etc.

#ifdef HAVE_LIBXXF86VM
    if (have_vm) {
      if (rc->fs_switch_res && res_was_switched) {
	XF86VidModeSwitchToMode(qt_xdisplay(),XDefaultScreen(qt_xdisplay()),vm_modelines[0]);
	res_was_switched= false;
      }
    }
#endif HAVE_LIBXXF86VM

    winTVScreen->showOSDEnableSLOT( rc->fs_infooverlay );

    setItemEnabled(optmenu,omid[ID_HIDEALL],true);
    setItemEnabled(optmenu,omid[ID_HIDETOOL],true);
    setItemEnabled(optmenu,omid[ID_HIDESTATUS],true);
    setItemEnabled(optmenu,omid[ID_DOCKWINDOW],true);

    if ( !isItemChecked(optmenu,omid[ID_HIDEALL]) ) {
      menubar->show();
      if ( !isItemChecked(optmenu,omid[ID_HIDETOOL]) ) toolbar->show();
      if ( !isItemChecked(optmenu,omid[ID_HIDESTATUS]) ) statusbar->show();
    }
    //updateRects();

    setGeometry(oldPos);
    //resize(oldPos.width(),oldPos.height());
    //move(oldPos.x(),oldPos.y());

    updateRects();

    if ( !isItemChecked(optmenu,omid[ID_HIDEMOUSE]) ) 
      winTVScreen->toggleMouseCursorSLOT();

    setItemChecked(tvmenu, tvmid[1],false);
    setItemEnabled(tvmenu, tvmid[2],true);

  } else { // if (!isfullscreen)

    // switch resolution to get full screen size
    //QPoint point = this->mapToGlobal(QPoint (0,0));
    QRect rect= frameGeometry();
    //QPoint point = this->mapToGlobal(QPoint(rect.x(),rect.y()));
    //oldPos.setRect(point.x(),point.y(),width(),height());
    oldPos.setRect(rect.x(),rect.y(),width(),height());

    toolbar->hide();
    menubar->hide();
    statusbar->hide();
    //updateRects();

    winTVScreen->showOSDEnableSLOT( rc->fs_infooverlay?OSD_LEVEL_2:OSD_LEVEL_OFF );

#ifdef HAVE_LIBXXF86VM
    int i;
    if (have_vm) {
      /*
      for (i = 0; i < vm_count; i++) {
	free(vm_modelines[i]);
      }
      //free(vm_modelines);
      */
      //XF86VidModeGetAllModeLines(dpy,XDefaultScreen(dpy),&vm_count,&vm_modelines);

      // get the number of the actual modeline
      for (i = 0; i < vm_count; i++) {
	if (rc->fs_x == vm_modelines[i]->hdisplay && rc->fs_y == vm_modelines[i]->vdisplay)
	  break;
      }

      res_was_switched=false;

      if (rc->fs_switch_res && i != 0 && i != vm_count) {
	XF86VidModeSwitchToMode(qt_xdisplay(),XDefaultScreen(qt_xdisplay()),vm_modelines[i]);
	res_was_switched= true;
      } else {
	res_was_switched=false;
      }
    }
#endif HAVE_LIBXXF86VM

    QWidget *d = kapp->desktop();
    if (rc->fs_upper_left) {
      setGeometry(0,0,winTVScreen->win_max_width(),winTVScreen->win_max_height());
    } else {
      QRect geom= geometry();
      QRect fgeom= frameGeometry();
      setGeometry(fgeom.x()-geom.x(),fgeom.y()-geom.y(),d->width(),d->height());
    }
    
#ifdef HAVE_LIBXXF86VM
    if (have_vm && res_was_switched) {
      XF86VidModeSetViewPort(qt_xdisplay(),XDefaultScreen(qt_xdisplay()),
			     (kapp->desktop()->width()-winTVScreen->win_max_width())/2,
			     (kapp->desktop()->height()-winTVScreen->win_max_height())/2);
    }
#endif HAVE_LIBXXF86VM

    QCursor::setPos(kapp->desktop()->width()/2,kapp->desktop()->height()/2);

    if ( !isItemChecked(optmenu,omid[ID_HIDEMOUSE]) ) 
      winTVScreen->toggleMouseCursorSLOT();

    setItemChecked(tvmenu,tvmid[1],true);
    setItemEnabled(tvmenu,tvmid[2],false);

    setItemEnabled(optmenu,omid[ID_HIDEALL],false);
    setItemEnabled(optmenu,omid[ID_HIDETOOL],false);
    setItemEnabled(optmenu,omid[ID_HIDESTATUS],false);
    setItemEnabled(optmenu,omid[ID_DOCKWINDOW],false);
  } // if (!isfullscreen)
  
}
 
// =================================================================================================

void winTVMainWidget::adjustAspectRatioSLOT()
{
  if (!isVisible() ) return;

  fixed=true;

  int xa,ya;
  int Xoffset=0,Yoffset=0;

  switch (rc->aspectRatio)
    {
    case ASPECT_4_3:
      xa=4; ya=3;
      break;
    case ASPECT_16_9: 
      xa=16; ya=9;
      break;
    default:
      warning(i18n("main: unsupported value for aspect ratio: %d"),rc->aspectRatio);
      return;
    }

  if ((menubar->menuBarPos() != KMenuBar::Floating) && (menubar->isVisible())) {
    Yoffset+=menubar->height();
  }

  if (statusbar->isVisible()) {
    Yoffset+=statusbar->height();
  }

  if ((toolbar->barPos() != KToolBar::Floating) && (toolbar->isVisible())) {
    if ((toolbar->barPos() == KToolBar::Left) || (toolbar->barPos() == KToolBar::Right))
      Xoffset+=toolbar->width();
    if((toolbar->barPos() == KToolBar::Top) || (toolbar->barPos() == KToolBar::Bottom))
      Yoffset+=toolbar->height();
  }
  
  // aktuelle Breite u Hoehe der tv screen
  QRect size=winTVScreen->geometry();
#ifdef mainDEBUG
  debug("main: adjustAspectRatio: %dx%d+%d+%d",size.width(),size.height(),size.x(),size.y());
#endif
  
  int h=(ya*(size.width()))/xa;
  int w=(xa*(size.height()))/ya;
  int sh=size.height();
  int sw=size.width(); 

  switch (rc->fixar) {
  case ASPECT_FIX_BOTH:
    if (sh < h) {
      size.setHeight(sh + ((h - sh) / 2) );
      size.setWidth(xa*(size.height())/ya);
      resize(size.width()+Xoffset,size.height()+Yoffset);
    } else if (sw < w) {
	size.setWidth(sw + ((w - sw) / 2) );
	size.setHeight((ya*(size.width()))/xa);
	resize(size.width()+Xoffset,size.height()+Yoffset);
      } 
    break;
  case ASPECT_FIX_VER: // set new height
    if (sh != h) {
      size.setHeight((ya*(size.width()))/xa);
      resize(size.width()+Xoffset,size.height()+Yoffset);
    } 
    break;
  case ASPECT_FIX_HOR: // set new width
    if (sw != w) {
      size.setWidth(xa*(size.height())/ya);
      resize(size.width()+Xoffset,size.height()+Yoffset);
    }
    break;
  default:
    warning("main: Unsupported aspect ratio fix %d",rc->autoar);
  }

#ifdef mainDEBUG
  debug("main: adjusted aspect ratio");
#endif
}

// =================================================================================================

void winTVMainWidget::sizemenuSLOT(int id)
{
#ifdef mainDEBUG
  debug("main: sizemenuSLOT %d, %dx%d",id,cv_dimensions[id].w, cv_dimensions[id].h);
#endif
  if (cv_dimensions[id].id == -1 ) {
    rc->border=!rc->border;
    setItemChecked(sizemenu, sid[0], rc->border ); 
  } else {
    fullSizeSLOT( cv_dimensions[id].w, cv_dimensions[id].h );
  }
}

// =================================================================================================

void winTVMainWidget::buttonsSLOT(int b)
{
#ifdef mainDEBUG
  //debug(i18n("main: button %d klicked"),b);
#endif

  if ( !winTVScreen ) return;

  switch (b) {
  case BID_DOWN: // switch channel down
    channelDownSLOT();
    break;
  case BID_UP:   // switch channel up
    channelUpSLOT();
    break;
  case BID_CAP:  // toggle capture 
    captureToggleSLOT();
    break;
  case BID_SS:   // make a snap shot
    screenShotSLOT();
    break;
  case BID_SC:   // show window with channel list and volume control ???
    toggleChannelBoxSLOT();
    break;
  case BID_EXIT: // exit
    closeRequestSLOT();
    break;
  case BID_FAR:  // adjust aspect ratio
    adjustAspectRatioSLOT();
    break;
  case BID_VUP:  // volume up
    volumeUpSLOT();
    break;
  case BID_MUTE: // toggle mute/unmute
    volMuteChangedSLOT();
    break;
  case BID_VDOWN:// voluem down
    volumeDownSLOT();
    break;
  case BID_FSS:  // toggle full screen
    fullScreenSLOT();
    break;
  default:       // this should never happen...
    fatal("main: hardcore error 00004");
  }
}


// =============================================================================== 

void winTVMainWidget::toggleMixerBoxSLOT()
{
  emit toggleMixerBoxSIGNAL();
}

// =============================================================================== 

void winTVMainWidget::toggleChannelBoxSLOT()
{
  if ( !rc->autoplaceChannelBox ) {
    emit toggleChannelBoxSIGNAL( NULL );
    return;
  }

  QPoint to;
  QRect rect= frameGeometry();

#ifdef mainDEBUG
  debug(i18n("main: autoplace to %d"),rc->posOfChannelBox);
#endif
  
  switch ( rc->posOfChannelBox ) {
  case UPPER_LEFT:
    emit toggleChannelBoxSIGNAL( NULL );
    break;
  case LOWER_LEFT:
    emit toggleChannelBoxSIGNAL( NULL );
    break;
  case UPPER_RIGHT:
    to.setX(rect.width()+rect.x()+5);
    to.setY(rect.y());
#ifdef mainDEBUG
  debug(i18n("main: autoplace to %d,%d"),to.x(),to.y());
#endif
    emit toggleChannelBoxSIGNAL( &to );
    break;
  case LOWER_RIGHT:
    emit toggleChannelBoxSIGNAL( NULL );
    break;
  default:
    emit toggleChannelBoxSIGNAL( NULL );
  }
}

// =============================================================================== 

void winTVMainWidget::mousecursorToggleSLOT()
{
  winTVScreen->toggleMouseCursorSLOT();
  setItemChecked(optmenu,omid[ID_HIDEMOUSE],!winTVScreen->getCursorState());
}

// =============================================================================== 

void winTVMainWidget::captureToggleSLOT()
{
  capture=!capture;
  setItemChecked(tvmenu,tvmid[0],capture);
  emit captureToggleSIGNAL(capture);
}

// =============================================================================== 

void winTVMainWidget::screenShotSLOT()
{
#if 0
  if (!capture) 
    QMessageBox::information( this, 
			      (const char*)(QString("kWinTV ")+QString(VERSION)),
			      i18n("Capture has to be set on to make snapshots!"));
#endif
  winTVScreen->snapShotSLOT((const char *)(rc->ss_prefix+PICNAME),
			    rc->ss_fixed,
			    rc->ss_width,rc->ss_height,
			    rc->ss_format,rc->ss_quality);
  QString number;
  number.setNum(winTVScreen->getShotNumber()+1);
  statusbar->changeItem((const char*)number,SB_SNAP);
}

// =============================================================================== 

void winTVMainWidget::videoClipSLOT()
{
#if 0
  QString propstr(i18n("\n PLEASE READ THIS INFORMATION! \n\n"
		   "There is a bug in kwintv which causes the program\n"
		   "to crash if you move the mouse cursor out of the \n"
		   "window titled \"kWinTV - Video Clip\"!\n"
		   "Dont wonder if there is no picture while grabbing\n"
		   "a video clip... You can only grab to screen or to\n"
		   "memory...\n"));

  QMessageBox::information( this, 
			    (const char*)(QString(i18n("kWinTV "))+QString(VERSION)),
                            (const char*)propstr);
#endif
  emit toggleVClipSIGNAL();
}

// =============================================================================== 

void winTVMainWidget::startVClipSLOT(struct MOVIE_PARAMS *par)
{
  if (!capture) 
    QMessageBox::information( this, 
			      (const char*)(QString("kWinTV ")+QString(VERSION)),
			      i18n("Capture has to be set on to grab a video clip!"));
  
  if (capture) winTVScreen->startVideoClipSLOT(par);
}

// =============================================================================== 

void winTVMainWidget::endVClipSLOT()
{
  if (capture) winTVScreen->endVideoClipSLOT();
}

// =============================================================================== 

void winTVMainWidget::frameVClipSLOT(int c)
{
  emit frameVClipSIGNAL(c);
}

// =============================================================================== 

void winTVMainWidget::statVideoClipFrameSLOT(double d)
{
  emit statVideoClipFrameSIGNAL(d);
}

// =============================================================================== 

void winTVMainWidget::framelostVClipSLOT(int c)
{
  emit framelostVClipSIGNAL(c);
}

// =============================================================================== 

void winTVMainWidget::setupSLOT()
{
  //if (!rc->sound_on) soundSLOT();
  mixdev->setData(rc);
  snapshot->setData(rc);
  general->setData(rc);
  fullscreen->setData(rc);
  mtab->show();
}

// =============================================================================== 

void winTVMainWidget::userKeysConfigSLOT()
{
#ifdef HAVE_KDE11
  // KDE 1.1
  KKeyDialog::configureKeys( userKeys );
#else 
  // KDE 1.0
  userKeys->configureKeys(this);
#endif
}

// =============================================================================== 

void winTVMainWidget::ircCodesConfigSLOT()
{
#ifdef HAVE_IRC
  ircCodes->configureCodes(this);
#endif
}

// =============================================================================== 

void winTVMainWidget::audioAutoSLOT()
{
  emit audioModeChangedSIGNAL(0);
  for (int i=0; i < 5; i++ )
    setItemChecked(smenu, smid[i], (winTVScreen->getAudioMode()+1) == (i+1));
}

// =============================================================================== 

void winTVMainWidget::audioMonoSLOT()
{
  emit audioModeChangedSIGNAL(VIDEO_SOUND_MONO);
  for (int i=0; i < 5; i++ )
    setItemChecked(smenu, smid[i],winTVScreen->getAudioMode() == i);
}

// =============================================================================== 

void winTVMainWidget::audioStereoSLOT()
{
  emit audioModeChangedSIGNAL(VIDEO_SOUND_STEREO);
  for (int i=0; i < 5; i++ )
    setItemChecked(smenu, smid[i],winTVScreen->getAudioMode() == i);
}

// =============================================================================== 

void winTVMainWidget::audioL1SLOT()
{
  emit audioModeChangedSIGNAL(VIDEO_SOUND_LANG1);
  for (int i=0; i < 5; i++ )
    setItemChecked(smenu, smid[i],winTVScreen->getAudioMode() == i);
}

// =============================================================================== 

void winTVMainWidget::audioL2SLOT()
{
  emit audioModeChangedSIGNAL(VIDEO_SOUND_LANG2);
  for (int i=0; i < 5; i++ )
    setItemChecked(smenu, smid[i],winTVScreen->getAudioMode() == i);
}

// =============================================================================== 

void winTVMainWidget::addChannelSLOT()
{
  //debug("main: att channel, channel count %d",selchnl->count());
  if ( !channel_list.isEmpty() ) {
    options->setDataSLOT(channel_list.current());
    selector->setDataSLOT(channel_list.current());
  } else {
    //options->setDataSLOT(selchnl);
    fatal("main: hardcore error 00003");
  }
  //if (!winTVScreen->getCaptureState()) captureToggleSLOT();

  wasEdit=false;
  tab->setCaption("kWinTV - Add a new program");
  tab->show();
}

// =============================================================================== 

void winTVMainWidget::editChannelSLOT()
{
  //if (!winTVScreen->getCaptureState()) captureToggleSLOT();

  options->setDataSLOT( channel_list.current() );
  selector->setDataSLOT( channel_list.current() );

  wasEdit=true;
  tab->setCaption((const char *)(QString("kWinTV - Edit program <")
				 +QString(channel_list.current()->name)+QString(">")));
  tab->show();
}

// =============================================================================== 

void winTVMainWidget::deleteChannelSLOT()
{
  channel *newchannel;

  if ( channel_list.isEmpty() ) return;

#ifdef mainDEBUG
  debug("main: deleting channel %d, %s",channel_list.at(),channel_list.current()->name);
#endif
  if ( lastCutCopy != NULL ) delete lastCutCopy;
  lastCutCopy= channel_list.current();
  channel_list.remove();
  copyChannel=false;

  if ( channel_list.isEmpty() ) {
    newchannel= new channel(rc->freq,"<no name>",
			    rc->col,rc->bri,rc->hue,rc->contr,rc->norm,rc->in,-1,"??");
    channel_list.append( newchannel );
#ifdef mainDEBUG
    debug("main: new nonexistent channel %d, %s",channel_list.at(),channel_list.current()->name);
#endif
  }

#ifdef mainDEBUG
  debug("main: new aktual channel %d, %s",channel_list.at(),channel_list.current()->name);
#endif
  emit newChannelListSIGNAL( &channel_list );
  emit channelChangedSIGNAL();
}

// =============================================================================== 

void winTVMainWidget::copyChannelSLOT()
{
#ifdef mainDEBUG
  debug("main: copy channel %d, %s",channel_list.at(),channel_list.current()->name);
#endif
  if ( lastCutCopy != NULL ) delete lastCutCopy;
  lastCutCopy= channel_list.current();
  copyChannel=true;
}

// =============================================================================== 

void winTVMainWidget::pasteChannelSLOT()
{
  //channel_list.setAutoDelete ( !channel_list.autoDelete ()  );

  channel *cfrom= lastCutCopy;
  channel *cto= channel_list.current();

  if (!copyChannel) channel_list.remove( channel_list.find(cfrom) );
  channel_list.insert( channel_list.find(cto), cfrom );

  //channel_list.setAutoDelete ( !channel_list.autoDelete ()  );

  emit newChannelListSIGNAL( &channel_list );
  emit channelChangedSIGNAL();
}

// =============================================================================== 

void winTVMainWidget::cancelTabSLOT()
{
  emit channelChangedSIGNAL();
}

// =============================================================================== 

void winTVMainWidget::defaultTabSLOT()
{
  if ( !channel_list.isEmpty() ) {
    options->setDataSLOT( channel_list.current());
    selector->setDataSLOT(channel_list.current());
  } else {
    //options->setDataSLOT(channel_list.current());
  }
  
  // call winTVscreen-Widget with original settings
  emit channelChangedSIGNAL();
}

// =============================================================================== 

void winTVMainWidget::applyTabSLOT()
{
  bool waschanged=false;
  chfile_was_changed= true;

  if (wasEdit) {
    channel *selchnl= channel_list.current();
    int act=  channel_list.at();
    channel_list.at(act);
    // copy new values into channel
    //selchnl->frequency=selector->getData()->frequency;
    selchnl->frequency=freq->newFreq();
    selchnl->input=selector->getData()->input;
    selchnl->norm=selector->getData()->norm;
    selchnl->brightness=options->getData()->brightness;
    selchnl->contrast=options->getData()->contrast;
    selchnl->color=options->getData()->color;
    selchnl->hue=options->getData()->hue;
    selchnl->country=selector->getData()->country;
    
    // change channelId if changed
    if ( !selchnl->channelId || strcmp(selchnl->channelId,selector->getData()->channelId)) {
      if (selchnl->channelId) delete selchnl->channelId;
      selchnl->channelId= new char[strlen(selector->getData()->channelId)+1];
      strcpy(selchnl->channelId,selector->getData()->channelId);
      waschanged=true;
    }

    // change name if changed
    if (strcmp(selchnl->name,selector->getData()->name)) {
      if (selchnl->name) delete selchnl->name;
      selchnl->name= new char[strlen(selector->getData()->name)+1];
      strcpy(selchnl->name,selector->getData()->name);
      waschanged=true;
    }
    if (waschanged) emit newChannelListSIGNAL( &channel_list );
    emit channelChangedSIGNAL();
  } else {
    // add new channel

    //debug("new number %d, %d",selchnl->number,selchnl->count());
    channel *selchnl= new channel(freq->newFreq(),//selector->getData()->frequency,
				  selector->getData()->name,
				  options->getData()->color,
				  options->getData()->brightness,
				  options->getData()->hue,
				  options->getData()->contrast,
				  selector->getData()->norm,
				  selector->getData()->input,
				  selector->getData()->country,
				  selector->getData()->channelId);

    int act=  channel_list.at();
    //debug("new number %d",n->number);
    channel_list.at(act);
    if ( !channel_list.insert( channel_list.at(), selchnl ))
	 warning("main: channel_list.insert == false");

    emit newChannelListSIGNAL( &channel_list );
    emit channelChangedSIGNAL();
  }
}

// =============================================================================== 

void winTVMainWidget::applyMtabSLOT()
{
#ifdef mainDEBUG
  debug("main: applyMtabSLOT omixdev");
#endif
  // omixdev
  rc->volume_right=mixdev->getData()->volume_right;
  rc->use_tv_volume=mixdev->getData()->use_tv_volume;
  rc->use_master_volume=mixdev->getData()->use_master_volume;
  rc->mixerDevice=mixdev->getData()->mixerDevice;
#ifdef mainDEBUG
  debug("main: applyMtabSLOT oscreenshot");
#endif
  // oscreenshot
  rc->ss_fixed=snapshot->getData()->ss_fixed;
  rc->ss_width=snapshot->getData()->ss_width;
  rc->ss_height=snapshot->getData()->ss_height;
  rc->ss_format=snapshot->getData()->ss_format;
  rc->ss_prefix=QString(snapshot->getPrefix());
  rc->ss_quality=snapshot->getData()->ss_quality;
#ifdef mainDEBUG
  debug("main: applyMtabSLOT oaspectratio");
#endif
  // oaspectratio
  rc->autoar=fullscreen->getData()->autoar;
  rc->fixar=fullscreen->getData()->fixar;
  rc->aspectRatio=fullscreen->getData()->aspectRatio;
#ifdef mainDEBUG
  debug("main: applyMtabSLOT ogeneral; rc->ol_channel = %d",general->getData()->ol_channel);
#endif
  // ogeneral
  rc->capture=general->getData()->capture;
  rc->autosave=general->getData()->autosave;
  rc->screensaver=general->getData()->screensaver;
  rc->ol_restore=general->getData()->ol_restore;
  rc->posOfChannelBox=general->getData()->posOfChannelBox;
  rc->autoplaceChannelBox=general->getData()->autoplaceChannelBox;
  rc->ol_channel=general->getData()->ol_channel;
  rc->ol_tooltips=general->getData()->ol_tooltips;
  rc->ol_allowdocking=general->getData()->ol_allowdocking;
#ifdef mainDEBUG
  debug("main: applyMtabSLOT fullscreen");
#endif
  // fullscreen
  rc->fs_res=fullscreen->getData()->fs_res;
  rc->fs_infooverlay=fullscreen->getData()->fs_infooverlay;
  rc->fs_switch_res=fullscreen->getData()->fs_switch_res;
#ifdef HAVE_LIBXXF86VM
  rc->fs_x=vm_modelines[rc->fs_res]->hdisplay;
  rc->fs_y=vm_modelines[rc->fs_res]->vdisplay;
#endif

#ifdef mainDEBUG
  debug("main: applyMtabSLOT resetting sound");
#endif

  emit volumeChangedSIGNAL(rc->volume_right,rc->volume_left);
  winTVScreen->showOSDEnableSLOT( rc->fs_infooverlay );

  if ( rc->ol_allowdocking ) {
    dock_widget->dock();
  } else {
    dock_widget->undock();
  }

#ifdef mainDEBUG
  debug("main: applyMtabSLOT end");
#endif
}

// =============================================================================== 

void winTVMainWidget::defaultMtabSLOT()
{
  mixdev->setData(rc);
  snapshot->setData(rc);
  general->setData(rc);
  fullscreen->setData(rc);
}

// =============================================================================== 

void winTVMainWidget::cancelMtabSLOT()
{
  if (rc->sound_on) {
    mix->setVolume(rc->volume_left,VOL_LEFT);
    mix->setVolume(rc->volume_right,VOL_RIGHT);
  } else {
    mix->setVolume(0,VOL_BOTH);
  }
}

// =============================================================================== 

void winTVMainWidget::saveChannelsSLOT()
{
  saveChannels((const char*)(rc->dataDir+QString("/")+rc->channelListName));
#ifdef COMMIT
  QMessageBox::information( this, 
			    (const char*)(QString("kWinTV ")+QString(VERSION)),
			    (const char*)(QString(i18n("Programs saved to file "))
			    +rc->channelListName)
			    );
#endif
}

// =============================================================================== 

void winTVMainWidget::saveChannelsAsSLOT()
{
  QString fileName = 
    QFileDialog::getSaveFileName(rc->dataDir,"*.ch",this,filename);
  if ( !fileName.isNull() ) {                 // got a file name
    strcpy(filename,fileName);
    saveChannels(filename); 
    rc->channelListName=fileName.mid(fileName.findRev('/')+1,fileName.length());
    statusbar->changeItem((const char*)rc->channelListName,SB_PROG);
#ifdef COMMIT
    QMessageBox::information( this, 
			      (const char*)(QString("kWinTV ")+QString(VERSION)),
			      (const char*)(QString(i18n("Programs saved as file "))
					    +rc->channelListName)
			      );
#endif
  }
}

// =============================================================================== 

void winTVMainWidget::loadChannelsSLOT()
{
  QString fileName = 
    QFileDialog::getOpenFileName(rc->dataDir,"*.ch",this);
  if ( !fileName.isNull() ) {                 // got a file name
    strcpy(filename,fileName);
    loadChannels(filename); 
    rc->channelListName=fileName.mid(fileName.findRev('/')+1,fileName.length());
    statusbar->changeItem((const char*)rc->channelListName,SB_PROG);
  }
}

// =============================================================================== 

void winTVMainWidget::importXAWTVChannelsSLOT()
{
  char tag[32], val[100];
  char line[255];
  country cntry;

  QString fileName = QFileDialog::getOpenFileName(QDir::homeDirPath (),"*xawtv",this);

  if ( !fileName.isNull() ) {                 // got a file name
    strcpy(filename,fileName);

    QFile fin(filename);

    if (!fin.open(IO_ReadOnly)) {
      warning(i18n("main: Can't load programs from file <%s>!"),filename);
      if ( channel_list.isEmpty() ) {
	channel *s= new channel(rc->freq,"<no channel>",rc->col,rc->bri,rc->hue,rc->contr,rc->norm,rc->in);
	channel_list.append( s );
      }
      //emit newChannelListSIGNAL(&channel_head);
      //if (selchnl != NULL) emit channelChangedSIGNAL(selchnl);
      return;
    }

    QTextStream t( &fin ); 

    channel *n;
    // remove existing channels 
    channel_list.clear();

    int thenorm=DNORM;
    int theinput=DIN;

    strcpy(line,(const char *)t.readLine());
    while(line[0] != '[' ) {
debug("xawtv: line: <%s>",line);
      if ((strlen(line)==0) || line[0] == '#' || line[0] == '%') {
	strcpy(line,(const char *)t.readLine());
	continue;
      }
      if (2 != sscanf(line," %31[^= ] = %99[^\n]",tag,val)) {
	warning("main: xawtv: parse error %s:%s in %s\n",tag,val,filename);
      } 

debug("xawtv: scan: %s:%s",tag,val);

      if ( 0 == strcmp(tag,"freqtab")) {
        cntry.change(val);
debug("xawtv: country %s %s",tag,val);
      } else if ( 0 == strcmp(tag,"source") ) {
	theinput= atoi(val);
      } else if (0 == strcmp(tag,"norm")) {
	thenorm= atoi(val);
      } else if (0 == strcmp(tag,"fullscreen")) {
	warning("main: scan xawtv: tag <%s> ignored!",tag);
      } else if (0 == strcmp(tag,"mixer")) {
	warning("main: scan xawtv: tag <%s> ignored!",tag);
      }
      strcpy(line,(const char *)t.readLine());
    }

debug("xawtv: channel scan");
    while(!t.eof()) {
      n= new channel(0,"<no name>",DCOL,DBRI,DHUE,DCONTRAST,thenorm,theinput);
      
      if (n->name) delete(n->name);
      n->name=new char[strlen(line)+1];
      strncpy(n->name,&line[1],strlen(line)-1);
      n->name[strlen(line)-2]=0;
debug("xawtv: channel name: %s, %s",n->name,line);

      strcpy(line,(const char *)t.readLine());
      while (!t.eof() && (line[0] != '[')) {
	if ((strlen(line)==0) || line[0] == '#' || line[0] == '%') {
	  strcpy(line,(const char *)t.readLine());
	  continue;
	}
	if (2 != sscanf(line," %31[^= ] = %99[^\n]",tag,val)) {
	  warning("main: xawtv: parse error <%s>:<%s> in %s\n",tag,val,filename);
	}
debug("xawtv: scan: %s:%s",tag,val);
	if (0 == strcmp(tag,"key")) { 
	  warning("main: scan xawtv: tag <%s> ignored!",tag);
	} else if (0 == strcmp(tag,"capture")) {
	  warning("main: scan xawtv: tag <%s> ignored!",tag);
	} else if (0 == strcmp(tag,"source")) {
	  n->input = 0;
	} else if (0 == strcmp(tag,"norm")) {
	  n->norm = 0;
	} else if (0 == strcmp(tag,"channel")) {
	  n->frequency = cntry.cftofreq(val,0);
debug("xawtv: frequency <%s>, %d",val,n->frequency);
	} else if (0 == strcmp(tag,"fine")) {
	  warning("main: scan xawtv: tag <%s> ignored!",tag);
	} else if (0 == strcmp(tag,"color"))
	  n->color = atoi(val);
	else if (0 == strcmp(tag,"bright"))
	  n->brightness = atoi(val);
	else if (0 == strcmp(tag,"hue"))
	  n->hue = atoi(val);
	else if (0 == strcmp(tag,"contrast"))
	  n->contrast = atoi(val);
	else if (0 == strcmp(tag,"freqtab"))
	  warning("main: scan xawtv: tag <%s> ignored!",tag);
	strcpy(line,(const char *)t.readLine());
      }

#ifdef mainDEBUG
      debug("main: channel: %s, %d, %d",n->name, n->frequency, n->frequency*100/16);
#endif
      channel_list.append( n );
    }

    emit newChannelListSIGNAL( &channel_list );
    emit channelChangedSIGNAL();

  }
}

// =============================================================================== 

void winTVMainWidget::importXTVSCREENChannelsSLOT()
{
  QString fileName = QFileDialog::getOpenFileName(QDir::homeDirPath (),"*.*",this,".xtvrc");
  if ( !fileName.isNull() ) {                 // got a file name
    strcpy(filename,fileName);
    loadChannels(filename,true); 
  }
}

// =============================================================================== 

void winTVMainWidget::vtxSLOT()
{
}

// =============================================================================== 

void winTVMainWidget::naSLOT()
{
  QMessageBox::information( this, 
			    (const char*)(QString("kWinTV ")+QString(VERSION)),
                            i18n("This function is not available in this version!"));

}

// =============================================================================== 

void winTVMainWidget::saveRCSLOT()
{
  if ( rc->ol_channel != -1 ) rc->ol_channel= channel_list.at();
#if 0
  QRect rect= frameGeometry();
  rc->ol_geometry.setX(rect.x());
  rc->ol_geometry.setY(rect.y());
  rc->ol_geometry.setWidth(width());
  rc->ol_geometry.setHeight(height());
#else
  rc->ol_geometry= frameGeometry();
#endif
  rc->ol_toolbar= toolbar->isVisible();
  rc->ol_menubar= menubar->isVisible();
  rc->ol_statusbar= statusbar->isVisible();

  if (rc->save()) 
    QMessageBox::warning( this, 
			  (const char*)(QString("kWinTV ")+QString(VERSION)),
			  i18n("kWinTV was not able to save options!"));
#ifdef COMMIT
  else 
    QMessageBox::information( this, 
			      (const char*)(QString("kWinTV ")+QString(VERSION)),
			      i18n("Options saved!"));
#endif
}

// =============================================================================== 

void winTVMainWidget::toggleMenuBarSLOT()
{ 
#ifdef mainDEBUG  
  debug("toggleMenuBarSLOT");
#endif

  if ( isfullscreen ) return;

  int offset;
  QRect size=geometry();
  if (menubar->isVisible()) {
    offset=-menubar->height();
    menubar->hide();
  } else {
    menubar->show();
    offset=-menubar->height();
  }
  resize(size.width(),size.height()+offset);
}

// =============================================================================== 

void winTVMainWidget::toggleStatusBarSLOT()
{ 
#ifdef mainDEBUG  
  debug("toggleStatusBarSLOT");
#endif

  if ( isfullscreen ) return;

  int offset;
  QRect size=geometry();
  if (statusbar->isVisible()) {
    offset=-statusbar->height();
    statusbar->hide();
  } else {
    statusbar->show();
    offset=statusbar->height();
  }
  resize(size.width(),size.height()+offset);
  setItemChecked(optmenu,omid[ID_HIDESTATUS],!statusbar->isVisible());
}

// =============================================================================== 

void winTVMainWidget::toggleToolBarSLOT()
{
#ifdef mainDEBUG  
  debug("toggleToolBarSLOT");
#endif

  if ( isfullscreen ) return;

  if ( (toolbar->barPos() == KToolBar::Floating) ) return;
  int xoffset=0,yoffset=0;
  QRect size=geometry();
  if (toolbar->isVisible()) {
    if ((toolbar->barPos() == KToolBar::Left) || (toolbar->barPos() == KToolBar::Right))
      xoffset-=toolbar->width();
    if((toolbar->barPos() == KToolBar::Top) || (toolbar->barPos() == KToolBar::Bottom))
      yoffset-=toolbar->height();
    toolbar->hide();
  } else {
    toolbar->show();
    if ((toolbar->barPos() == KToolBar::Left) || (toolbar->barPos() == KToolBar::Right))
      xoffset+=toolbar->width();
    if((toolbar->barPos() == KToolBar::Top) || (toolbar->barPos() == KToolBar::Bottom))
      yoffset+=toolbar->height();
  }
  resize(size.width()+xoffset,size.height()+yoffset);
    
  setItemChecked(optmenu,omid[ID_HIDETOOL],!toolbar->isVisible());
}
// =============================================================================== 

void winTVMainWidget::dockSLOT( bool visible )
{ 
#ifdef mainDEBUG  
  debug("dockSLOT");
#endif
  if ( visible ) {
    if ( capture ) {
      emit captureToggleSIGNAL(capture);
    }
  } else {
    if ( capture ) {
      emit captureToggleSIGNAL(!capture);
    }
  }

}

// =============================================================================== 

void winTVMainWidget::propertiesSLOT()
{
#if 0
  int i;

  struct video_capability* vcap=winTVScreen->getCapCap();
  struct video_channel* vchan=winTVScreen->getCapChannel();
  struct video_audio* vaudio=winTVScreen->getCapAudio(); 
  struct video_tuner* vtuner=winTVScreen->getCapTuner();

  QString propstr(2000);
  QString dummy;

#ifdef mainDEBUG  
  debug("%s",vcap->name);
#endif
  propstr+=dummy.sprintf("Informations about your frame grabber card:\n\n");
  propstr+=dummy.sprintf("Name: %s\n\nCapabilities:\n\t",vcap->name);
  for (i = 0; device_cap[i] != NULL; i++)
    if (vcap->type & (1 << i))
      propstr+=dummy.sprintf("%s  ",device_cap[i]);
  
  propstr+=dummy.sprintf("\n\tmin. and max. size for TV screen: %dx%d => %dx%d",
			 vcap->minwidth,vcap->minheight,
			 vcap->maxwidth,vcap->maxheight);
  // channels 
  propstr+=dummy.sprintf("\n\nNumber of input channels: %d\n",vcap->channels);
  for (i = 0; i < vcap->channels; i++) {
    propstr+=dummy.sprintf("\t %s: %d %s %s%s%s\n",
			   vchan[i].name,
			   vchan[i].tuners,
			   (vchan[i].flags & VIDEO_VC_TUNER)   ? "tuner "  : "tuner ",
			   (vchan[i].flags & VIDEO_VC_AUDIO)   ? "audio "  : "",
			   (vchan[i].type & VIDEO_TYPE_TV)     ? "tv "     : "",
			   (vchan[i].type & VIDEO_TYPE_CAMERA) ? "camera " : "");
  }

  // tuner 
  propstr+=dummy.sprintf("\nType of tuner: %s \n\tRange: %lu - %lu MHz\n\tSupported norms: ",
			 vtuner->name,vtuner->rangelow,vtuner->rangehigh);
  for (i = 0; norms[i].str != NULL; i++) {
    if (vtuner->flags & (1<<i)) {
      propstr+=dummy.sprintf("%s ",norms[i].str);
    }
  }

  // audios
  propstr+=dummy.sprintf("\n\nNumber of audios: %d",vcap->audios);
  for (i = 0; i < vcap->audios; i++) {
    propstr+=dummy.sprintf("\n\t %d (%s): \n",i,vaudio[i].name);
    if (vaudio[i].flags & VIDEO_AUDIO_MUTABLE)
      propstr+=dummy.sprintf("\t\t mutable [%s]   ",
			     (vaudio[i].flags&VIDEO_AUDIO_MUTE) ? "muted":"unmuted");
    if (vaudio[i].flags & VIDEO_AUDIO_VOLUME)
      propstr+=dummy.sprintf("volume: %d ",vaudio[i].volume);
    else 
      propstr+=dummy.sprintf("noVol ");
    if (vaudio[i].flags & VIDEO_AUDIO_BASS)
      propstr+=dummy.sprintf("bass %d ",vaudio[i].bass);
    if (vaudio[i].flags & VIDEO_AUDIO_TREBLE)
      propstr+=dummy.sprintf("treble %d ",vaudio[i].treble);
    propstr+=dummy.sprintf("[%s]",audiomode[vaudio[i].mode].str);
  }

  QMessageBox::information( this, 
			    (const char*)(QString(i18n("Properties --- kWinTV "))+QString(VERSION)),
                            (const char*)propstr);
#endif
}

// =============================================================================== 

void winTVMainWidget::volMuteChangedSLOT()
{
#ifdef mainDEBUG
  debug("main: volMuteChangedSLOT %d, extern %d",rc->sound_on,externalMute);
#endif
  if ( !externalMute ) {
    emit volMuteChangedSIGNAL( rc->sound_on ); // on==true -> mute
    setItemChecked(smenu,smid[5], !rc->sound_on ); 
    emit audioMuteToggledSIGNAL();
    if ( rc->sound_on == toolbar->isButtonOn(BID_MUTE) ) {
      externalMute=true;
      toolbar->setButton( BID_MUTE, !rc->sound_on );
    }
  } else
    externalMute=false;
}

// =============================================================================== 

void winTVMainWidget::volMuteChangedExtSLOT(bool on)
{
#ifdef mainDEBUG
  debug("main: volMuteChangedExtSLOT %d",on);
#endif
  externalMute= true;
  toolbar->setButton( BID_MUTE, !rc->sound_on );
  setItemChecked(smenu, smid[5], !rc->sound_on ); 
  emit audioMuteToggledSIGNAL();
}

// =============================================================================== 

void winTVMainWidget::showInfoSLOT()
{
  winTVScreen->showOSDSLOT(channel_list.current(),CHINFO_NODISPVAL,0,0,NULL);
}

// =============================================================================== 

void winTVMainWidget::volumeSLOT(int vl,int vr)
{
  if ( (rc->fs_infooverlay > OSD_LEVEL_1) || 
       ((rc->fs_infooverlay==OSD_LEVEL_1) && isfullscreen ) )
    winTVScreen->showOSDSLOT(NULL,rc->volume_right,0,MIXER_MAX_VALUE,"Volume");
  QString number;
  number.setNum((rc->volume_left+rc->volume_right)/2);number.append("%");
  statusbar->changeItem((const char*)number,SB_VOL);
}

// =============================================================================== 

void winTVMainWidget::volumeUpSLOT()
{
  int vl=rc->volume_left+MIXER_STEP;
  int vr=rc->volume_right+MIXER_STEP;
  if (vl > MIXER_MAX_VALUE) vl=MIXER_MAX_VALUE;
  if (vr > MIXER_MAX_VALUE) vr=MIXER_MAX_VALUE;
#ifdef mainDEBUG
  debug("main: vol up %d,%d -> %d,%d",rc->volume_left,rc->volume_right,vl,vr);
#endif
  //volumeSLOT(vl,vr);
  emit volumeChangedSIGNAL(vr,vl);
}

// =============================================================================== 

void winTVMainWidget::volumeDownSLOT()
{
  int vl=rc->volume_left-MIXER_STEP;
  int vr=rc->volume_right-MIXER_STEP;
  if (vl < 0) vl=0;
  if (vr < 0) vr=0;
#ifdef mainDEBUG
  debug("main: vol down %d,%d -> %d,%d",rc->volume_left,rc->volume_right,vl,vr);
#endif
  //volumeSLOT(vl,vr);
  emit volumeChangedSIGNAL(vr,vl);
}

// =============================================================================== 

void winTVMainWidget::channelUpSLOT()
{
  channel_list.prev();
  if ( channel_list.at() == -1 ) channel_list.last();

#ifdef mainDEBUG
  debug("main: channel up: %s", channel_list.current()->name);
#endif

  emit channelChangedSIGNAL();
}

// =============================================================================== 

void winTVMainWidget::channelDownSLOT()
{
  channel_list.next();
  if ( channel_list.at() == -1 ) channel_list.first();

#ifdef mainDEBUG
  debug("main: channel down: %s", channel_list.current()->name);
#endif
  emit channelChangedSIGNAL();
}

// =============================================================================== 

void winTVMainWidget::newChannelsSLOT()
{
  // remove existing channels 
  if ( !channel_list.isEmpty() ) channel_list.clear();

  channel *s=new channel(rc->freq,"<no name>",
			 rc->col,rc->bri,rc->hue,rc->contr,rc->norm,rc->in,
			 -1,"??");
  channel_list.append( s );
  
  emit newChannelListSIGNAL( &channel_list );
  emit channelChangedSIGNAL();
}

// =============================================================================== 

void winTVMainWidget::loadChannels(const char *FILE,bool import)
{
  channel *n;
  char cdummy[50];
  int ver;
  bool postsave=false;

  ifstream fin(FILE);

  if (!fin) {
    warning(i18n("main: Can't load program-file %s!"),FILE);
    if ( channel_list.isEmpty() ) {
      channel *s=new channel(rc->freq,"<no name>",
			     rc->col,rc->bri,rc->hue,rc->contr,rc->norm,rc->in,
			     -1,"??");
      channel_list.append( s );
    }
    emit newChannelListSIGNAL( &channel_list );
    emit channelChangedSIGNAL();
    return;
  }

  // remove existing channels 
  if ( !channel_list.isEmpty() ) channel_list.clear();

#ifdef mainDEBUG
  debug("main: loading channels from <%s>",FILE);
#endif

  if ( import ) {
    ver= CFVER_XTV;
  } else {
    fin >> cdummy >> cdummy;
    ver= atoi(cdummy);
    if ( !ver ) ver= CFVER_1;
    postsave= (ver != CFVER_CUR);
  }

#ifdef mainDEBUG
  debug("main: found channel file version %d, do a postsave? %s",ver,postsave?"yes":"no");
#endif

  // set the version
  channel_list.current()->setVersion(ver);
  // and load all
  while ( fin.ignore(1000, '*') ) {
    n= new channel();
    fin >> *n;
    channel_list.append( n );
#ifdef mainDEBUG
    debug("main: load channel: %s, %d, i %d, n %d, cy %d",n->name, n->frequency, n->input, n->norm, n->country);
#endif
  }
  
  // set current channel
  if ( !channel_list.isEmpty() ) {
    if ( (rc->ol_channel == -1 ) || (rc->ol_channel > channel_list.count()) )
      channel_list.first();
    else 
      channel_list.at(rc->ol_channel);

    emit newChannelListSIGNAL( &channel_list );
    emit channelChangedSIGNAL();
#ifdef mainDEBUG
      debug("main: channel count: %d, at: %d",channel_list.count(),channel_list.at());
#endif
  }

  // save with newest version enabled
  if ( postsave ) saveChannels( FILE );
}

// =============================================================================== 

void winTVMainWidget::saveChannels(const char *FILE)
{
  ofstream fout(FILE);
  if (!fout) {
    warning(i18n("main: Can't save programs to file <%s>!"),FILE);
    return;
  }

  int curr= channel_list.at();

  channel *h= channel_list.first();
  h->setVersion(CFVER_CUR);

  fout << "### " << h->getVersion() << endl;
  fout << "# kwintv programs file" << endl;
  fout << "#" << endl;

  while ( h ) { 
    fout << *h << endl;
    h= channel_list.next();
  }

  channel_list.at(curr);

#ifdef mainDEBUG
  debug("main: channel-file <%s> saved!",FILE);
#endif
}

// =================================================================================================

void winTVMainWidget::closeEvent( QCloseEvent *e )
{
#ifdef mainDEBUG
  debug("main:closeEvent");
#endif
  closeRequestSLOT();
}

// =================================================================================================

void winTVMainWidget::resizeEvent( QResizeEvent * theEvent)
{
  if (rc->autoar) adjustAspectRatioSLOT();
  
  if ( winTVScreen && isVisible() ) kapp->sendEvent(winTVScreen,theEvent);

  updateRects();

  if ( winTVScreen && statusbar->isVisible() ) {
    QString number;
    number.sprintf("%dx%d",winTVScreen->width(),winTVScreen->height());
    statusbar->changeItem((const char*)number,SB_SIZE);
  }

#ifdef mainDEBUG
  debug("main: resize to %dx%d",winTVScreen->width(),winTVScreen->height());
#endif
}

// =================================================================================================

void winTVMainWidget::moveEvent( QMoveEvent * theEvent)
{
  if ( winTVScreen && isVisible() ) kapp->sendEvent(winTVScreen,theEvent);
#ifdef mainDEBUG
  debug("main: move");
#endif
}

// =================================================================================================

void winTVMainWidget::updateRects( )
{
  KTopLevelWidget::updateRects();

  if (rc->autoar) adjustAspectRatioSLOT();

  if ( winTVScreen && statusbar->isVisible() ) {
    QString number;
    number.sprintf("%dx%d",winTVScreen->width(),winTVScreen->height());
    statusbar->changeItem((const char*)number,SB_SIZE);
  }

#ifdef mainDEBUG
  debug("main: update");
#endif
}

// =================================================================================================

void winTVMainWidget::saveProperties (KConfig* config)
{
#ifdef mainDEBUG
  debug("main: save properties");
  debug("saving rc...");
#endif

  rc->save(); 
}

// =================================================================================================

void winTVMainWidget::readProperties (KConfig*)
{
#ifdef mainDEBUG
  debug("main: read properties");
#endif
}

//==============================================================================

void winTVMainWidget::switchToChannelSLOT( int dec )
{
#ifdef mainDEBUG
  debug("main: switch to channel %d, count: %d",dec,channel_list.count());
#endif
  if ( (channel_list.count() > (unsigned int)dec) && channel_list.at( dec ) ) {
    emit channelChangedSIGNAL();
    if (!capture) emit captureToggleSLOT();
  }
}

//==============================================================================

void winTVMainWidget::displaySpecialKeySLOT( KCodeEntry::codeType key)
{
#ifdef HAVE_IRC
#ifdef mainDEBUG
  debug("main: display special key");
#endif
  if ( rc->fs_infooverlay > OSD_LEVEL_1 )
    winTVScreen->showOSDSLOT(NULL,CHINFO_NODISPVAL,0, 511, "+10" );
#endif
}

// =================================================================================================

void winTVMainWidget::keyPressEvent ( QKeyEvent *keyE )
{
#ifdef mainDEBUG
  debug("main: key pressed 0x%x",keyE->key());
#endif
  if ( !keyup && (keyE->key() == KEY10UP) ) { keyup=true; key1=-1; key2=-1; }
  else if ( (keyE->key() >= Key_0) && (keyE->key() <= Key_9) ) {
    if ( keyup && (key1 == -1) ) {
      key1= keyE->key() - Key_0;
      return;
    } 
    key2= keyE->key() - Key_0;
    if ( keyup ) {
      key2+= key1 * 10;
      keyup=false;
    }
    switchToChannelSLOT( key2 );
  } else 
    keyE->ignore();
}

// =============================================================================== 

void winTVMainWidget::toggleTVonlySLOT()
{
#ifdef tvDEBUG
  debug("main: toggleTVonlySLOT");
#endif

  if ( isfullscreen ) return;

  int Xoffset=0,Yoffset=0;
  QRect size=geometry();
  if (menubar->isVisible()) {
    // hide all menus
    Yoffset=menubar->height();
    menubar->hide();
    if (statusbar->isVisible()) { 
      Yoffset+=statusbar->height(); 
      statusbar->hide();
    }
    if (toolbar->isVisible()) { 
      if ((toolbar->barPos() == KToolBar::Left) || (toolbar->barPos() == KToolBar::Right))
	Xoffset+=toolbar->width();
      if((toolbar->barPos() == KToolBar::Top) || (toolbar->barPos() == KToolBar::Bottom))
	Yoffset+=toolbar->height();
      toolbar->hide();
    }
    resize(size.width()-Xoffset,size.height()-Yoffset);

    setItemEnabled(optmenu,omid[ID_HIDESTATUS],false);
    setItemEnabled(optmenu,omid[ID_HIDETOOL],false);
  } else {
    // show all menus
    menubar->show();
    if ( !optmenu[0]->isItemChecked(omid[ID_HIDESTATUS][0]) ) statusbar->show();
    if ( !optmenu[0]->isItemChecked(omid[ID_HIDETOOL][0]) ) toolbar->show();

    int Yoffset=menubar->height();
    if ( !optmenu[0]->isItemChecked(omid[ID_HIDESTATUS][0]) ) Yoffset+=statusbar->height();
    if ( !optmenu[0]->isItemChecked(omid[ID_HIDETOOL][0]) ) {
      if ((toolbar->barPos() == KToolBar::Left) || (toolbar->barPos() == KToolBar::Right))
	Xoffset+=toolbar->width();
      if((toolbar->barPos() == KToolBar::Top) || (toolbar->barPos() == KToolBar::Bottom))
	Yoffset+=toolbar->height();
    }
    resize(size.width()+Xoffset,size.height()+Yoffset);

    setItemEnabled(optmenu,omid[ID_HIDESTATUS],true);
    setItemEnabled(optmenu,omid[ID_HIDETOOL],true);
  }
  setItemChecked(optmenu,omid[ID_HIDEALL],!menubar->isVisible());
}

// =================================================================================================
// post init
void winTVMainWidget::emitSetupSignals()
{
#ifdef mainDEBUG
  debug("main: emit setup start");
#endif
  emit newChannelListSIGNAL( &channel_list );
  
  //emit volumeChangedSIGNAL(rc->volume_left,rc->volume_right);

  // startup default is muted
  if ( !rc->sound_on ) {
    setItemChecked(smenu,smid[5], !rc->sound_on ); 
    emit audioMuteToggledSIGNAL();
  } else {
    
  }

  if (!channel_list.isEmpty()) {
    emit channelChangedSIGNAL();
  }
  winTVScreen->postInit();
  winTVScreen->showOSDEnableSLOT( rc->fs_infooverlay );

  if (rc->og_first_time) {
    rc->og_first_time=0;
    switch( QMessageBox::information( this, "kWinTV",
				      "Welcome to kwintv!\n"
                                      "This is the first time that you run kwintv.\n"
				      "Do you want to scan all channels known by\n"
				      "your tuner for valid programs?",
                                      "&Scan...", "&Cancel","",
                                      0,      // Enter == button 0
                                      1 ) ) { // Escape == button 1
    case 0: 
      scanChannelsSLOT();
      break;
    case 1: 
      break;
    }
  }
#ifdef mainDEBUG
  debug("main: emit setup");
#endif
}

// =================================================================================================

void winTVMainWidget::dataReceivedSLOT(int data)
{
#ifdef mainDEBUG
  debug("main: data received 0x%x",data);
#endif
}

// =================================================================================================

bool winTVMainWidget::x11Event( XEvent *event )
{
  Window wwin;

  if ( (!isVisible()) || (wwin=(Window) winId()) == None ) return(false);

  switch ( event->type ) {
  case MapNotify:  
  case UnmapNotify:
#ifdef X11DEBUG
    debug("X11: winTVMainWidget::x11Event: got event %s",events[event->type]);
#endif
    emit x11EventSIGNAL( event );
    break;
  }

  return (false);
}

// =================================================================================================
// =================================================================================================

#include "wintvmain.moc"


