/*
    This file is part of ktvision, a front end to frame grabber cards 
	for the KDE-Project
    
    Copyright (C) 1998 Oliver Burtchen <oliver.burtchen@rz.hu-berlin.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
#ifndef Qv4lWIN_H
#define Qv4lWIN_H
//#define DEBUG_V4LWIN

#include <kapp.h>

#include <cstdlib>

#include <X11/Xlib.h>
#include <X11/extensions/xf86dga.h>

extern "C" {
#include <linux/types.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <linux/videodev.h>
}

#define allGetVideoUninit	((1L<<6)-1)
#define getVideoDevice		(1L<<0)		//true if failed
#define getVideoCapabilities	(1L<<1)		// "    "   "
#define	getVideoChannels	(1L<<2)		// "    "   "
#define	getVideoWindow		(1L<<3)		// "    "   "
#define	getVideoBuffer		(1L<<4)		// "    "   "
#define getTuner		(1L<<5)		// "    "   "

#define allSetVideoUninit	(((1L<<9)-1)^((1L<<6)-1))
#define	setVideoChannels	(1L<<6)		// "    "   "
#define	setVideoWindow		(1L<<7)		// "    "   "
#define	setVideoBuffer		(1L<<8)		// "    "   "

#define allVideoUninit		((1L<<9)-1)

#define capture			(1L<<9)		// true if capture set off by user
#define mapped			(1L<<10)	// true if window unmapped
#define unObscured		(1L<<11)	// true if window fully obsc.
#define captureFlag		(1L<<12)	// true if capture off by operation
#define allCapture		(((1L<<13)-1)^((1L<<9)-1))
#define captureStatus		(1L<<13)	// true if capture is really off
#define fullyClipped		(1L<<14)	// true if fully clipped

struct v4l_window {
	Display * display;
	Screen * screen;
	int screenNum;
	int numBitPlanes;
	int bpp;
	int oldX, oldY;
	int oldWidth, oldHeight;
	int major, minor, vidadr, bank, ram, rwidth, fbttv;
	QString * devName;
	int * input;
	unsigned long initStat;
	int clipNum;
	int visibility;
	QWidget * parent;
	int clipSpace, clipSpaceOld;
	int timerId, timer2Id;
	bool timerFlag, timer2Flag;
	QPoint offset; // arrrrggghhhh
	QPoint oldTopPos;
};

class Qv4lWin : public QWidget {
	Q_OBJECT

public:
	Qv4lWin( QWidget *parent=0, const char *name=0, WFlags f=0);
	~Qv4lWin();

	bool x11ExtraEventFilter ( XEvent *);
	int initialize( const char * devName = 0);
	QStrList * formatList(int);
	QStrList * inputList();
	bool getCapture(){ return !(win->initStat & capture);}
	
		
#ifdef DEBUG_V4LWIN
	void showEvents();
#endif

protected:
	bool eventFilter( QObject *, QEvent *);

private:
	struct video_buffer * vBuf;
	struct video_window * vWin;
	struct video_tuner * vTun;
	struct video_channel * vChan;
	struct video_capability * vCap;
	struct video_clip * vClip;
	struct video_picture * vPic;

	struct v4l_window * win;

	void refreshScreen(int );
	void addClip(uint ,uint ,uint ,uint);
	bool getClip();
	void setCaptureIntern();
	QRect getWinPosition();
	void setVPic();
	
	int one;
	int zero;

	QStrList * chanL;
	QStrList * formatL;

public slots:
	void setCapture(bool);
	void setInput(int);
	void setFormat(int);
	void setFreq(unsigned long);
	void setBright(long int);
	void setColor(long int);
	void setHue(long int);
	void setContrast(long int);

signals:
	void visibilityChanged();	
};

#endif

