/***************************************************************************
                          KTfxWidget.h  -  main widget header
                             -------------------                                         
    begin                : Tue Sep 21 13:07:04 MEST 1999
                                           
    copyright            : (C) 1999 by David Banz                         
    email                : neo@sakura-audio.cx
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef KTFXWIDGET_H
#define KTFXWIDGET_H

// internal name of this release
#define INTERNAL_DESIGNATION "Amiga no Tomodachi VI"
// version number parts - here 2.7.1
#define MAJOR 2
#define MINOR 7
#define PATCH 1

// KDE includes
#include <kapp.h>
#include <kfiledialog.h>
#include <kmsgbox.h>
#include <kconfig.h>
#include <klocale.h>
#include <kurl.h>
#include <drag.h>
#include <kprocess.h>
// Qt includes
#include <qfileinfo.h>
#include <qtextstream.h>
#include <qtooltip.h>
#include <qaccel.h>
#include <qmessagebox.h>
// C++ includes
#include <iostream.h>
// local includes
#include "TfxControlData.h"
#include "C_includes.h"
#include "ktfxsplash.h"

/**
 * This class adds some real functionality to KTfxControlData.
 *
 * It contains all the slots and other functions necessary
 * to to control TFMX-PLAY via the widgets provided by
 * KTfxControlData.
 *
 * @short Core class to control TFMX-PLAY via KTfxControlData
 * @author David Banz
 * @version 2.7
 * @see KTfxControlData
 */
class KTfxWidget : public KTfxControlData
{
Q_OBJECT

public:

/**
 */
	KTfxWidget(QWidget* parent = NULL, const char* name = NULL );

/**
 */
	virtual ~KTfxWidget();

/**
 *	make sure application is closed when top widget is closed
 */
	void closeEvent(QCloseEvent*);

/**
 * helper for the SIGINT handler
 */
	void signalHelperINT();

protected:
	KTfxSplash* splashScreen;	// startup splash-screen
  bool showSplash;					// if true, show splash-screen
	
	KShellProcess* p;		// process for tfmx-play		
	int song;						// subsong number
	int open;						// file open? 0=no
	int playing;				// file playing? 0=no
	int freq;						// frequency (44/32/22/16/11 kHz)
	int bits;						// bits per sample (8/16)
	int separation;			// 0=mono, 1=headphones, 2=stereo
	QString	browseDir;	// start dir for the file browser
	QString preloadSong;// songfile to preload
	QString tfmxFile;		// filename of the tfmx song (mdat.)
	int preloadSubsong;	// subsong to preselect
	QAccel* acc;				// accelerator for keyboard events
	
	KDNDDropZone *dropzone;	// here we can Drag-and-Drop our files
  	
	// tool tip texts (for i18n)
	QString tipFileBar;
	QString tipSongLcd;
	QString tipFreqLcd;
	QString tipBitLcd;
	QString tipStatusBar[2];	//  [0]=stopped, [1]=playing
	QString tipPlayButton;
	QString tipStopButton;
	QString tipOpenButton;
	QString tipQuitButton;
	QString tipUpButton;
	QString tipDownButton;
	QString tipEightButton;
	QString tipSixteenButton;
	QString tipHiButton;
	QString tipLoButton;
	QString tipHelpButton;
	QString tipAboutButton;
	QString tipToolTipCheck;
	QString aboutStr[4];		// translations for "about"-box
	QString noTfxStr[4];		// translations for "no tfmx-play error"-box
	QString tipSeparation[3]; // [0]=mono, [1]=headphones, [2]=stereo
	QString showSeparation[3];	// same here
	QString tipMonoButton;
	QString tipHeadphonesButton;
	QString tipStereoButton;
	QString tipOversampling;

/**
 * This turns on tooltips and unchecks the checkbox.
 *
 * @see #tipOff
 * @see #toggleCheckTip
 * @see #addTipBulk
 */
	void tipOn();

/**
 * This turns off tooltips and unchecks the checkbox.
 *
 * @see #tipOn
 * @see #toggleCheckTip
 * @see #removeTipBulk
 */
	void tipOff();

/**
 *	This updated the three LCDs.
 *
 * @see #playCore
 *
 */
	void updateLcd();
	
/**
 * This sets the song, tfmxFile, freq, bits, etc.,
 * updates the display and, if /dev/dsp is free, invokes TFMX-PLAY.
 *
 * @see #updateLcd
 */
	void playCore();

/**
 * This stops the player, neccessary display updates are also made.
 *
 * @see #stopTfx
 */
	void stopCore();

/**
 * This reads the configuration, determines whether to show the splash-screen,
 * sets up preloading of song from previous session
 *
 * @see #saveConfig
 */
	void readConfig();

/**
 * This saves the configuration.
 *
 * @see #readConfig
 */
	void saveConfig();

// --------------- these are mainly used by the constructor -----------------

/**
 * Check if tfmx-play can be executed, exit with error message otherwise.
 * This method does the i18n init for the error box on its own!
 *
 * @see #i18nInitBulk
 */
	void checkTfx();

/**
 * This creates an accelerator and adds all the keyboard shortcuts.
 *
 * @see #buttonInit
 */
	void accInit(); 

/**
 * This connects all the buttons to the various slots.
 *
 * @see #buttonInit
 */
	void buttonInit();

/**
 * This sets all the initial defaults for the player, just to be safe...
 *
 * @see #buttonInit
 */
	void initParanoia();
	
/**
 * This evaluates the command-line arguments and, if valid, overrides the
 * current tfmxFile || ( tfmxFile && song ) settings.
 *
 * @see #initPreload
 */
	void evalComm();

/**
 * This updates the display and starts the player, if a song is
 * preloaded via the config file or command-line argument.
 *
 * @see #readConfig
 * @see #evalComm
 */
	void initPreload();

/**
 * Set up the drop zone for drag-and-drop
 *
 * @see KTfxControlData#dropAction
 */
	void setupDropzone();

/**
 * Here we initialize most of the translations for buttons,
 * tooltips, message-boxes, etc.
 *
 * @see #checkTfx
 */
	void i18nInitBulk();
	
// ------------------------ enter the slots -------------------------

protected slots:

/**
 * Toggle oversampling on/off.
 */
	void toggleOversampling();
	
/**
 * Toggle oversampling and button on/off.
 */
 void toggleOsampButton();

/**
 * Called to cleanup the KShellProcess after the player has been stopped,
 * by means of the stop button, for example.
 */
	void done(KProcess*);

/**
 * This slot stops the player, then quits the application.
 *
 * @see KTfxControlData
 * @see #stopTfx
 */
	void quitTfx();

/**
 * This slot opens a KFileDialog to get a new tfmxFile to play,
 * if myFile is 0. Otherwise, the path given in myFile is used instead.
 * Valid selections are played, config is saved.
 *
 * @param myFile is the path to the file to be opened.
 * @see KTfxControlData
 * @see #playTfx
 */
	void openTfx(QString myFile);

/**
 * Overloaded w/o paramter.
 */
	void openTfx();
	
/**
 * This slot stops the player, then saves the config.
 *
 * @see KTfxControlData
 * @see #playTfx
 * @see #saveConfig
 * @see #stopCore
 */
	void stopTfx();

/**
 * This slot plays the current file, otherwise openTfx is called
 * to get a file. Config is saved.
 *
 * @see KTfxControlData
 * @see #openTfx
 * @see #playCore
 * @see #saveConfig
 */
	void playTfx();

/**
 * This slot increases song num. and calls stopTfx and playTfx if necessary.
 * Config is saved.
 *
 * @see KTfxControlData
 * @see #songDown
 * @see #playTfx
 * @see #stopTfx
 * @see #saveConfig
 */
	void songUp();

/**
 * This slot decreases song num. and calls stopTfx and playTfx if necessary.
 * Config is saved.
 *
 * @see KTfxControlData
 * @see #songUp
 * @see #playTfx
 * @see #stopTfx
 * @see #saveConfig
 */
	void songDown();

/**
 * This slot increases freq and calls stopTfx and playTfx if necessary.
 * Config is saved.
 *
 * @see KTfxControlData
 * @see #freqDown
 * @see #playTfx
 * @see #stopTfx
 * @see #saveConfig
 */
	void freqUp();
	
/**
 * This slot decreases freq and calls stopTfx and playTfx if necessary.
 * Config is saved.
 *
 * @see KTfxControlData
 * @see #freqUp
 * @see #playTfx
 * @see #stopTfx
 * @see #saveConfig
 */
	void freqDown();

/**
 * This slot switches to 16 bits and calls stopTfx and playTfx if necessary.
 * Config is saved.
 *
 * @see KTfxControlData
 * @see #bitsLo
 * @see #playTfx
 * @see #stopTfx
 * @see #saveConfig
 */
	void bitsHi();

/**
 * This slot switches to 8 bits and calls stopTfx and playTfx if necessary.
 * Config is saved.
 *
 * @see KTfxControlData
 * @see #bitsHi
 * @see #playTfx
 * @see #stopTfx
 * @see #saveConfig
 */
	void bitsLo();

/**
 * Set stereo output mode, stop/restart/save config works as usual.
 *
 * @see #setMono
 * @see #setHeadphones
 * @see #playTfx
 * @see #stopTfx
 * @see #saveConfig
 */
	void setStereo();
	
/**
 * Set headphone output mode, stop/restart/save config works as usual.
 * If you want to use headphones with a stereo soundcard,
 * this mode usually sounds better than reguar stereo.
 *
 * @see #setStereo
 * @see #setMono
 * @see #playTfx
 * @see #stopTfx
 * @see #saveConfig
 */
	void setHeadphones();
	
/**
 * Set mono output mode, stop/restart/save config works as usual.
 *
 * @see #setHeadphones
 * @see #setStereo
 * @see #playTfx
 * @see #stopTfx
 * @see #saveConfig
 */
	void setMono();

/**
 * This slot toggles tooltips on/off, depending on current status
 * of the checkbox. Config is saved.
 *
 * @see KTfxControlData
 * @see #toggleCheckTip
 * @see #tipOff
 * @see #tipOn
 * @see #saveConfig
 * @see #addTipBulk
 * @see #removeTipBulk
 */
	void toggleTip();

/**
 * This slot turns tooltips off if are on and vice versa.
 * The checkbox is (un)checked, config is saved.
 *
 * @see KTfxControlData
 * @see #toggleTip
 * @see #tipOff
 * @see #tipOn
 * @see #saveConfig
 */
	void toggleCheckTip();

/**
 * This does the real work of adding all the tooltips, nothing else.
 */
	void addTipBulk();
	
/**
 * This does the real work of removing all the tooltips, nothing else.
 */
	void removeTipBulk();
		
/**
 * This slot invokes the HTML online help.
 *
 * @see KTfxControlData
 * @see #about
 */
	void help();

/**
 * This slot shows the "about" box.
 * I just couldn't resist putting the new application
 * into the about box, it's just too "kawaii"!
 *
 * @see KTfxControlData
 * @see #help
 */
	void about();

/**
 * DND slot, activated when something is dropped on the dropzone.
 *
 * @param dz the dropzone that activated this slot
 * @see #setupDropzone
 */
	void dropAction(KDNDDropZone *dz);

/**
 * Returns path of smpl.-file for given mdat.-filepath,
 * if smpl.-file exists. Returns 0 otherwise.
 *
 * @param mdatPath a string containing the path of the mdat. file
 */
	QString samplePath(QString mdatPath);

 	
};

#endif // KTFXWIDGET_H







