// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/modules/MEcho.cc,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:02:16 $
// $State: Exp $
// **************************************************************
#ifdef HIRN

#include "ModuleMacros.h"

#define MODULE_NAME "echo"

BEGIN_MODULE_DEFINITION(Echo);
  SoundSlot  *ss_input;
  NumberSlot *ns_delay;
  NumberSlot *ns_ratio;
END_MODULE_DEFINITION(Echo);

class SSEchoOutput : public SoundSignal
{
public:
  SSEchoOutput(MEcho *m) : SoundSignal(m) {};
  String getName() const { return "output"; };
  PreparedSoundSignal *prepareSignal(Metainfo&, const Parameterset&);
};

class PSSEchoOutput : public PreparedSoundSignal
{
  friend class SSEchoOutput;
  PreparedSoundSignal *pss_input;
  long                 delay_samples;
  Number               ratio;
public:
    PSSEchoOutput(PreparedSoundSignal *in, long ds, Number r) :
	pss_input(in), delay_samples(ds), ratio(r) {};
    ~PSSEchoOutput() { delete pss_input; };
    void computeSamples(Number *, long start_time, long number_of_samples) const;
};


// ---------------------------------------------------------------------------
//                             Implementation
// ---------------------------------------------------------------------------
#include <math.h> // rint()

#include "NullSound.h"

MEcho::MEcho(InputModuleFile *)
{
  declareSlot(ss_input = new SoundSlot("input"));
  declareSlot(ns_delay = new NumberSlot("delay"));
  declareSlot(ns_ratio = new NumberSlot("ratio"));
  declareSignal(new SSEchoOutput(this));
}


PreparedSoundSignal *SSEchoOutput::prepareSignal(Metainfo& mi,
						 const Parameterset &parset)
{
    PreparedSoundSignal *input = ((MEcho *)module)->ss_input->prepareSignal(mi, parset);
    
    // I need information about the sampling interval from either direction

    Number sampling_interval = getSamplingInterval(mi, parset);
    if (sampling_interval <= 0) {
	delete input;
	return NullSound::getPreparedNullSignal(mi, parset);
    }

    Number ratio =   ((MEcho *)module)->ns_ratio->getNumber();
    Number delay =   ((MEcho *)module)->ns_delay->getNumber();
    long delay_samples = (long)rint(delay / sampling_interval);
    if (mi.containsCutTo()) mi.setCutTo(mi.getCutTo() + delay_samples);
    // TODO: negative delay make problems?
    return new PSSEchoOutput(input, delay_samples, ratio);
}


void PSSEchoOutput::computeSamples(Number *output,long start_time, long nsamples) const
{
  SoundPortion sp_original = pss_input->getSoundPortion(start_time, nsamples);
  SoundPortion sp_echo     = pss_input->getSoundPortion(start_time-delay_samples, nsamples);
  const Number *original   = sp_original.getSamples();
  const Number *echo       = sp_echo.getSamples();
  while (nsamples--) *output++ = *original++ + (ratio * *echo++);
}

#endif // HIRN
