#include <math.h>

#include "MScalarDisplay.h"
#include "LookMacros.h"

const int max_number_marks = 12;

class MLAnalogScalarDisplayA : public ModuleLook
{
    int last_marks;
public:
    MLAnalogScalarDisplayA(Module *module, ModuleLookGenerator *mlg) 
	: ModuleLook(module, mlg), last_marks(-1) {};
    static int  getMarks(Number value);
    bool needsRepaint();
};

class MLGAnalogScalarDisplayA : public ModuleLookGenerator
{
public:
    ModuleLook *create(Module *module) { return new MLAnalogScalarDisplayA(module, this); };
    string getName() const { return "analog-scalar-display-a"; };
    const char *menuPath() const { return "Display/Scalar"; }
    QSize gridSize() const { return QSize(1,4); };
    void paint(QPainter&, Module *);
};

MLGAnalogScalarDisplayA mlg_AnalogScalarDisplayA;

// ----------------------------------------------------------------------

int MLAnalogScalarDisplayA::getMarks(Number value)
{
    return max(0, min(max_number_marks, (int)rint(10 * value)));
}

bool MLAnalogScalarDisplayA::needsRepaint()
{
    // Per definition of needsRepaint() I assume, that I will be painted.
    // So i set last_marks to marks here and not in paint(). In paint()
    // I have no access to the MLAnalogScalarDisplayA, but only to the
    // MScalarDisplay!

    Number value = ((MScalarDisplay *)getModule())->getValue();
    int  marks = getMarks(value);
    if (last_marks != marks) {
	last_marks = marks;
	return true;
    }
    else return false;
}

void MLGAnalogScalarDisplayA::paint(QPainter& p, Module *module)
{
    int marks = module 
	? MLAnalogScalarDisplayA::getMarks(((MScalarDisplay *)module)->getValue()) 
	: max_number_marks;
    
    p.setBackgroundColor(black);
    p.eraseRect(0, 0, width(), height());
    p.setBrush(QColor(0,160,0));
    p.setPen(green);
    for (int i=1; i <= marks; i++)
    {
	if (i == 9) {
	    p.setBrush(QColor(160,160,0));
	    p.setPen(yellow);
	}
	else if (i == 11) {
	    p.setBrush(QColor(160,0,0));
	    p.setPen(red);
	}
	p.drawRect(2, 3 + (max_number_marks - i) * 5, 12, 3);
    }
}
