// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/looks/LookMacros.h,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:08:07 $
// $State: Exp $
// **************************************************************

#ifndef LookMacros_h
#define LookMacros_h

#include <qsize.h>

#include "ModuleLook.h"
#include "PixmapModuleLookGenerator.h"
#include "TextModuleLookGenerator.h"
#include "Module.h"

#define PIXMAP_LOOK(name, xpmname, menupath, width, height)			\
class MLG ## xpmname : public PixmapModuleLookGenerator				\
{										\
public:										\
    string getName() const { return (name); };					\
    const char *menuPath() const { return (menupath); };			\
    const char **xpm() const { return (const char **)(xpmname ## _xpm); };	\
    QSize gridSize()   const { return QSize((width), (height)); };		\
};										\
MLG ## xpmname mlg_ ## xpmname;

#define TEXT_LOOK(name, classname, text, menupath, width, height)	\
class MLG ## classname : public TextModuleLookGenerator			\
{									\
public:									\
    string getName() const { return (name); };				\
    const char *menuPath() const { return (menupath); };		\
    string getText() const { return (text); };				\
    QSize gridSize() const { return QSize((width), (height)); };	\
};									\
MLG ## classname mlg_ ## classname;

#endif // LookMacros_h
