// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/editor/EnterValueDialog.cc,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:14:35 $
// $State: Exp $
// **************************************************************

#include <qvalidator.h>
#include <qlined.h>
#include <stdio.h> // sprintf
#include <stdlib.h> // atof
#include <string.h> // strcspn

#include "language.h"

#include "EnterValueDialog.h"
#include "EnterValueDialog-moc.h"


class TextValidator : public QValidator
{
    QString banned_chars;
public:
    TextValidator(QWidget *parent, QString banned_chars) 
	: QValidator(parent), banned_chars(banned_chars) {};
    State validate(QString&, int&);
};

QValidator::State TextValidator::validate(QString& string, int&)
{
    if (strcspn((const char *)string, (const char *)banned_chars) != string.length())
	return Invalid;
    else if (string == "") return Invalid;
    else return Acceptable;
}


EnterValueDialog::EnterValueDialog(QString windowtitle)
    : QDialog(0, windowtitle, TRUE, WStyle_Customize | WStyle_NoBorder | WStyle_Tool)
    , lineedit(0)
{
    setCaption(windowtitle);
}


void EnterValueDialog::setLineEdit(QLineEdit *le)
{
    lineedit = le;
    connect(lineedit, SIGNAL(returnPressed()), SLOT(accept()));
    setGeometry(QCursor::pos().x() - 100,
		QCursor::pos().y() -  19,
		200, 38);
    lineedit->setFocus();
}


void EnterValueDialog::resizeEvent(QResizeEvent *)
{
    if (lineedit) lineedit->setGeometry(5, 5, width()-10, height()-10);
}


void EnterValueDialog::focusInEvent(QFocusEvent *e)
{
    if (e->gotFocus() && lineedit) lineedit->setFocus();
}


Number EnterValueDialog::getNumber(QString windowtitle, Number startvalue)
{
    EnterValueDialog evd(windowtitle);
    QLineEdit lineedit(&evd);
    lineedit.setValidator(new QDoubleValidator(-10000000000.0, +10000000000.0, 2, &lineedit));
    lineedit.setMaxLength(8);
    char string[64];
    sprintf(string, "%5.2f", startvalue);
    lineedit.setText(string);
    evd.setLineEdit(&lineedit);
    if (evd.exec() == Accepted) return atof(lineedit.text());
    else return startvalue;
}


Text EnterValueDialog::getText(QString windowtitle, Text startvalue, QString banned_chars)
{
    EnterValueDialog evd(windowtitle);
    QLineEdit lineedit(&evd);
    lineedit.setValidator(new TextValidator(&lineedit, banned_chars));
    lineedit.setMaxLength(20);
    lineedit.setText(startvalue.c_str());
    evd.setLineEdit(&lineedit);
    if (evd.exec() == Accepted) return lineedit.text();
    else return startvalue;
}
