// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/base/PreparedSoundSignal.h,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:00:37 $
// $State: Exp $
// **************************************************************

#ifndef PreparedSoundSignal_h
#define PreparedSoundSignal_h

#include "PreparedSignal.h"
#include "SoundPortion.h"

class PreparedSoundSignal : public PreparedSignal
{
public:
    /**
     * Override this method to define the meaning of Sound Signal and if you
     * can avoid @ref #computeSamples at least in some cases.
     */
    virtual SoundPortion getSoundPortion(long start_time, long number_of_samples);
protected:
    /**
     * Override this function to actually define the shape of the Sound Signal
     * in cases, you have to calculate sample by sample.
     * This function is called by the default implementation of @ref #getSoundPortion.
     * @param output Wire your samples here. Size of this buffer is nsamples.
     * @param start_time. Startpoint on the t-axis where to begin to compute
     *                    samples. start_time * sampling_interval give the value in Seconds.
     * @param nsamples    Compute this many samples.
     */
    virtual void computeSamples(Number */*output*/, long /*start_time*/, long /*nsamples*/) 
	{ *(long *)0xdeadbeaf = 0xfea1dead; };
};

#endif // PreparedSoundSignal_h
