// -*- c++ -*-
// **************************************************************
// $Source: /home/proj/mmm/cvsroot/mmm/base/NullSound.cc,v $
// $Revision: 1.1 $
// $Date: 1999/05/13 08:00:36 $
// $State: Exp $
// **************************************************************

#include "NullSound.h"
#include "SharedSoundStore.h"
#include "Metainfo.h"
#include "PreparedSoundSignal.h"

SoundPortion NullSound::getNullSound(long nsamples)
{
    static SoundPortion *null_sound_portion = 0;
    static long size_of_null_sound = -1;
    
    if (nsamples > size_of_null_sound) {
	if (null_sound_portion) delete null_sound_portion;
	Number *samples = new Number[nsamples];
	Number *pointer = samples;
	size_of_null_sound = nsamples;
	while (nsamples--) *pointer++ = 0.0;
	null_sound_portion = new SoundPortion(samples, new SharedSoundStore(samples));
    }
    return *null_sound_portion;

    // TODO: Memory leakage. The last SoundPortion will never be deleted. Perhaps it
    // could be stored in the global cache.
}


PreparedSoundSignal *NullSound::getPreparedNullSignal(Metainfo* mi, const Parameterset*)
{
    // I deliver defensive Metainformation.
    
    // since the Metainfo CutFrom and CutTo are used to refine
    // the intervall, that is different vom 0, I can set both to
    // the same value, lets say 0.
    // All other Metainfos must not be set to any value.

    Metainfo new_mi;
    if (mi->containsCutFrom()) new_mi.setCutFrom(0);
    if (mi->containsCutTo())   new_mi.setCutTo(0);
    *mi = new_mi;
    return new PreparedNullSignal();
}
