	/*

	Copyright (C) 1998 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#include "midibus.h"
#include <unistd.h>
#include <stdio.h>
#include <fcntl.h>

extern "C" {
#include "utils.h"
}

#define NOTE_ON 0x90

int main( int argc, char **argv )
{
// ---- connect to midibus

	printf("connecting orb\n");
	CORBA::ORB_var orb = CORBA::ORB_init( argc, argv, "mico-local-orb" );
	CORBA::BOA_var boa = orb->BOA_init( argc, argv, "mico-local-boa" );

	printf("trying to bind\n");
	CORBA::Object_var obj =
		orb->bind ("IDL:MidiChannel:1.0", "inet:localhost:8888");
	if (CORBA::is_nil (obj)) {
		fprintf(stderr,"no midichannel object found, start synth_server or some other midibus aware\n");
		fprintf(stderr,"piece of software... ;)\n");
		exit(1);
	}

	printf("binding\n");
	MidiChannel_var midich = MidiChannel::_narrow (obj);

	printf("ready\n");
// ---- now midich is connected

	char device[256] = "/dev/midi00";
	bool testperformance = false;
	int optch;

	while((optch = getopt(argc,argv,"d:t")) > 0)
	{
		switch(optch)
		{
			case 'd': strncpy(device,optarg,255);
					  printf("mididevice is %s\n",device);
				break;
			case 't': testperformance = true;
					  printf("running performance tests\n");
				break;
			default:
					fprintf(stderr,"\nUsage: %s [ -d mididevice -t ]\n\n",
																	argv[0]);
					fprintf(stderr,"   -t   test performance by sending as ");
					fprintf(stderr,"many events as possible");
					exit(1);
				break;
		}
	}
	int midi = open(device,O_RDONLY);
	unsigned char ch,ch2, command, channel;

	if(testperformance)
	{
		int i;
		float exectime;

		benchmark(BENCH_BEGIN);
		for(i=0;i<1000;i++)
		{
			midich->noteOn(0, 12*3, 100);
			midich->noteOn(0, 12*3+3, 100);
			midich->noteOn(0, 12*3+7, 100);
		
		}
		exectime = benchmark(BENCH_END);

		printf("Sending 3000 midi events takes %2.2f seconds\n",exectime);
		printf("That is a rate of %d events per second\n",(int)(3000/exectime));
		exit(1);
	}

	printf("starting midi loop\n");
	while(read(midi,&ch,1) == 1)
	{
		printf("%2x ",ch);

		if(ch & 0x80) {
			if(ch < 0xf0) // no realtime message
			{
				command = (ch & 0xf0);
				channel = ch & 0xf;
				printf("[ command %2x, channel %2x ]",command,channel);
			}
		}
		else
		{
			if(command == NOTE_ON)
			{
				read(midi,&ch2,1); // TODO: test - should return 1 here!

				if(ch2 == 0) // is a note off (note on with volume 0)
				{
					printf("\n>> sending NOTEOFF...\n");
					fflush(stdout);
					midich->noteOff(channel, ch);
					printf("\n>> NOTEOFF sent...\n");
					fflush(stdout);
				}
				else
				{
					printf("\n>> MIDISEND: sent noteon channel=%d, note=%d, volume=%d\n",channel,ch,ch2);
					fflush(stdout);
					midich->noteOn(channel, ch, ch2);
					printf(">> done MIDISEND\n");
					fflush(stdout);
				}
			}
		}

		printf("--- waiting for a byte from the midi port...:");		
		fflush(stdout);
	}

	return 0;
}
