/*
    KSrnd
    
    A control panel for the miroMEDIA Surround Dolby Pro Logic decoder.

    Copyright (C) 1998-2000 Oliver Gantz (o.gantz@tu-bs.de)

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

    ----
    3D-Phonic(R) is a registered trademark of VICTOR COMPANY OF JAPAN, LIMITED.
    DOLBY and PRO LOGIC are trademarks of Dolby Laboratories Licensing Corporation.
    miro(R) is a registered trademark of miro Computer Products AG.
*/

#ifndef KSRNDSETUP_H 
#define KSRNDSETUP_H 

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif 

#include <qtabdlg.h>	// <qtabdialog.h>
#include <qwidget.h>
#include <qbttngrp.h>	// <qbuttongroup.h>
#include <qradiobt.h>	// <qradiobutton.h>
#include <qlabel.h>
#include <qcombo.h>	// <qcombobox.h>
#include <qpushbt.h>	// <qpushbutton.h>

#include <kconfig.h>

#undef Above		// Avoid Qt <-> X11 conflict
#undef Below
#include <qslider.h>

#include "srnddev.h"



class KSrndSetup : public QTabDialog
{
	Q_OBJECT

public:
	KSrndSetup( QWidget * parent, char * devname );
	virtual ~KSrndSetup();
  
	void addToolTips( bool on );
	void getSrndVersion( char * ver );
	void initMode();
	void setMode( int mode );
	void setVolume( int vol );
	void setBypass( bool on );

public slots:
	void reset();
	void apply();

private slots:
	void setDBPLMode( int mode );
	void setDBPLVolLR( int vol );
	void setDBPLVolC( int vol );
	void setDBPLVolS( int vol );
	void setDBPLDelay( int delay );
	void DBPLOptimize();

	void set3DPhonMode( int mode );
	void set3DPhonLevel( int level );

	void setNoiseMode( int mode );
	void setNoiseLevel( int level );

private:
	KConfig * KsConfig;

	bool gotToolTips;

	SrndDev * srnddev;
	int currentmode;

	QWidget * page1, * page2, * page3;

	QButtonGroup * dbspeaker;
	QRadioButton * dbspeakerb[4];
	QSlider * dbvollr, * dbvolc, * dbvols;
	QLabel * dblabc, * dbpixc, * dblabs, * dbpixs, * dbdelayms;
	QSlider * dbdelay;
        QPushButton * dboptimize;
  
	QButtonGroup * tdeffect;
	QRadioButton * tdeffectb[4];
	QSlider * tdlevel;
  
	QComboBox * nmode;
	QSlider * nlevel;
};


#endif // KSRNDSETUP_H
