/***************************************************************************
                          kmp3info.h  -  description                              
                             -------------------                                         
    begin                : Son Dez  5 13:44:54 CET 1999
                                           
    copyright            : (C) 1999 by Frank von Daak                         
    email                : frank.fun@skydsl.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef KMP3INFO_H
#define KMP3INFO_H

#include <iostream.h>

#include <kapp.h>
#include <ktmainwindow.h>
#include <kmenubar.h>
#include <ktoolbar.h>
#include <kiconloader.h>
#include <kiconloaderdialog.h>
#include <kfiledialog.h>
#include <kprocess.h>
#include <kglobal.h>
#include <kconfig.h>

#include <qwidget.h>
#include <qframe.h>
#include <qdialog.h>
#include <qfont.h>
#include <qfile.h>
#include <qlabel.h>
#include <qpopupmenu.h>
#include <qdir.h>
#include <qstring.h>
#include <qstrlist.h>
#include <qmessagebox.h>
#include <qlineedit.h>
#include <qmultilinedit.h>
#include <qprintdialog.h>
#include <qprinter.h>

#include <ctype.h>
#include <string.h>
#include <curses.h>
#include <signal.h>

void tagedit_curs(FILE *fp, char *filename, char *line);

#define CTRL_C		'\003'
#define TEXT_FIELD_LEN	30
#define INT_FIELD_LEN	4

void CenterText(int line, char *text);
char *checkinput(int c, char *string, int length);
void pad(char *string, int length);
char *curs_addparam(WINDOW *win, int line, int length, char *buf);
void buildtag(char *buf, char *title, char *artist, char *album, char *year, char *comment, unsigned char *genre);
void display_help();
void view_tag(FILE *fp);

class KMP3Info : public KTMainWindow {
  Q_OBJECT

public: 
  /** construtor */
  KMP3Info();
  /** destructor */
  ~KMP3Info();
  
private:
	QWidget *prefWidg;
	QFrame *titleFrame, *mainFrame;
	QLabel *title1,*title2, *fileLab, *titleLab, *artistLab, *albumLab, *jahrLab, *commentLab;
	QMultiLineEdit *fileLine;
	QLineEdit *titleLine, *artistLine, *albumLine, *jahrLine, *commentLine, *pathLine;
	QPopupMenu *file_menu, *options_menu, *view_menu, *help_menu;
	QString fileToOpen, fileName, mp3player;
	KConfig *config;
	int titleXPos1, titleXLen1,titleXPos2, titleXLen2;
	int ID_TOPEN, ID_OPEN, ID_FILE_SAVE,ID_TFILE_SAVE;
	int ID_FILE_PRINT, ID_FILE_QUIT, ID_EDIT_CUT, ID_EDIT_COPY, ID_EDIT_PASTE, ID_VIEW_TOOLBAR;
	int ID_VIEW_STATUSBAR;
	char fulltag[128];
	FILE *fp;
	unsigned char sig[2];
	char *gpad (char *, int);
	
	void unpad(char *);
	void initView();
	void initMenuBar();
	void initToolBar();
	
protected:
//	void timerEvent (QTimerEvent *e);
		
public slots:
	void openFile(int);
	void openFile();
	void saveFile();
	void playFile();
	void saveFile(int);
	void playFile(int);
	void prefMenu();
	void slotLoadPlayer();
	void slotPrefKill();
	void slotPrefSave();
	void playError(KProcess*, char *, int);
	void argvFile();
	
public:
	void getArgv(char *);

};
#endif