/***************************************************************************
                          fnameinfodlg.cpp  -  description                              
                             -------------------                                         
    begin                : Tue Feb 22 2000                                           
    copyright            : (C) 2000 by Edwin Schepers                         
    email                : zeus@castel.nl                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/
#include <stdio.h>

#include <qlabel.h>
#include <qdialog.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qmessagebox.h>

#include "fnameinfodlg.h"

FnameInfoDlg::FnameInfoDlg(char *separator, QWidget *parent, const char *name)
      : QDialog(parent, name, TRUE){
 QRect r;
 int y=10;

 //setCaption(i18n("Set Properties")); ? I thought this was possible..
 strcpy(separator, "-");

 setFixedSize(290, 200);
 r.setRect(10,y,10,25);
 QLabel *paramlabel = new QLabel("1", this,"paramlabel");
 //startpathLabel->setText("start path:");
 paramlabel->setGeometry(r);

 r.setRect(20,y,100,25);
 combo1 = new QComboBox(FALSE, this,"kind");
 combo1->insertItem("artist");
 combo1->insertItem("title");
 combo1->setGeometry(r);

 y+=35;
 r.setRect(10,y,130,25);
 QLabel *seplabel = new QLabel("Separator", this,"seplabel");
 seplabel->setGeometry(r);

 r.setRect(70,y,20,25);
 separatorLE = new QLineEdit(this,"sep");
 //strcpy(mp3dbpath, "/tmp/mp3.db");
 separatorLE->setText(separator);
 separatorLE->setGeometry(r);

 y+=35;
 r.setRect(10,y,100,25);
 QLabel *paramlabel2 = new QLabel("2", this,"paramlabel");
 paramlabel2->setGeometry(r);

 r.setRect(20,y,100,25);
 combo2 = new QComboBox(FALSE, this,"playerpath");
 combo2->insertItem("title");
 combo2->insertItem("artist");
 combo2->setGeometry(r);

 y+=25;
 chkboxInfoFromFnameOnlyIfNoTAG =  new QCheckBox("Only use info from filename if no tag exists", this);
 r.setRect(10,y+20,260,20);
 chkboxInfoFromFnameOnlyIfNoTAG->setGeometry(r);
 chkboxInfoFromFnameOnlyIfNoTAG->setChecked(TRUE);

 y = r.bottom() - 60;
// r. setLeft(
 ok = new QPushButton("Ok", this, "ok");
printf("r.x=%d, r.y=%d, r.bottom=%d\n", r.x(),r.y(), r.bottom());
 r.setRect(10,150,80,25);
 ok->setGeometry(r);
 connect(ok, SIGNAL(clicked()), this, SLOT(check_before_accept()));
 ok->setDefault(true);

 cancel = new QPushButton("Cancel", this, "cancel");
 cancel->setFocus();
 r.moveBy(150,0);
 cancel->setGeometry(r);
 connect(cancel, SIGNAL(clicked()), this, SLOT(reject()));



}

char *FnameInfoDlg::getSeparator(void) {
 return separatorLE->text();
}

//FnameInfoDlg::~FnameInfoDlg(){
//}

bool FnameInfoDlg::forceFname(void) {
 return  (!chkboxInfoFromFnameOnlyIfNoTAG->isChecked());
}

void FnameInfoDlg::check_before_accept(void) {
 if (strlen(separatorLE->text()) == 0) {
    QMessageBox *pop;
    pop->information( this, "Oops", "You need to fill in a separator");
    return;
 }
 accept();
}

int FnameInfoDlg::getCurrentItemFromCombo(int ComboNr) {
 switch (ComboNr) {
  case 0: // first Combo
     return combo1->currentItem();
  case 1: // second combo
     return combo2->currentItem();
 }
}











































