
/*
  Default output decoder
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __OUTPUTDECODER_H
#define __OUTPUTDECODER_H

#include <yafcore/commandLine.h>

#include <yafcore/runtimeTableYAF.h>
#include <yafcore/commandTableYAF.h>


class OutputDecoder  {

 public:
  OutputDecoder();
  virtual ~OutputDecoder();

  void processCommandLine(CommandLine*);
  virtual int processRuntimeCommand(int command,char* args);
  virtual int processReturnCommand(int cmdNr,int cmdId,char* ret,char* args);

  void appendCommandTable(CommandTable* table);
  void appendRuntimeTable(CommandTable* table);

  CommandTable* getRuntimeTable();
  CommandTable* getCommandTable();

 private:
  CommandTable* yafCommands;
  CommandTable* yafRuntime;

  CommandTable commandTable;
  CommandTable runtimeTable;


};


#endif
