/*
  stores decoder in a form {ident,pointer}
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <util/ptrArray.h>
#include "../../../../config.h"


PtrArray::PtrArray(int nSize) {
  int i;
  this->nSize=nSize;
  decoderMapper=new DecoderMapper* [nSize];
  for(i=0;i<nSize;i++) {
    decoderMapper[i]=(DecoderMapper*) new (DecoderMapper);
    decoderMapper[i]->id=-1;   // mark as invalid
  }
  counter=42;     // smallest arbitrary number
  fillPos=0;
}


PtrArray::~PtrArray() {
  int i;
  for(i=0;i<nSize;i++) {
    delete decoderMapper[i];
  }
  delete decoderMapper;
}

int PtrArray::maxSize() {
  return nSize;
}


int PtrArray::add(void* ptr) {
  int back;
  if (fillPos >= nSize) {
    debugOutput( cout << "Couldn't add ptr -> Array overflow"<<endl );
    return -1;
  }
  decoderMapper[fillPos]->ptr=ptr;
  decoderMapper[fillPos]->id=counter;
  back=counter;
  counter++;
  fillPos++;
  return back;
}

  
void* PtrArray::find(int id) {
  int i;
  for(i=0;i<fillPos;i++) {
    if (decoderMapper[i]->id==id) {
      return decoderMapper[i]->ptr;
    }
  }
  return NULL;
}


int PtrArray::find(void* aPtr) {
  int i;
  for(i=0;i<fillPos;i++) {
    if (decoderMapper[i]->ptr==aPtr) {
      return decoderMapper[i]->id;
    }
  }
  return -1;
}


/*
  Note : remove only resizes the Array! The Object of
  the pointer is _not_ freed
*/
void PtrArray::remove(int id) {
  int i;
  int j;
  if (id > 0) {
    for(i=0;i<fillPos;i++) {
      if ((decoderMapper[i]->id==id) && (id != -1)) {
	for(j=i;j<(fillPos-1);j++) {
	  decoderMapper[j]->id=decoderMapper[j+1]->id;
	  decoderMapper[j]->ptr=decoderMapper[j+1]->ptr;
	}
	if (fillPos < nSize) {
	  decoderMapper[fillPos]->id=-1;
	}
	fillPos--;
	break;
      }
    }
  }
}
 

void PtrArray::remove(void* aPtr) {
  int id=find(aPtr);
  remove(id);
}


    
int PtrArray::getFillgrade() {
  return fillPos;
}


void* PtrArray::getPtrAt(int i) {
  if (i >= fillPos) {
    debugOutput( cout << "Access outsize buffer !"<<endl );
    return NULL;
  }
  return decoderMapper[i]->ptr;
}




