/*
  internally used by yafProcess
  Copyright (C) 1999  Martin Vogt,Christian Czezatke

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

*/


/*

  This file was originally written by Christian Czezatke, but
  was modified to abstract the signal mechanism (gtk port)

*/


#include <string.h>
#include <errno.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <fcntl.h>

#include <stdio.h>

#include <signal/process/yafProcess.h>
#include <signal/process/yafProcessController.h>
#include "../../../../config.h"



YafProcessController *theYafProcessController = 0;

YafProcessController::YafProcessController() {
  struct sigaction act;

  // initialize theKProcessList
  processList = new QList<YafProcess>();
  CHECK_PTR(processList);
 
  if (0 > pipe(fd))
    printf(strerror(errno));
  
  if (-1 == fcntl(fd[0], F_SETFL, O_NONBLOCK))
    printf(strerror(errno));

  notifier = new QSocketNotifier(fd[0], QSocketNotifier::Read);
  notifier->setEnabled(TRUE);
  QObject::connect(notifier, SIGNAL(activated(int)),
		   this, SLOT(slotDoHousekeeping(int)));
 		 
  act.sa_handler=theSigCHLDHandler;
  sigemptyset(&(act.sa_mask));
  sigaddset(&(act.sa_mask), SIGCHLD);
  act.sa_flags = SA_NOCLDSTOP;

  // CC: take care of SunOS which automatically restarts interrupted system
  // calls (and thus does not have SA_RESTART)

#ifdef SA_RESTART
  act.sa_flags |= SA_RESTART;
#endif

  sigaction( SIGCHLD, &act, NULL); 
  act.sa_handler=SIG_IGN;
  sigemptyset(&(act.sa_mask));
  sigaddset(&(act.sa_mask), SIGPIPE);
  act.sa_flags = 0;
  sigaction( SIGPIPE, &act, NULL);
}


void YafProcessController::theSigCHLDHandler(int ) {
  int status;
  pid_t this_pid;
  int saved_errno;
  saved_errno = errno;
  // since waitpid and write change errno, we have to save it and restore it
  // (Richard Stevens, Advanced programming in the Unix Environment)
  while(true) {
    this_pid = waitpid(-1, &status, WNOHANG);
    if (this_pid <= 0) {
      break;
    }
    // J6t: theYafProcessController might be already destroyed
    if (-1 != this_pid && theYafProcessController != 0) {
      ::write(theYafProcessController->fd[1], &this_pid, sizeof(this_pid));
      ::write(theYafProcessController->fd[1], &status, sizeof(status));
    }
  }
  errno = saved_errno;
}



void YafProcessController::slotDoHousekeeping(int){
  YafProcess *proc;
  int bytes_read;
  pid_t pid;
  int status;
  bytes_read  = ::read(fd[0], &pid, sizeof(pid_t));
  bytes_read += ::read(fd[0], &status, sizeof(int));

  if (bytes_read != sizeof(int)+sizeof(pid_t))
    debugOutput( cout<<"Error: Could not read info from signal handler!"<<endl );
 
  proc = processList->first();

  while (NULL != proc) {
    if (proc->pid == pid) {
      // process has exited, so do emit the respective events
      proc->processHasExited(status);
    }
    proc = processList->next();
  }
}

YafProcessController::~YafProcessController() {
  struct sigaction act;

  notifier->setEnabled(FALSE);

  // Turn off notification for processes that have exited
  act.sa_handler=SIG_IGN;
  sigemptyset(&(act.sa_mask));
  sigaddset(&(act.sa_mask), SIGCHLD);
  act.sa_flags = 0;
  sigaction( SIGCHLD, &act, NULL);
  
  close(fd[0]);
  close(fd[1]);
  delete processList;
  delete notifier;
}






