/*
  adds basic commands for a xplayer and controls a yafClient.
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __YAFXPLAYERCONTROL_H
#define __YAFXPLAYERCONTROL_H



#include <iostream.h>
#include <qobject.h>
#include <qstring.h>
#include <producer/yaf/yafClient.h>
#include <yafcore/lineStack.h>

#include <yafxplayer/xplayerRuntime.defs>
#include <yafxplayer/xplayerCommand.defs>
#include <yafxplayer/runtimeTableXPlayer.h>
#include <yafxplayer/commandTableXPlayer.h>


class YafXPlayerControl : public YafClient {
      Q_OBJECT
   public:

      YafXPlayerControl();
      ~YafXPlayerControl();
      int open(char* filename );
      int close();
      int play();
      int pause();
      int jump(int);
      int send(char* msg);
      
      // These functions are called when we make a "stream" reset.
      // Then we stores the commands in the buffer, until the
      // decoder "reset" is done

      void setOnline(int online);

 private:
      int bufferedSend(char* msg);
      CommandTable* ct;
      CommandTable* rt;
      // This buffer stores the commands
      LineStack* lineStack;
      Buffer* lineBuffer;
      int onlineCounter;        // if zero->online
};



#endif
