/*
  sends the yafControl messages to the conneted listeners
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */





#ifndef __YAFMULTICASTER_H
#define __YAFMULTICASTER_H


#include <util/controlChannel.h>



typedef struct {
  int valid;
  ControlChannel* listener;
} ListenerEntry;

#define _MAX_LISTENERS  5



class YafMulticaster {

  ListenerEntry* listenerArray[_MAX_LISTENERS];

 public:
  YafMulticaster();
  ~YafMulticaster();

  void multicastRuntimeCommand(int command,char* args);
  void multicastReturnCommand(int cmdNr,int cmdId,char* ret,char* args);
  void addYafListener(ControlChannel* listener);
  void removeYafListener(ControlChannel* listener);
 

};
#endif

