/*
  A simple producer for images.
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <producer/image/imageGenerator.h>
#include "../../../../config.h"


ImageGenerator::ImageGenerator() {
  internal=new QPixmap();
  current=new QPixmap();
  cache=new QPixmap();

  config=new DeviceConfig();
  VideoStream* videoStream=config->getVideoStream();
  statusInfo=videoStream->getStatusInfo();

}


ImageGenerator::~ImageGenerator() {
  delete internal;
  delete current;
  delete cache;
  delete config;
}


int ImageGenerator::updateDeviceConfig(DeviceConfig* newConfig) {
  VideoStream* videoStream=newConfig->getVideoStream();
  VideoInfo* videoInfo;
  MemChunk* memChunk;
  if (statusInfo->getChange()) {
    statusInfo->print();
    videoStream->setStatusInfo(statusInfo);
    newConfig->setStatusInfo(statusInfo);
    statusInfo->setChange(false);
    return _THREAD_DELIVER;
  }

  videoInfo=videoStream->getVideoInfo();
  memChunk=videoInfo->getMemChunk();
  memChunk->waitForUnlock();



  /**
     Here starts a hack to simulate a video stream out of 
     an image.
     We simply scroll the image one pixel to the left
  */

  bitBlt( current, 0,0, 
	  cache,scrollPos,0 ,width-scrollPos,height);   
  bitBlt( current,width-scrollPos ,0, 
	  cache, 0 ,0,scrollPos,height);   

  scrollPos++;
  if (scrollPos > width) {
    scrollPos=0;
  }
  videoInfo->setPixmap(current);

  usleep(500);
  return _THREAD_DELIVER;
}


int ImageGenerator::open(char* filename ) {
  debugOutput( cout << "ImageGenerator -------- open"<<endl );
  setThreadState(_NOT_ALLOW_GENERATOR_ENTER);
  statusInfo->setStatus(_STATUS_PLAYING);
  internal->load(filename);
  cache->load(filename);
  cache=internal;
  current->resize(internal->size());
  scrollPos=0;
  width=internal->width();
  height=internal->height();
  setThreadState(_ALLOW_GENERATOR_ENTER);
  jump(percent);
  return true;
}

/**
   The way we use the images this must stop
   the deliver thread.
   A more powerfull image handling system may change this.
   But the whole image stuff is demo only.
*/
int ImageGenerator::jump(int percent) {
  setThreadState(_NOT_ALLOW_GENERATOR_ENTER);
  this->percent=percent;
  int copyYPos=(int)((float)percent/100.0*(float)height);
  /*
  debugOutput( cout << "copyYPos:"<<copyYPos<<"height:"<<height <<"h-y:"<<height-copyYPos<<endl );
  Is this a bug?
  Why I cannot scroll up down ?     

  */


  bitBlt( cache, 0,0, 
	  internal,0,copyYPos);
  bitBlt( cache,0,height-copyYPos,
	  internal,0,0);
  setThreadState(_ALLOW_GENERATOR_ENTER);
 
  return true;
}



void ImageGenerator::setThreadState(int msg) {
  ThreadNotifier* client;
  client=getThreadNotifier();     // our "phone" to the thread :-)

  client->sendSyncMessage(msg);
  
  debugOutput( cout << "setThreadState:"<<msg<<endl );
}


void ImageGenerator::dataUpdate() {
  if (statusInfo->getChange() == true) {
    debugOutput( cout << "statusInfo change is true"<<endl );
    setThreadState(_ALLOW_GENERATOR_ENTER);
  }
}

