/*
  a generic data producer for deviceConfig entries
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#ifndef __DEVICECONFIGGENERATOR_H
#define __DEVICECONFIGGENERATOR_H


#include <producer/core/threadNotifier.h>
#include <deviceConfig/deviceConfig.h>


/**
  What is this: A Generator?
  <p>
  A Generator creates asynchron new deviceConfigs. A thread enters
  the Generator with its own deviceConfig.
  The Generator must copy a valid deviceConfig into the
  deviceConfig from the thread.
  <p>
  After this the thread leaves and delivers this valid deviceConfig.
  Then sometimes he comes back to get a new one.
  In the meantime the dataGenrator can -asynchronly- change its 
  deviceConfig.
  <p>
  
  The Generator is the main work if you write a new interface.
  Most of the deviceConfig class is highly depend on what 
  your classe does.
  <p>
  Eg: A LineIn/Microphone reader never creates musicInfo, because this
  lineIn stream simply has no info about the music.
  A lineIn Generator cannot use a ringBuffer, because each
  time the thread Enters and want pcm data the data is 
  generated "on the fly"
  <p>
  A Generator coordinates between the  user commands an the current
  deviceConfig. It sometime must stop the thread because it
  cannot fill the deviceConfig and after a time it must wake
  it up.
  <p>
  The important reason is that a thread gets only the deviceConfig
  entries which are "valid" for this stream. Eg. A audioInfo
  with sampleSize 16 Bit but no frequency or a frequency of -1
  is not valid! If the thread enters the Generator must
  consider to stop it immediatley, because at this point
  he cannot deliver any valid data!
  <p>
  Note:
  The streamProducer (the thread) registers itsself with the
  setThreadNotifier(..) This is the way for the Generator
  to send messages to the thread.
*/



class DeviceConfigGenerator   {

  ThreadNotifier* threadNotifier;

 public:
  DeviceConfigGenerator();
  virtual ~DeviceConfigGenerator();

  virtual void setThreadNotifier(ThreadNotifier* threadNotifier);
  ThreadNotifier* getThreadNotifier();
  
  virtual int updateDeviceConfig(DeviceConfig* newConfig);

};


#endif













