/*
  a FFT filter
  Copyright (C) 1998  Martin Vogt;Philip VanBaren, 2 September 1993

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <filter/realFFTFilter.h>

RealFFTFilter::RealFFTFilter(int fftPoints) {
  this->fftPoints = fftPoints;
  data=new short[fftPoints*4];  
  realFFT= new RealFFT(fftPoints*2);
}


RealFFTFilter::~RealFFTFilter() {
  delete data;
  delete realFFT;
}


int RealFFTFilter::getPoints() {
  return fftPoints;
}


short* RealFFTFilter::getPointPtr() {
  return data;
}


/*
  the array is expected to be a PCM stream (real data)
*/
int RealFFTFilter::fft16(DeviceConfig* input) {
  int i;
  int j;

  AudioStream* audioStream=input->getAudioStream();
  AudioInfo* audioInfo=audioStream->getAudioInfo();

  AudioBuffer* audioBuffer=audioStream->getAudioBuffer();
  MemChunk* memChunk=audioBuffer->getMemChunk();
  
  int stereo=audioInfo->getStereo();

  if (memChunk == NULL) {
    return false;
  }

  char* ptr=memChunk->getPtr();
  int len=memChunk->getLen()/2;
  if (len < 2) return false;


  // casting for stereo:
  short* shortPtr=(short*)ptr;
  len=len/2;


  int mixTmp;

  // take care for no array overflows:
  int n=min(len,fftPoints);

  // copy things into fftArray.

  if (stereo == 1) {
    for (i = 0, j = 0; i < n; i++, j+=2) {
      mixTmp=(shortPtr[j]+shortPtr[j+1])/2;
      if (mixTmp < SHRT_MIN) {
	data[i]= SHRT_MIN; 
      } else {
	if (mixTmp > SHRT_MAX) {
	  data[i] = SHRT_MAX; 
	} else {
	  data[i]=(short)mixTmp;
	}
      }
    }
  }

  realFFT->fft(data);
  return true;
}



int* RealFFTFilter::getBitReversed() { 
  return realFFT->getBitReversed();
}



int RealFFTFilter::min(int x1,int x2) { 
  if (x1 < x2) {
    return x1;
  }
  return x2;
}


