/*
  changes the volume in a stream
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include <devices/volumeDevice.h>


VolumeDevice::VolumeDevice():OutputDevice("VolumeDevice") {
  volumeFilter=new VolumeFilter();
  configArray=new DeviceConfigArray();
  // dont start too loud :)
  leftCurrentVolume=-1.0;
  rightCurrentVolume=-1.0;
  volume=50;
  balance=0;
  calculateVolume();
}


VolumeDevice::~VolumeDevice() {
  delete configArray;
  delete volumeFilter;
}


char* VolumeDevice::getNodeName() {
  return "VolumeDevice";
}



void VolumeDevice::setVolume(int percent) {
  volume=(float) percent;
  calculateVolume();
}


int VolumeDevice::getVolume() {
  return (int) volume;
}




void VolumeDevice::setBalance(int balance) {
  this->balance=balance;
  calculateVolume();
}


int VolumeDevice::getBalance() {
  return balance;
}



void VolumeDevice::calculateVolume() {
  float lMul=1.0;
  float rMul=1.0;

  if (balance == 0) {
    // nothing
  } else {
    if (balance < 0) {
      rMul=(100.0+(float)balance)/100.0;
    } else {
      lMul=(100.0-(float)balance)/100.0;
    }
  }
  leftFutureVolume=volume*lMul;
  rightFutureVolume=volume*rMul;
}



void VolumeDevice::writeIn(NodeDevice* source,DeviceConfig* buf) {
  AudioStream* audioStream=buf->getAudioStream();
  VolumeInfo* volumeInfoStream=audioStream->getVolumeInfo();

  // The volumeDevice behaves a bit strange
  // We alwas set the wanted volume in the stream.
  // But this creates only changes messages if the user
  // really changed the volume!
  // This is a correct behaviour. We override any changes
  // because we are the volumeDevice for out stream
  // and we take care that only the volumeChanges which
  // leave our device are notified.
  
  // this alwasy sets change to : true!
  volumeInfoStream->setLeftVolume(leftFutureVolume);
  volumeInfoStream->setRightVolume(rightFutureVolume);
  
  // now override change propagation
  volumeInfoStream->setChange(false);

  // now check if "by user command" there is a change
  if (leftCurrentVolume != leftFutureVolume) {
    leftCurrentVolume=leftFutureVolume;
    volumeInfoStream->setChange(true);
  }

  if (rightCurrentVolume != rightFutureVolume) {
    rightCurrentVolume=rightFutureVolume;
    volumeInfoStream->setChange(true);
  }
  
  // now we deliver to the listeners

  configArray->clear();
  configArray->setDeviceConfigAt(0,buf);
  configArray->setEntries(1);

  writeOut(configArray);

}


