/*
  this device analyses the spectrum and sends notify messages.
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __SPECTRUMANALYSERDEVICE_H
#define __SPECTRUMANALYSERDEVICE_H

#include <devices/outputDevice.h>
#include <filter/realFFTFilter.h>
#include <filter/fixFFTFilter.h>

#define __ANALYSE_MODE_SHORT    1
#define __ANALYSE_MODE_FLOAT    2

#define __SIGNAL_SPECTRUM_ANALYSER_START     3
#define __SIGNAL_SPECTRUM_ANALYSER_STOP      4


/**
  This spectrum analyser devices make a few nasty things with
  the frequency spectrum because it should look nicer.
  <p>
  The idea is to increase the higer frequency values
  (because they are otherwise to small on the scrren)

*/


class SpectrumAnalyserDevice : public OutputDevice {

  RealFFTFilter* realFFTFilter;
  FixFFTFilter* fixFFTFilter;

  int fftBands_fix;   
  int fftBands_short;   
 

  int* fftArray;
  float* fftArray2;
  float* visAnalyserArray;

  int lAnalyse;
  int lAnalyseMode;
  int lEnabled;

 public:

  // totalBands must be a power of two
  SpectrumAnalyserDevice(int fftBands=128);
  ~SpectrumAnalyserDevice();
  char* getNodeName();

  int getBands();
  float* getBandPtr();

  void setAnalyseFreq(int analyseFreq); // update speed
  void setAnalyse(int lAnalyse);    // sets spectrum analyse on/off
  void setAnalyseMode(int mode);    // changes the FFTs

  int getEnabled();
  void setEnabled(int lEnable);


  void writeIn(NodeDevice* source,DeviceConfig* buf);

 protected:
  int hasData();
  void doRealFFT(DeviceConfig* buf);
  void doFloatFFT(DeviceConfig* buf);

};
#endif


