/*
  stores input sources and delivers them simultaneously (abstract class) 
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <devices/multiInputDevice.h>

MultiInputDevice::MultiInputDevice():OutputDevice("MultiInputDevice") {
  multiQueueFifo=new MultiQueueFifo();
  configArray=new DeviceConfigArray();
  lQueueChange=false;
}


MultiInputDevice::~MultiInputDevice() {
  delete multiQueueFifo;
  delete configArray;
}



char* MultiInputDevice::getNodeName() {
  return "MultiInputDevice";
}


void MultiInputDevice::addSource(NodeDevice* source) {
  DeviceConfigFifo* deviceConfigFifo=new DeviceConfigFifo(source);
  multiQueueFifo->insert(deviceConfigFifo);
  OutputDevice::addSource(source);
  lQueueChange=true;
}


void MultiInputDevice::removeSource(NodeDevice* source) {
  multiQueueFifo->remove(source);
  OutputDevice::removeSource(source);
}





void MultiInputDevice::writeIn(NodeDevice* source,DeviceConfig* config) {
  StatusInfo* statusInfo=config->getStatusInfo();
  /**
     If we get a STATUS_STOP by a source we clear the corresponding
     queue.
  */
  if (statusInfo->getChange()) {
    int state=statusInfo->getStatus();
    if (state==_STATUS_STOPPED) {
      multiQueueFifo->clear(source);
    }
    if (multiQueueFifo->isEmpty()) {
      if (state == _STATUS_STOPPED) {
 	multiQueueFifo->enqueue(source,config);
	if ((multiQueueFifo->isStopped()) || (multiQueueFifo->isPaused())) {
	  // fifos stopped. we deliver a "the new status of the thread"
	  configArray->clear();
	  configArray->setDeviceConfigAt(0,config);
	  configArray->setEntries(1);
	  writeOut(configArray);
	  return;
	}
      } else {
	configArray->clear();
	configArray->setDeviceConfigAt(0,config);
	configArray->setEntries(1);
	writeOut(configArray);
	multiQueueFifo->enqueue(source,config);
	return;
      }
    }
  }
  multiQueueFifo->enqueue(source,config);
 

  if (multiQueueFifo->canSimultaneousDequeue()) {
    DeviceConfigArray* buf=multiQueueFifo->multiDequeue();
    writeOut(buf);
    multiQueueFifo->multiForward();
  }
}


void MultiInputDevice::writeOut(DeviceConfigArray* buf) {
  
}


