/* 
  abstract algorithms often used by these multimedia things 
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <accel/accelerator.h>


Accelerator::Accelerator() {
}


Accelerator::~Accelerator() {
}


void Accelerator::byteAdd(int* dest,char* src,int len) {
  int i;

  for(i=0;i<len;i++) {
    (*dest)+=(*src);
    dest++;
    src++;
  }
}


void Accelerator::byteDiv(char* ptr,int div,int len) {
  int i;

  for(i=0;i<len;i++) {
    (*ptr)/=div;
    ptr++;
  }
}


void Accelerator::byteDiv(int* ptr,int div,int len) {
  int i;

  for(i=0;i<len;i++) {
    (*ptr)/=div;
    ptr++;
  }
}


void Accelerator::byteMul(char* ptr,int mul,int len) {
  int i;

  for(i=0;i<len;i++) {
    (*ptr)*=mul;
    ptr++;
  }
}


void Accelerator::bytePercentMul(char* ptr,int percent,int len) {
  int calc;
  int i;

  for(i=0;i<len;i++) {
    calc=((int)(*ptr)*percent)/100;
    (*ptr)=(char)calc;
    ptr++;
  } 
}

void Accelerator::arrayCopy(char* dest,int* src,int len) {
  int i;

  for(i=0;i<len;i++) {
    (*dest)=(char)(*src);
    dest++;
    src++;
  } 
}
