/*
  encapsulates the configuration for a yafAmplifier
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include "amplifierConfig.h"


static char* mp3Decoder[]={"splay-yaf","-a",  NULL };
static char* mp3DecoderBad[]={ "splay-yaf","-a","-2","-m",  NULL };
static char* mp3DecoderDown[]={ "splay-yaf","-a","-2",  NULL };
static char* mp3DecoderMono[]={ "splay-yaf","-a","-m",  NULL };
static char* noDecoder[]={ NULL };
static char* wavDecoder[]={"tplay-yaf","-a", NULL};


AmplifierConfig::AmplifierConfig() {
}



AmplifierConfig::~AmplifierConfig() {
}


char** AmplifierConfig::getExecutable(int decoderTyp) {

  if (decoderTyp == _WAV_DECODER) {
    return wavDecoder;
  }
  if (decoderTyp == _MP3_DECODER) {
    return mp3Decoder;
  }
  if (decoderTyp == _MP3_DECODER_REALLY_BAD) {
    return mp3DecoderBad;
  }
  if (decoderTyp == _MP3_DECODER_DOWNSAMPLE) {
    return mp3DecoderDown;
  }  
  if (decoderTyp == _MP3_DECODER_MONOSAMPLE) {
    return mp3DecoderMono;
  } 
  return noDecoder;
}





