/*
  generic interactive controler 
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include <yafsplay/splay_control.h>
#include "../../../../../config.h"

                                          

void control_splay(InputInterface* input,OutputInterface* output,
		   InputDecoder* decoder) {


  debugOutput( cout<< "Command:0 Msg:protocol yaf-0.1" << endl );
  debugOutput( cout<< "Command:0 Msg:implements xplayer" << endl );
  debugOutput( cout<< "Command:0 Msg:decoder splay Version:0.8.2" << endl );
  debugOutput( cout<< "Command:0 Msg:comment splay by Woo-jae Jung" << endl );
  debugOutput( cout<< "Command:0 Msg:comment yaf port by mvogt@rhrk.uni-kl.de"<<endl );
  debugOutput( cout<< "Command:0 Msg:comment based on sources from eMusic and splay"<<endl );
  debugOutput( cout<< "Command:0 Msg:comment enter 'help' " << endl );
 

  
 
  
  yaf_control(input,output,decoder);
}


void usage() {
  debugOutput( cout << "splay-yaf is a interactive frontend for the splay decoder"<<endl );
  debugOutput( cout << "Usage : splay-yaf [-2am]"<<endl );
  debugOutput( cout << endl );
  debugOutput( cout << "-2 : playing with half frequency."<<endl );
  debugOutput( cout << "-m : force to mono."<<endl );
  debugOutput( cout << "-r : autoupdate musicinfo"<<endl ); 
  debugOutput( cout << "-a : no internal audio device"<<endl );
  debugOutput( cout << endl );
  debugOutput( cout << "THIS SOFTWARE COMES WITH ABSOLUTELY NO WARRANTY! " << "USE AT YOUR OWN RISK!"<<endl );
  debugOutput( cout << endl );
  debugOutput( cout << "for more help type 'help' in interactive mode"<<endl );
}




int main(int argc, char** argv) {
  int c;
  int lInternalAudio=true;

  //  float bug=pow(6.0,3.0);            // fixes bug in __math.h
  InputInterface input;
  OutputInterface output(&cout);


  StreamWriter_Construct(&output);

  struct player_plugin* plugin=splay_plugin();
  InputDecoderSPlay decoder(plugin);
  setInputInterface(&input);              // emusic to yaf gateway
  setPlugin(plugin);


  while(1) { 
    c = getopt (argc, argv, "2amh");
    if (c == -1) break;
    switch(c) {
    case 'a': {    
      lInternalAudio=false;
      break;
    }
    case 'h': {
      usage();
      exit(0);
    }
    case '2': {
      plugin->config("-2","true");
      break;
    }
    case 'm': {
      plugin->config("-m","true");
      break;
    }
    case 'r': {
      plugin->config("runtime","on");
      break;
    }
    default:
      printf ("?? getopt returned character code 0%o ??\n", c);
      usage();
      exit(-1);
    }
  }
  StreamWriter_internalDevice(lInternalAudio);
  plugin->construct();
  control_splay(&input,&output,&decoder);
  plugin->destruct();
  
  StreamWriter_Destruct();

}


