/*
  concrete Implementation of a decoder (for splay)
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */

//define DEBUG cout << "Command:1 Msg:"

#include <yafsplay/inputDecoderSPlay.h>
#include "../../../../../config.h"

  
extern int end_of_song;                   
extern int end_song;
extern int stop_song;
extern pthread_t player_thread;
extern pthread_mutex_t player_lock; 


InputDecoderSPlay::InputDecoderSPlay(player_plugin* plugin) 
  : InputDecoderXPlayer() {
  this->plugin=plugin;
  lFileSelected=false;
  songPath=new Buffer(256);
}


InputDecoderSPlay::~InputDecoderSPlay(){
  delete songPath;
}


/** 
    This method is entered by the global loop. (xplayer_control.c)
    This method should never (!) block or it
    is unpossible to read commands on stdin!


    Note: SPlay is not a threaded player this is why we need
    this doSomething method. Other player may already be threaded and
    offer a "control"/"working" channel. 
    These players won't need this loop.

*/

  
void InputDecoderSPlay::doSomething(){

}


char* InputDecoderSPlay::processCommand(int command,char* args){

  if (command == _PLAYER_OPEN) {
    if (strlen(args) == 0) {
      return "no file";
    }
    if (lFileSelected == true) {
      processCommand(_PLAYER_CLOSE,"");
    }

    if (getOn() == true) {
      processCommand(_PLAYER_OFF,"");
    }
            
    if (getOn() == false) {
      processCommand(_PLAYER_ON,"");
    }
    StreamWriter_setBytesCounter(0);
  

    lFileSelected=true;
    setMajorMode(_PLAYER_MAJOR_MODE_OPEN_TRACK);
    if (plugin->open(args) == false) {
      return processCommand(_PLAYER_OFF,"");
    }

    songPath->clear();
    songPath->append(args);
    return processCommand(_PLAYER_PLAY,"");
  }
  
  if (command == _PLAYER_CLOSE) {
    if (lFileSelected) {
      processCommand(_PLAYER_PAUSE,"");
      plugin->close();
      setMajorMode(_PLAYER_MAJOR_MODE_CLOSE_TRACK);
      lFileSelected=false;
    }
    return "";
  }
    
    
  if (command == _PLAYER_PLAY) {
    if (lFileSelected) {
      setMajorMode(_PLAYER_MAJOR_MODE_PLAYING);
      plugin->play();
      return "";
    }
    return "no file";
  }
  
  if (command == _PLAYER_PAUSE) {
    int mode=getMajorMode();
    if (mode == _PLAYER_MAJOR_MODE_PLAYING) {
      plugin->pause();
      setMajorMode(_PLAYER_MAJOR_MODE_PAUSE);
    }
    return ""; 
  }


  // another SPlay part:
  if (command == _PLAYER_JUMP) {
    if (lFileSelected) {
      char* back="";
      int nSec=0;
      int mode=getMajorMode();
      processCommand(_PLAYER_PAUSE,"");
      sscanf(args,"%d",&nSec);  // convert string to int
      // nPos is the time in seconds!!!!
      plugin->seek(nSec);
      StreamWriter_setBytesCounter(0);

      if (mode == _PLAYER_MAJOR_MODE_PLAYING) {
	processCommand(_PLAYER_PLAY,"");
      }
      return back;
    }
    return "no file";
  }
  if (command == _PLAYER_MUSICINFO) {
    if (lFileSelected) {
      strncpy(musicInfo.path,songPath->getData(),256);
      plugin->getMusicInfo(&musicInfo);
      debugOutput( cout << "Command:0 Msg:musicinfo-Start"<<endl );
      debugOutput( cout << "Command:0 Msg:song_filename "<<songPath->getData()<<endl );
      debugOutput( cout << "Command:0 Msg:song_name "<<musicInfo.name<<endl );
      debugOutput( cout << "Command:0 Msg:song_len  "<<musicInfo.length<<endl );
      debugOutput( cout << "Command:0 Msg:musicinfo-End"<<endl );
      return "";
    }
    return "no file";
  }

  if (command == _YAF_I_RUNTIME) {
    if (strcmp("off",args)==0) {
      plugin->config("runtime","off");
    } else {
      plugin->config("runtime","on");
    }
  } 

  return (InputDecoderXPlayer::processCommand(command,args));
}




