/*
  Copyright (C) 1999 Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package
*/

#include "jumpDevice.h"
#include "../config.h"

JumpDevice::JumpDevice( QWidget *parent=0, const char *name=0 )
  : QSlider(parent,name) {

  streamInfoDevice=NULL;
  receiveEvents = true;
  updateSlider  = true;

  setTickmarks(Below);
  setOrientation(Horizontal);
  setValue( 0 );
  setMinimumWidth(50);
  setMinimumHeight(10);
  connect(this,SIGNAL(sliderPressed()),this,SLOT(disableEvents()));
  connect(this,SIGNAL(sliderReleased()),this,SLOT(enableEvents()));
}

JumpDevice::~JumpDevice(){}


void JumpDevice::attachTo(AudioStreamInfoDevice* infoDevice) {
  if (streamInfoDevice!=NULL) {
    debugOutput( cout << "error: cannot connect to a connected JumpDevice"<< endl );
    exit(1);
  }
  streamInfoDevice=infoDevice;
  connect(streamInfoDevice->getEventQueue(),SIGNAL(processEvent(char)),
	  this,SLOT(processEvent(char)));
}

void JumpDevice::detach() {  
  disconnect(streamInfoDevice->getEventQueue(),NULL,this,NULL);
  streamInfoDevice=NULL;
}

void JumpDevice::processEvent(char eventId) {
  
  if (!receiveEvents) return;  /* user interact with the slider */

  switch (eventId) {
  case _AUDIOSTREAMINFO_TIME_CHANGE : {
    if (updateSlider) {
      int val=(int)((float)width()*
		    ((float)streamInfoDevice->getTimeInfo()->getTotalSec()/
		     (float)len));
      if (val != value()) {
	setValue(val);
      }
    }
    break;
  }    
  case _AUDIOSTREAMINFO_STATUS_CHANGE : {
    status=streamInfoDevice->getStatusInfo()->getStatus();
    break;
  }
  case _AUDIOSTREAMINFO_MUSIC_CHANGE : {
    len=streamInfoDevice->getMusicInfo()->getLen();
    break;
  }
  }

//    if ((status == _STATUS_PLAYING) && (len > 0)) 
//      updateSlider = true;
//    else 
//      updateSlider = false;
  if (status == _STATUS_STOPPED) {  setValue(0);  }
  if (len <= 0) {  setValue(0);  }
}
    

void JumpDevice::disableEvents() {
  if (updateSlider) 
    receiveEvents=false;
}

void JumpDevice::enableEvents() {
  if (updateSlider) 
      emit(jump((int)((float)value()/(float)width()*(float)len)));
  receiveEvents=true;
}

void JumpDevice::resizeEvent(QResizeEvent *){
  setRange(0,width());
}




