/*
  Copyright (C) 1999 Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package
*/

#ifndef CONFIGURATION_H
#define CONFIGURATION_H

#include <kapp.h>
#include <kconfig.h>
#include <qdialog.h>
#include <qtabdialog.h>
#include <qlabel.h>
#include <qpixmap.h>
#include <qstring.h>
#include <qgroupbox.h>
#include <qobject.h>
#include <iostream.h>
#include "configFile.h"
#include "configAbout.h"
#include "configPlayer.h"
#include "configGui.h"
#include "configGeneral.h"


class ConfigFile;
class ConfigAbout;
class ConfigPlayer;
class ConfigGui;
class ConfigGeneral;

class Configuration : public QObject{
    Q_OBJECT
 public:
  Configuration();
  ~Configuration();
  void toggleVisible();
 private:  
  KConfig       *config;
  QTabDialog    *tabdialog;
  ConfigFile    *import; 
  ConfigAbout   *about;  
  ConfigPlayer  *player; 
  ConfigGui     *gui;
  ConfigGeneral *general;
  QString version;    

 public slots:
  void acceptConfig();
  void cancelConfig();    

 signals:
  void audioDeviceChanged();
  void configurationChanged();
};

#endif // CONFIGURATION_H
