/*
  Copyright (C) 1999 Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package
*/

#ifndef CONFIGENERAL_H
#define CONFIGENERAL_H

#include <kapp.h>
#include <kconfig.h>
#include <qwidget.h>
#include <qgroupbox.h>
#include <qcheckbox.h>
#include <qframe.h>
#include <qcombobox.h>
#include <klined.h>
#include <kconfig.h>
#include <qlabel.h>
#include "configfolder.h"
#include "kjukebox.h"

class ConfigGeneral : public QWidget{
  Q_OBJECT
 private:
  KConfig   *config;
  QGroupBox *boxPrio;

  QCheckBox *setPrioBox;
  QComboBox *prioLevelBox;
  QLabel    *prioLevelLabel;
  int minPrio;
  int maxPrio;

  QGroupBox *boxMP3;
  QCheckBox *loadWithoutTagBox;
  QLabel    *defaultArtistLabel;
  QLineEdit *defaultArtist;
  QLabel    *defaultAlbumLabel;
  QLineEdit *defaultAlbum;
  QCheckBox *upcaseFirstLettersBox;

  QGroupBox *boxLog;
  QCheckBox *enableLogBox;
  QLabel    *logFileLabel;
  QLineEdit *logFileEdit;
  QPushButton *logFileBrowse;

  QGroupBox *boxRepeat;
  QCheckBox *enableRepeat;

 protected:
  void resizeEvent(QResizeEvent *);
 public:
  ConfigGeneral( QWidget *parent=0,  const char *name=0 );
  ~ConfigGeneral();
  
 public slots:
  void cancel();
  void accept();

 private slots:
  void openBrowser();
 
};

#endif
