/*
  Copyright (C) 1999 Rainer Maximini

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package
*/

#include "appwindow.h"

#include <qkeycode.h>
#include <qlabel.h>
#include <kapp.h>
#include <kurl.h>
#include <qfile.h>
#include <kmsgbox.h>
#include <iostream.h>
#include <fstream.h>


void ApplicationWindow::neu(){
  int i;
  if (dataBase->isModified()){
    i = KMsgBox::yesNo(this, i18n("Warning"),i18n("The MP3 Database is not saved!\nDo you realy want to go on?"));
    if(i==2) {
      status->message( i18n("Deleting of the MP3 Database canceled"));
      return;
    }
  }
  dataBase->clear();
  dataBase->modifikationSaved();
  dateiName = "";
  setTitle();
}

void ApplicationWindow::laden(){
  int i;
  if (dataBase->isModified()){
    i = KMsgBox::yesNo(this, i18n("Warning"), i18n("The MP3 Database should be erased!\nDo you really want to go on?"));
    if(i==2) {
      status->message( i18n("Loading of MP3 List aborted"));
      return;
    }
  }
  
  dataBase->clear(false);
  dateiName = KFileDialog::getOpenFileName(fileDialogPath,"*.jbd *.JBD",this);
  if ( !dateiName.isEmpty() ) {
    KURL url(dateiName);
    fileDialogPath = url.directory(true);
    debugOutput(cout << "FDP:" << fileDialogPath << endl);
    laden( dateiName );
  }
  else 
    status->message( i18n("Loading of MP3 File aborted"));
  dataBase->modifikationSaved();
}

void ApplicationWindow::laden( const char *datei ){
  QString s;
  QString file;
  dateiName = datei;
  KURL url(dateiName);
  file = url.path();
  if (file != url.directory()){
    ifstream file( dateiName, ios::in );
    if ( file )  { 
      file.close();
      addRecentFile(dateiName);
      dataBase->insert(ioaccess.load(dateiName));
      s.sprintf(i18n("File %s loaded."), dateiName.data());

      status->message( s );
      setTitle();
      return;
    }
    file.close();
  }
  s.sprintf(i18n("Error while Loading the file %s !!!"), dateiName.data());
  status->message( s );
  setTitle();
}

void ApplicationWindow::openRecentFile(int id){
  int i;
  if (dataBase->isModified()){
    i = KMsgBox::yesNo(this, i18n("Warning"), i18n("The MP3 Database should be erased!\nDo you realy wan't to go on?"));
    if(i==2) {
      status->message( i18n("Loading of MP3 List aborted"));
      return;
    }
  }  
  dataBase->clear(false);    
  config->setGroup(KCONFIG_OPEN_RECENT_FILE);
  switch(id){
  case 1: laden(config->readEntry(KCONFIG_OPEN_RECENT_FILE_1)); break;
  case 2: laden(config->readEntry(KCONFIG_OPEN_RECENT_FILE_2)); break;
  case 3: laden(config->readEntry(KCONFIG_OPEN_RECENT_FILE_3)); break;
  case 4: laden(config->readEntry(KCONFIG_OPEN_RECENT_FILE_4)); break;
  }
  dataBase->modifikationSaved();
}

void ApplicationWindow::addRecentFile(QString file){
  config->setGroup(KCONFIG_OPEN_RECENT_FILE);
  if(strcmp(file, config->readEntry(KCONFIG_OPEN_RECENT_FILE_1))==0) return;
  if(strcmp(file, config->readEntry(KCONFIG_OPEN_RECENT_FILE_2))==0) return;
  if(strcmp(file, config->readEntry(KCONFIG_OPEN_RECENT_FILE_3))==0) return;
  if(strcmp(file, config->readEntry(KCONFIG_OPEN_RECENT_FILE_4))==0) return;
  config->writeEntry(KCONFIG_OPEN_RECENT_FILE_4,
		     config->readEntry(KCONFIG_OPEN_RECENT_FILE_3));
  config->writeEntry(KCONFIG_OPEN_RECENT_FILE_3,
		     config->readEntry(KCONFIG_OPEN_RECENT_FILE_2));
  config->writeEntry(KCONFIG_OPEN_RECENT_FILE_2,
		     config->readEntry(KCONFIG_OPEN_RECENT_FILE_1));
  config->writeEntry(KCONFIG_OPEN_RECENT_FILE_1,file);
  config->sync();
  refreshOpenRecentFileDialog();
}

void ApplicationWindow::speichern(){
  if(dateiName.isEmpty()) speichernAls();
  else speichern(dateiName);
}

void ApplicationWindow::speichern(QString datei){
  QString s;

  ofstream file(datei,ios::out|ios::trunc);
  if (file) {
    if (ioaccess.save(datei,dataBase->getSongList())){
      s.sprintf(i18n("File %s saved."), datei.data());  
      dataBase->modifikationSaved();
    }
  }
  else 
    s.sprintf(i18n("Error at writing the file %s !!!"), datei.data() );

  file.close();  
  status->message( s );  
}


void ApplicationWindow::speichernAls(){
  dateiName = KFileDialog::getSaveFileName(fileDialogPath,"*.jbd *.JBD",this);
  if ( !dateiName.isEmpty() ){
    KURL url(dateiName);
    fileDialogPath = url.directory(true);
    unsigned int index = dateiName.findRev(".jbd",-1,false);
    if (index != (dateiName.length()-4)) {
      dateiName.append(".jbd");
    }
    speichern( dateiName );
    addRecentFile(dateiName);
  }
  else
    status->message( i18n("Writing of MP3 List aborted!"));
  setTitle();
}

void ApplicationWindow::importMP3Datei(){
  QString file;

  QString dateiName = KFileDialog::getOpenFileName(fileDialogPath,"*.MP3 *.mp3",this);
  if ( !dateiName.isEmpty() ){
    KURL url(dateiName);
    fileDialogPath = url.directory(true);
    file = url.path();
    if (file.findRev ( ".mp3", -1, false )!= -1)
      dataBase->insert(ioaccess.importMP3File( file ));
    else 
      if (file == url.directory())
	dataBase->insert(ioaccess.importDirectory(file));
  }
  else
    status->message( i18n("Loading of MP3 List aborted!"));
}

void ApplicationWindow::importMP3Liste(){
  QString dateiName = KFileDialog::getOpenFileName(fileDialogPath,"*",this);
  if ( !dateiName.isEmpty() ){
    KURL url(dateiName);
    fileDialogPath = url.directory(true);
    dataBase->insert(ioaccess.importMP3FileList( dateiName ));
  }
  else
    status->message( i18n("Loading of MP3 List aborted!") );
}

void ApplicationWindow::importM3uListe(){  
  QString dateiName = KFileDialog::getOpenFileName(fileDialogPath,"*.m3u *.m3u",this);
  if ( !dateiName.isEmpty() ){
    KURL url(dateiName);
    fileDialogPath = url.directory(true);
    dataBase->insert(ioaccess.importM3uFileList( dateiName ));
  }
  else
    status->message( i18n("Loading of MP3 List aborted!") );
}

void ApplicationWindow::exportMP3Liste(){
  QString dateiName = KFileDialog::getOpenFileName(fileDialogPath,"*",this);
  if ( !dateiName.isEmpty() ){
    KURL url(dateiName);
    fileDialogPath = url.directory(true);
    if(ioaccess.exportMP3List(dateiName, dataBase->getSongList())){
      status->message( "MP3-Liste gespeichert" );
      return;
    }
  }
  status->message( i18n("Saving of MP3 List aborted!") );
}

void ApplicationWindow::exportM3uListe(){
  QString dateiName = KFileDialog::getOpenFileName(fileDialogPath,"*.M3u *.m3u",this);
  if ( !dateiName.isEmpty() ){
    KURL url(dateiName);
    unsigned int index = dateiName.findRev(".m3u",-1,false);
    if (index != (dateiName.length()-4)) {
      dateiName.append(".m3u");
    }
    fileDialogPath = url.directory(true);
    if(ioaccess.exportM3uList(dateiName, dataBase->getSongList())){
      status->message( i18n("MP3 List saved") );
      return;
    } 
  }
  status->message( i18n("Saving of M3u List aborted!") );
}


void ApplicationWindow::print(){
  printer->print(dataBase->getSongList());
}

void ApplicationWindow::printerSettings(){
  printer->openSettings(dataBase->getSongList());
}

void ApplicationWindow::printerPreview(){
  printer->openPreview(dataBase->getSongList());
}

void ApplicationWindow::quitKJukeBox(){
  int i;

  config->setGroup(KCONFIG_FILE);
  config->writeEntry(KCONFIG_FILE_LASTDIRECTORY, fileDialogPath );

  if (dataBase->isModified()){
    i = KMsgBox::yesNoCancel(this, i18n("Warning"),i18n("The MP3 List has been modified!\nWould you like to save it?"));
    if(i==1) speichern();
  }

  config->sync();  

  cout << "delete song logger" << endl;
  delete songLogger;

  (KApplication::getKApplication())->quit();
}

/*
  Ab hier kommen nur noch Funktionen fuer die Player
*/

void ApplicationWindow::createPlayer(int player) {
  int quality = config->readNumEntry(KCONFIG_PLAYER_QUALITY, _MP3_DECODER);

  decoder[player]         = Amplifier::createPlayer(quality);
  volumeDevice[player]    = new VolumeDevice();
  multicastDevice[player] = new MulticastDevice();
  streamTimeInfoDevice[player]    = new AudioStreamInfoDevice();
  streamAlarmInfoDevice[player]   = new AudioStreamInfoDevice();
  alarmtimer[player]      = new AlarmTimer(this,"alarmtimer");
  fadeDevice[player]      = new FadeDevice();

  // the fadeDevice is build in initSoundToolbar(..);

  //      GenericPlayer
  //          |                       No Building this Graph
  //          V 
  //     MulticastDevice
  //      |  |  |  |
  //      |  |  |  `--> Mixer Device
  //      |  |  | 
  //      |  |  `--> StreamTimeInfoDevice                      
  //      |  |                          |
  //      |  |                          `--> Alarm Timer      
  //      |   `--> StreamAlarmInfoDevice                        
  //      |                      |                         
  //       `--> Volume Device    |                          
  //                       |     |                             
  //                       V     V 
  //                      FadeDevice                       


  multicastDevice[player]->addListener(volumeDevice[player]);
  multicastDevice[player]->addListener(streamTimeInfoDevice[player]);
  multicastDevice[player]->addListener(streamAlarmInfoDevice[player]);
  multicastDevice[player]->addListener(mixerDevice);

  fadeDevice[player]->attachTo(streamAlarmInfoDevice[player]);
  fadeDevice[player]->attachTo(volumeDevice[player]);
  
  decoder[player]->addListener(multicastDevice[player]);


  decoder[player]->setPlayOnOpen(false);
  if (player == PLAYER1){
    connect(decoder[player]->getEventQueue(), SIGNAL(processEvent(char)),
	    this,SLOT(decoder1Event(char)));  
    connect(fadeDevice[player], SIGNAL(fadeOutReady()), 
	    this, SLOT(fadeOut1Ready())); 
  }  
  else{
    connect(decoder[player]->getEventQueue(), SIGNAL(processEvent(char)),
	    this,SLOT(decoder2Event(char)));  
    connect(fadeDevice[player], SIGNAL(fadeOutReady()), 
	    this, SLOT(fadeOut2Ready())); 
  }  
 
  streamTimeInfoDevice[player]   ->setEventMask(_AUDIOSTREAMINFO_TIME_CHANGE   |
						_AUDIOSTREAMINFO_STATUS_CHANGE |
						_AUDIOSTREAMINFO_MUSIC_CHANGE ); 
  streamAlarmInfoDevice[player]  ->setEventMask(_AUDIOSTREAMINFO_STATUS_CHANGE |
 						_AUDIOSTREAMINFO_MUSIC_CHANGE );  

  alarmtimer[player]->attachTo(streamTimeInfoDevice[player]);
}


void ApplicationWindow::initializePlayer(){
  decoder                 = new (GenericPlayer*)[2];
  streamTimeInfoDevice    = new (AudioStreamInfoDevice*)[2];
  streamAlarmInfoDevice   = new (AudioStreamInfoDevice*)[2];
  volumeDevice            = new (VolumeDevice*)[2];
  multicastDevice         = new (MulticastDevice*)[2];
  alarmtimer              = new (AlarmTimer*)[2];
  fadeDevice              = new (FadeDevice*)[2];
  currentSong             = new (Song)[2];
  jumpDevice              = new (JumpDevice*)[2];

  pausing = new bool[2];
  pausing[PLAYER1] = false;
  pausing[PLAYER2] = false;
  playing = new bool[2];
  playing[PLAYER1] = false;
  playing[PLAYER2] = false;
  
  mixerDevice = new MixerDevice();
  audioDevice = 0;
  setAudioDevice();

  GarbageCollector::init();

  createPlayer(PLAYER1);
  connect(alarmtimer[PLAYER1], SIGNAL(alarm()), this, SLOT(timer1Alarm()));
  createPlayer(PLAYER2);
  connect(alarmtimer[PLAYER2], SIGNAL(alarm()), this, SLOT(timer2Alarm()));
}


void ApplicationWindow::setAudioDevice(){
  if(audioDevice != 0) {
    debugOutput( cout << "Deleting old audio device." << endl );
    playerStop(PLAYER1);
    playerStop(PLAYER2);
    mixerDevice->removeListener(audioDevice);
    delete audioDevice;
  }

  
  config->setGroup(KCONFIG_PLAYER);
  QString device = config->readEntry(KCONFIG_PLAYER_DEVICE, DEFAULT_AUDIO_DEVICE);
  
  audioDevice = new AudioDevice(device.data());
  mixerDevice->addListener(audioDevice);
  
  if (audioDevice->open(device.data()) == false) {
    QString error;
    error.sprintf("Cannot open %s \nNo sound possible!",device.data());
    KMsgBox::message(0,"KJukeBox AudioDevice", error.data());
    
  }
}


void ApplicationWindow::playSong(int player, Song *song){
  QString text;
  unsigned int firstSeconds;
  unsigned int lastSeconds;

  if(song == 0) {
    debugOutput( cout << "Song is a null pointer" << endl);
    return;
  }

  if ((playing[player])&&(!(pausing[player]))) {
    debugOutput( cout << "Player " << player << " is playing" << endl );
    return;
  }

  if(pausing[player]) {  
    playerPause(player);   
    return;  
  }

  config->setGroup(KCONFIG_PLAYER);

  /* Setup the Timer to start the next Song */  
  lastSeconds  = config->readUnsignedNumEntry(KCONFIG_PLAYER_LASTSECONDS,7);
  firstSeconds = config->readUnsignedNumEntry(KCONFIG_PLAYER_FIRSTSECONDS,0);
  if (!config->readBoolEntry(KCONFIG_PLAYER_DEFAULTTIME,true)){ 
    // if not alway use default settings
    if(song->getLastSeconds()  != 0) lastSeconds  = song->getLastSeconds();
    if(song->getFirstSeconds() != 0) firstSeconds = song->getFirstSeconds();
  }
    
  if((config->readBoolEntry(KCONFIG_PLAYER_MIXING,true))&& (lastSeconds != 0)){ 
    alarmtimer[player]->setAlarmTime(song->getSeconds() - lastSeconds);
  }
  else { 
    alarmtimer[player]->clearAlarmTime();
  }

  /* Now start playing the song */
  //  cout << "PlayingFile:" << song->getFilename() << endl;
  QString message = i18n("Playing ");
  message += song->getFilename();
  status->message( message );
  currentSong[player] = *song;
  songLogger->appendSong(song);
  decoder[player]->open(song->getFilename()); 
  if((config->readBoolEntry(KCONFIG_PLAYER_MIXING,true))&&(firstSeconds != 0))
    decoder[player]->jump(firstSeconds);

  //debugOutput( cout << "Start player with song: " << song->getFilename() << endl );
  decoder[player]->play();

  /* Setup internal Variables */
  pausing[player] = false;
  playing[player] = true;

  /* Start the fade device */
  //  fadeDevice[player]->songStartToPlay();


  (playingSongName[player]).sprintf("(%s) %s",
				    song->getArtist().data(),
				    song->getTitle().data());
  text.sprintf(i18n("Playing %s"), song->getFilename().data());
  status->message( text );    
  refreshSoundToolBar(player);
}


void ApplicationWindow::playNextSong1(){  playNextSong(PLAYER1); }
void ApplicationWindow::playNextSong2(){  playNextSong(PLAYER2); }
void ApplicationWindow::playNextSong(int player){
  QSongList songs;
  Song     *song = 0;
  Song      songToPlay;

  if (playing[player]) return;

  if(shufflePlaying)    
    songToPlay = mainWidget->getRandomSongToPlay();
  else     
    songToPlay = mainWidget->getFirstSongToPlay();

  if (songToPlay.isNull()) { /* no song to play */
    status->message(i18n("All Files are played!!!"),2000);
    refreshSoundToolBar(player);
    return;
  }

  song = dataBase->findInPlayList(songToPlay);
  if(song == 0){
    song = (dataBase->find(songToPlay)).first();
  }

  if(song == 0){
    debugOutput( cout << "error: can not find the next song, stop playing" << endl);
    return;
  }

  playSong(player, song);
}

void ApplicationWindow::playSelectedSong(){
  Song *song;
  song = mainWidget->getSelectedSongRef();
  playSelectedSong(song);
}

void ApplicationWindow::playSelectedSong(Song *song){
  if(song == 0) {
    debugOutput( cout << "Song is a null pointer" << endl );
    return;
  }
  if (song != 0){
    if( !(playing[PLAYER1] || pausing[PLAYER1]) )
      playSong(PLAYER1, song);
    else if( !(playing[PLAYER2] || pausing[PLAYER2]) )
      playSong(PLAYER2, song);
    else {
      playerStop(PLAYER1);
      //      fadeDevice[PLAYER1]->stopFading();
      playSong(PLAYER1, song);
    } 
  }
}

void ApplicationWindow::player1Pause(){ playerPause(PLAYER1); }
void ApplicationWindow::player2Pause(){ playerPause(PLAYER2); }
void ApplicationWindow::playerPause(int player){
  if (!playing[player]) return;
  if (pausing[player]) {
    pausing[player] = false;
    playing[player] = true;
  }
  else {
    if (!playing[player])  playNextSong(player);
    pausing[player] = true;
  }
  decoder[player]->pause();
  refreshSoundToolBar(player);
}

void ApplicationWindow::player1Stop(){ playerStop(PLAYER1); }
void ApplicationWindow::player2Stop(){ playerStop(PLAYER2); }
void ApplicationWindow::playerStop(int player){
  Song tmp;
  decoder[player]->close();
  pausing[player] = false;
  playing[player] = false;
  currentSong[player] = tmp;
  refreshSoundToolBar(player);
}
 
void ApplicationWindow::playNext(int player){
  playing[player] = false;
  pausing[player] = false;
  playNextSong(player);
}


void ApplicationWindow::fadeOut1Ready(){ 
    playerStop(PLAYER1);
    if (!(playing[PLAYER2])) 
      playNextSong(PLAYER2);    
}
void ApplicationWindow::fadeOut2Ready(){ 
    playerStop(PLAYER2);
    if (!(playing[PLAYER1])) 
      playNextSong(PLAYER1);    
}

void ApplicationWindow::jumpOnPlayer1(int seconds){  jump(PLAYER1,seconds);}
void ApplicationWindow::jumpOnPlayer2(int seconds){  jump(PLAYER2,seconds); }
void ApplicationWindow::jump(int player,int seconds){
  decoder[player]->jump(seconds);    
}

void ApplicationWindow::decoder1Event(char event){ decoderEvent(PLAYER1,event); }
void ApplicationWindow::decoder2Event(char event){ decoderEvent(PLAYER2,event); }
void ApplicationWindow::decoderEvent(int player,char event){
  if (event == _GS_SIGNAL_PLAYING_READY) decoderStopedPlaying(player);
}  

void ApplicationWindow::decoderStopedPlaying(int player){
  playing[player] = false;
  pausing[player] = false;
  debugOutput( cout << "Player " << player << " ready, start next song " << endl);
  if (player == PLAYER1){
    if (!playing[PLAYER2]) playNext(PLAYER2);
  }
  else {
    if (!playing[PLAYER1]) playNext(PLAYER1);
  }
  refreshSoundToolBar(player);
}

void ApplicationWindow::decoderCrashed(int player){
  QString text;
  
  config->setGroup(KCONFIG_GUI);
  int pc = config->readNumEntry(KCONFIG_GUI_DECODER_CRASHED,AUTO_REPAIR_WITH_WARNING);

  restartDecoder(player);
  if(playing[player]){
    playing[player] = false;
    playNextSong(player);
  }

  if (pc == AUTO_REPAIR_WITH_WARNING){
    text.sprintf("Player %d is crashed and restartet!", player );
    status->message( text );
    KMsgBox::message(this,i18n("Player Crashed!!!"),text);
  }
}

void ApplicationWindow::restartDecoder(int player){
  debugOutput( cout << "restart decoder" << endl );
  decoder[player]->removeListener(multicastDevice[player]);
  disconnect(decoder[player]->getEventQueue(), NULL, this, NULL);  

  debugOutput( cout << "disconnected and listener removed" << endl );
  delete (decoder[player]);
  debugOutput( cout << "decoder removed" << endl );
  decoder[player] = Amplifier::createPlayer(_MP3_DECODER);
  debugOutput( cout << "new one startet" << endl );
  decoder[player]->addListener(multicastDevice[player]);
  debugOutput( cout << "decoder connected into the stream graph" << endl );
  decoder[player]->setPlayOnOpen(false);
  connect(decoder[player]->getEventQueue(), SIGNAL(processEvent(char)),
          this,SLOT(processEvent(char)));  
}


void ApplicationWindow::timer1Alarm(){  timerAlarm(PLAYER1); }
void ApplicationWindow::timer2Alarm(){  timerAlarm(PLAYER2); }
void ApplicationWindow::timerAlarm(int player){
  QString text;

  fadeDevice[player]->fadeOutSoftly();
  if (player == PLAYER1){
    if (!playing[PLAYER2]) playNext(PLAYER2);
  }
  else {
    if (!playing[PLAYER1]) playNext(PLAYER1);
  }
  refreshSoundToolBar(player);
}


bool ApplicationWindow::eventFilter(QObject* object,QEvent *e) {
  if ( e->type() == __YAFGLOBALEVENT_ID) {    // yaf global event
    YafGlobalEvent* yafEvent = (YafGlobalEvent*)e;
    if(yafEvent->getMsg() == _GS_SIGNAL_GENERATOR_CRASHED){
      debugOutput( cout << "got generator crash*******"<<endl );
      if(!decoder[PLAYER1]->isRunning()) 
	decoderCrashed(PLAYER1);
      else
	decoderCrashed(PLAYER2);
      return TRUE;                        // eat event
    }    
  }
  return FALSE;    
} 

