// KreateCD - CD recording software for the K desktop environment
//
// 2000 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General
// Public License.  See the file COPYING in the main directory of the
// KreateCD distribution for more details.

#include "CDParanoia.h"
#include "DeviceRipper.h"
#include "TOCCdrecord.h"
#include "TOCCdda2wav.h"
#include "AppChooser.h"

AudioRipper *AppChooser::getAudioRipper(void)
 {
   AudioRipper *audio=new CDParanoia();
   return(audio);
 }

DataRipper *AppChooser::getDataRipper(void)
 {
   DataRipper *data=new DeviceRipper();
   return(data);
 }

TOCReader *AppChooser::getTOCReader(void)
 {
   TOCReader *toc=new TOCCdda2wav();
   return(toc);
 }

TOCReader *AppChooser::readTOC(void)
 {
  TOCReader *toc=getTOCReader();
  if (toc==0) return(0);
  if (toc->readTOC()!=0) return(toc);
  delete toc;
  toc=new TOCCdrecord();
  if (toc->readTOC()!=0) return(toc);
  delete toc;
  return 0;
 }
