// KreateCD - CD recording software for the K desktop environment
//
// 1999 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

#include "ProgressDialog.h"
#include "DriveAccess.h"

#include <kapp.h>
#include <klocale.h>
#include <kconfig.h>
#include <kprogress.h>
#include <keditcl.h>

#include <qpushbutton.h>
#include <qwindowdefs.h>
#include <qlayout.h>
#include <qlabel.h>



#include <strings.h>
#include <stdio.h>
#include <stdlib.h>


extern KLocale *locale;

ProgressDialog::ProgressDialog( QWidget *parent, const char *name,const char *prefworktext,bool modal):QDialog(parent,name,modal)
 {
  KConfig *config;
  QRect DefaultRect(100,100,400,200);

  oldval=-1;
  oldmax=-1;
  this->setCaption(locale->translate("KreateCD is working ..."));
  pvlayout=new QVBoxLayout(this);

  config=kapp->getConfig();

  pwork=new QLabel(this,"prograss label");
  pwork->setAlignment(AlignCenter);
  pwork->setMinimumSize(300,80);


  pwidget=new KProgress(KProgress::Horizontal,this,"progress dialog");
  pwidget->setMinimumSize(pwidget->sizeHint());

  pcancel=new QPushButton(locale->translate("Abort"),this,"progress cancel");
  pcancel->setFixedSize(pcancel->sizeHint());

  setWorkText(prefworktext);

  pvlayout->addWidget(pwork,10);
  pvlayout->addStretch(1);
  pvlayout->addWidget(pwidget,1);
  pvlayout->addStretch(1);
  pvlayout->addWidget(pcancel);
  pvlayout->activate(); 

  connect(pcancel,SIGNAL(clicked()),this,SLOT(cancelPressed()));

  config->setGroup("Geometry");
  this->setGeometry(config->readRectEntry("ProgressDialogGeo",&DefaultRect)); 
  edit=0;
 }

ProgressDialog::~ProgressDialog(void)
 {
  KConfig *config;
  QRect SaveRect(this->pos(),this->size());
  config=kapp->getConfig();
  config->setGroup("Geometry");
  config->writeEntry("ProgressDialogGeo",SaveRect); 
 }

void ProgressDialog::printStatusLine(QString line)
 {
  if (edit==0) return;
  edit->insertLine(line);
  edit->setCursorPosition(edit->numLines(),0,false);
 }

void ProgressDialog::addStatusView(void)
 {
  QSize vsiz(100,50);
  if (edit!=0) return;
  edit=new KEdit(kapp,this);
  edit->setReadOnly(true);
  vsiz.setHeight(edit->font().pointSize()*10);
  edit->setMinimumSize(vsiz);
  pvlayout->addStretch(1);
  pvlayout->addWidget(edit,60);
 }

void ProgressDialog::cancelPressed(void)
 {
  emit canceled();
 }

void ProgressDialog::setWorkText(const char *newworktext)
 {
  if (newworktext)
   {
    strcpy(worktext,newworktext);
   }
   else
   {
    worktext[0]=0;
   }
  strcpy(progresstext,locale->translate("KreateCD is working ..."));
  if (worktext[0])
   {
    strcat(progresstext,"\n\n");
    strcat(progresstext,worktext); 
   }
  pwork->setText(progresstext);


 }

void ProgressDialog::setProgress(long int val,long int maxval)
 {
  if (val!=oldval)
   {
    pwidget->setValue(val);
    oldval=val;
   }
  if (maxval!=oldmax)
   {
    pwidget->setRange(0,maxval);
    oldmax=maxval;
   }
 } 

void ProgressDialog::setProtectedProgress(long int val,long int maxval)
 {
  int c1=0,c2=0;
  int p1,p2;

  p1=oldval*100/oldmax;
  if (val>oldval)
   {
    c1=1;
    oldval=val;
   }
  if (maxval>oldmax)
   {
    c2=1;
    oldmax=maxval;
   }
  p2=oldval*100/oldmax;
  if (p2==p1) return;
  if (c1) pwidget->setValue(val);
  if (c2) pwidget->setRange(0,maxval);
 } 


void ProgressDialog::abortDialog(int returncode)
 {
  done(returncode);
 }


void ProgressDialog::abortCancel(void)
 {
  done(-1);
 }
