// KreateCD - CD recording software for the K desktop environment
//
// 1999 by Alexander Feigl <Alexander.Feigl@gmx.de>
//
// This file is subject to the terms and conditions of the GNU General      
// Public License.  See the file COPYING in the main directory of the       
// KreateCD distribution for more details.                                     

class AudioFile;
class KConfig;

class CDTrack
 {
  public:

    enum TrackType   {Track_Audio,Track_AudioPreEmph,Track_DataMode1,Track_DataMode2,Track_XA1,Track_XA2,Track_CDI};
    enum TrackSource {Source_None,Source_CD,Source_File,Source_Filesystem};
    enum TrackImage  {Image_None,Image_Dirty,Image_Clean};

    CDTrack(void);                     
    CDTrack(KConfig *config);           // load track function

    void saveTrack(KConfig *config);    // save track function


    ~CDTrack(void);

    // track information
    enum TrackType    getTrackType(void);
    enum TrackSource  getTrackSource(void);
    enum TrackImage   getTrackImageMode(void);
    int               getUseImage(void);
    void              getTrackDescription(char *desc);
    void              getTrackDurationHMSB(char *duration);     
    void              getTrackTypeText(char *type);
    int               isAudio(void);
    class AudioFile * getAudioFile(void);
    class ISOImage  * getISOImage(void);
    long int          getRealDuration(void);

    int               getBurnFile(char *burnfile);


    // general information
    static void           getTypeString(enum TrackType,char *type);
    static void           getDurationHMSB(char *duration,long int duration);
    static enum TrackType getTOCType(int control,int mode);

    // track manipulating 
    void setDescription(const char *descr);
    void setTrackType(enum TrackType);
    void clearSource(void);
    void setSourceTrack(int track,long int tocsum,unsigned long duration,unsigned long lbastart);
    void setSourceFile(const char *filename);
    void setSourceFileSystem(class ISOImage *image=0);
    void enableImage(void);
    void disableImage(void);
    void clearImage(void);                        // deletes an existing image file from disk


    // update function
    void updateTrack(void);
    int  validateTrack(void);

    int  needImage(void);

  protected:
    void updateDuration(const char *fn);


  private:
    void createName(char *fn,int type,long int duration);


    TrackType     TrackType;
    TrackSource   TrackSource;
    TrackImage    TrackImage;
    int           NeedImage;
    int           IsTemporary;

    int           CDTrackNum;                     // CD image : track
    long int      CDTocSum;                       // CD image : TOC sum of this CD


    char          Description[40];
    char          SourceFile[2048];
    char          ImageFile[512];
    unsigned long TrackSize;
    unsigned long TrackDuration;                  // Format : in 1/75 sec blocks
    unsigned long TrackLBA;                       // LBA of Source track

    AudioFile      *ThisAudio;
    class ISOImage *ThisISO;
 };


