/***************************************************************************
                          setup.cpp  -  description
                             -------------------
    begin                : Sun Jan 9 2000
    copyright            : (C) 2000 by Kai Heitkamp
    email                : koncd@kai-heitkamp.de
 ***************************************************************************/

#include <kconfig.h>

#include "setup.h"
#include "koncd.h"
#include "cddata.h"

Setup::Setup(QWidget *parent, const char *name) : QDialog(parent,name,true){
	setCaption( i18n("KOnCD - Setup") );
	initDialog();
	setupConnections();

// Read the CD-Devices and added them to the ComboBoxes
	const char* arr[4];
	char buf[256];
	CDdata *CD = new CDdata;

	QComboBox_cdwriterdev->clear();

	for( int i = 0; ! CD -> getDev( i, &arr ); i++ ) {
		sprintf( buf, "%s %s", arr[0],arr[1] );
		QComboBox_cdwriterdev -> insertItem( buf, i );
	}

	QComboBox_cdreaderdev->clear();

	for( int i = 0; ! CD -> getDev( i, &arr ); i++ ) {
		sprintf( buf, "%s %s", arr[0],arr[1] );
		QComboBox_cdreaderdev -> insertItem( buf, i );
	}

	QComboBox_cdreaderdev -> insertItem( "ATAPI CD-ROM" );

}

Setup::~Setup(){
}

// Setup Connections
void Setup::setupConnections(){
	connect( QPushButton_ok, SIGNAL(clicked()), SLOT(slotQuitandSave()) );
	connect( QPushButton_exit, SIGNAL(clicked()), SLOT(slotQuit()) );
}

// 'OKandSave-Button' clicked
void Setup::slotQuitandSave(){
	KConfig *config = kapp->getConfig();
	CDdata *CD = new CDdata;

	//Save settings for CD-Writer
	config->setGroup("CD-Writer");
	config->writeEntry("Name", QComboBox_cdwriterdev->currentText());
	config->writeEntry("Device", CD->getDevStr( QComboBox_cdwriterdev->currentItem() ));
	config->writeEntry("isRW", CD->isRW( QComboBox_cdwriterdev->currentItem() ));

	//Save settings for CD-Reader
	config->setGroup("CD-Reader");
	config->writeEntry("Name", QComboBox_cdreaderdev->currentText());
	config->writeEntry("Device", CD->getDevStr( QComboBox_cdreaderdev->currentItem() ));

	if ( config->readEntry("Device") == "dev=0,0,0" ) config->writeEntry("Device", "/dev/scd0");
	if ( config->readEntry("Device") == "dev=0,1,0" ) config->writeEntry("Device", "/dev/scd1");
	if ( config->readEntry("Device") == "dev=0,2,0" ) config->writeEntry("Device", "/dev/scd2");
	if ( config->readEntry("Device") == "dev=0,3,0" ) config->writeEntry("Device", "/dev/scd3");
	if ( config->readEntry("Device") == "dev=0,4,0" ) config->writeEntry("Device", "/dev/scd4");
	if ( config->readEntry("Device") == "dev=0,5,0" ) config->writeEntry("Device", "/dev/scd5");
	if ( config->readEntry("Device") == "dev=0,6,0" ) config->writeEntry("Device", "/dev/scd6");
	if ( config->readEntry("Device") == "dev=0,7,0" ) config->writeEntry("Device", "/dev/scd7");
	if ( config->readEntry("Name") == "ATAPI CD-ROM" ) config->writeEntry("Device", "/dev/cdrom");

   	close( true );
}

// 'Exit-Button' clicked
void Setup::slotQuit(){
	close( true );
}
