/***************************************************************************
                          simplekfvdialog.cpp  -  description                              
                             -------------------                                         
    begin                : Sat Aug 21 1999                                           
    copyright            : (C) 1999 by Jens Wilhelm Wulf                         
    email                : jens_w2@gmx.net                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "simplekfvdialog.h"

simplekfvdialog::simplekfvdialog(QWidget *parent, const char *name) : QDialog(parent,name,false)
{
  this->resize(420,400);
  this->setMinimumSize(0,0);
  this->setMaximumSize(420,400);
  QListBox_1= new QListBox(this,"NoName");
  QListBox_1->setGeometry(10,10,400,340);
  QListBox_1->setMinimumSize(0,0);

  QPushButton_1= new QPushButton(this,"NoName");
  QPushButton_1->setGeometry(230,360,180,30);
  QPushButton_1->setMinimumSize(0,0);
  QPushButton_1->setText(i18n("transfer highlighted"));

  QPushButton_2= new QPushButton(this,"NoName");
  QPushButton_2->setGeometry(10,360,60,30);
  QPushButton_2->setMinimumSize(0,0);
  QPushButton_2->setText(i18n("root-dir"));

  aktVerz = "";
  zeigVerz("/\0");
  connect(QListBox_1, SIGNAL(selected(const char*)), SLOT(zeigVerz(const char*)));
  connect(QPushButton_2, SIGNAL(clicked()), SLOT(toRootDir()));
  connect(QPushButton_1, SIGNAL(clicked()), SLOT(transfer()));
}

simplekfvdialog::~simplekfvdialog()
{
}

void simplekfvdialog::toRootDir()
{
  aktVerz = "";
  zeigVerz("/\0");  
}

void simplekfvdialog::transfer()
{
  string tmp;
  
  tmp = QListBox_1->text(QListBox_1->currentItem());
  if (tmp[tmp.length()-1] != '/') tmp.replace(0, 4, "");
  tmp = "file:" + aktVerz + tmp;
  //  cout << "transfer:" << tmp << "\n";
  emit fileDrop(tmp);
}

void simplekfvdialog::zeigVerz(const char* Name)
{
  DIR*            Verz;                 // der VerzeichnisStrom
  dirent*         VerzEintr;            // hier werden die Daten aus obigem gegeben
  struct stat     Attribs;              // ein Puffer fr die Dateiattribute
  string          iName;

  //  cout << "Name: " << Name << "\n";

  iName = Name;
  if (!(aktVerz == "/" && iName == "../") && iName[iName.length()-1] == '/' && iName != "./")
    {     
      if (iName == "../")
	{
	  aktVerz.replace(aktVerz.length()-1, 1, "");
	  while (aktVerz[aktVerz.length()-1] != '/')
	    aktVerz.replace(aktVerz.length()-1, 1, "");
	}
      else 
	{
	  aktVerz += iName;
	  /*
	  prevItemNr = QListBox_1->currentItem();
	  cout << "setze prevItemNr auf " << prevItemNr << "\n";
	  */
	}

      //      cout << "neues Verz: " << aktVerz << "\n";
      
      QListBox_1->clear();
      
      Verz = opendir(aktVerz.c_str());
      if (Verz != 0) 
	{
	  VerzEintr = new dirent;
	  
	  while ((VerzEintr = readdir(Verz)) != NULL) 
	    {
	      {
		string tmp = aktVerz;
		
		tmp += VerzEintr->d_name;
		stat(tmp.c_str(), &Attribs);
	      }
	      
	      if (S_ISDIR(Attribs.st_mode) != 0) 
		{
		  // Es ist ein Verzeichnis!
		  string tmp = VerzEintr->d_name;
		  
		  tmp += "/";	  
		  QListBox_1->inSort(tmp.c_str());	  
		}
	      if (S_ISREG(Attribs.st_mode) != 0) 
		{
		  // Es ist eine Datei! (oder auch ein verfolgtes Link... s.o.)
		  string tmp = VerzEintr->d_name;
		  tmp = "    " + tmp;
		  QListBox_1->inSort(tmp.c_str());
		}
	    }
	  delete VerzEintr;
	  closedir(Verz);
	  /*
	  if (iName == "../") 
	    {
	      QListBox_1->setSelected(prevItemNr, true);
	      QListBox_1->setCurrentItem(prevItemNr);
	      QListBox_1->centerCurrentItem();
	      cout << "setze auf " << prevItemNr << "\n";
	    }
	  */
	}
      else 
	{
	  string tmp = i18n("unable to open dir:\n") + aktVerz;
	  fehlermeldung((char *)tmp.c_str());
	}  
    }
}

#include "simplekfvdialog.moc"
  






